/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.core;

import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.BalloonSettings;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientSettings;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.FinalizeData;
import edu.csus.ecs.pc2.core.model.Group;
import edu.csus.ecs.pc2.core.model.IElementObject;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.ISubmission;
import edu.csus.ecs.pc2.core.model.Judgement;
import edu.csus.ecs.pc2.core.model.Language;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.model.ProblemDataFiles;
import edu.csus.ecs.pc2.core.model.ProblemDataFilesList;
import edu.csus.ecs.pc2.core.model.Profile;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.Site;
import edu.csus.ecs.pc2.core.packet.Packet;
import edu.csus.ecs.pc2.core.packet.PacketFactory;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.transport.ConnectionHandlerID;
import java.io.IOException;
import java.util.GregorianCalendar;

public class ContestLoader {
    protected void addAllAccountsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
            if (accounts != null) {
                for (Account account : accounts) {
                    if (this.isServer(contest)) {
                        if (this.isThisSite(contest, account)) continue;
                        contest.updateAccount(account);
                        continue;
                    }
                    contest.updateAccount(account);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllClarificationsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Clarification[] clarifications = (Clarification[])PacketFactory.getObjectValue(packet, "CLARIFICATION_LIST");
            if (clarifications != null) {
                for (Clarification clarification : clarifications) {
                    if (this.isServer(contest) && this.isThisSite(contest, clarification)) continue;
                    if (contest.getClarification(clarification.getElementId()) != null) {
                        contest.updateClarification(clarification, null);
                        continue;
                    }
                    contest.addClarification(clarification);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllClientSettingsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ClientSettings[] clientSettings = (ClientSettings[])PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS_LIST");
            if (clientSettings != null) {
                for (ClientSettings clientSettings2 : clientSettings) {
                    ClientId clientId = clientSettings2.getClientId();
                    if (this.isServer(contest)) {
                        if (this.isThisSite(contest, clientId)) continue;
                        contest.updateClientSettings(clientSettings2);
                        continue;
                    }
                    contest.updateClientSettings(clientSettings2);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllConnectionIdsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ConnectionHandlerID[] connectionHandlerIDs = (ConnectionHandlerID[])PacketFactory.getObjectValue(packet, "CONNECTION_HANDLE_ID_LIST");
            if (connectionHandlerIDs != null) {
                for (ConnectionHandlerID connectionHandlerID : connectionHandlerIDs) {
                    contest.connectionEstablished(connectionHandlerID);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllContestTimesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ContestTime[] contestTimes = (ContestTime[])PacketFactory.getObjectValue(packet, "CONTEST_TIME_LIST");
            if (contestTimes != null) {
                for (ContestTime contestTime : contestTimes) {
                    if (contest.getSiteNumber() == contestTime.getSiteNumber()) continue;
                    if (contest.getContestTime(contestTime.getSiteNumber()) != null) {
                        contest.updateContestTime(contestTime);
                        continue;
                    }
                    contest.addContestTime(contestTime);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addAllRunsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Run[] runs = (Run[])PacketFactory.getObjectValue(packet, "RUN_LIST");
            if (runs != null) {
                for (Run run : runs) {
                    if (this.isServer(contest) && this.isThisSite(contest, run)) continue;
                    contest.addRun(run);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addBalloonSettingsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            BalloonSettings[] balloonSettings = (BalloonSettings[])PacketFactory.getObjectValue(packet, "BALLOON_SETTINGS_LIST");
            if (balloonSettings != null) {
                for (BalloonSettings balloonSettings2 : balloonSettings) {
                    contest.updateBalloonSettings(balloonSettings2);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addContestInformationToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ContestInformation contestInformation = (ContestInformation)PacketFactory.getObjectValue(packet, "CONTEST_INFORMATION");
            if (contestInformation != null) {
                contest.updateContestInformation(contestInformation);
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void setFinalizeData(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            FinalizeData finalizeData = (FinalizeData)PacketFactory.getObjectValue(packet, "FINALIZE_DATA");
            if (finalizeData != null) {
                contest.setFinalizeData(finalizeData);
                if (finalizeData.isCertified()) {
                    controller.getLog().log(Log.INFO, "Contest Certified by '" + finalizeData.getComment() + "'");
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged in load Finalize Data ", e);
        }
    }

    protected void addGeneralProblemToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Problem generalProblem = (Problem)PacketFactory.getObjectValue(packet, "GENERAL_PROBLEM");
            if (generalProblem != null) {
                contest.setGeneralProblem(generalProblem);
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged in General Problem ", e);
        }
    }

    protected void addGroupsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Group[] groups = (Group[])PacketFactory.getObjectValue(packet, "GROUP_LIST");
            if (groups != null) {
                for (Group group : groups) {
                    if (contest.getGroup(group.getElementId()) != null) {
                        contest.updateGroup(group);
                        continue;
                    }
                    contest.addGroup(group);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addJudgementsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Judgement[] judgements = (Judgement[])PacketFactory.getObjectValue(packet, "JUDGEMENT_LIST");
            if (judgements != null) {
                for (Judgement judgement : judgements) {
                    if (contest.getJudgement(judgement.getElementId()) != null) {
                        contest.updateJudgement(judgement);
                        continue;
                    }
                    contest.addJudgement(judgement);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addLanguagesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Language[] languages = (Language[])PacketFactory.getObjectValue(packet, "LANGUAGE_LIST");
            if (languages != null) {
                for (Language language : languages) {
                    if (contest.getLanguage(language.getElementId()) != null) {
                        contest.updateLanguage(language);
                        continue;
                    }
                    contest.addLanguage(language);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addLoginsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ConnectionHandlerID fakeId;
            ClientId[] clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "REMOTE_LOGGED_IN_USERS");
            if (clientIds != null) {
                for (ClientId clientId : clientIds) {
                    try {
                        if (this.isServer(contest)) {
                            if (contest.isLocalLoggedIn(clientId) || this.isThisSite(contest, clientId)) continue;
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                            contest.addRemoteLogin(clientId, fakeId);
                            continue;
                        }
                        fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                        contest.addRemoteLogin(clientId, fakeId);
                    }
                    catch (Exception e) {
                        controller.logWarning("Exception in adding login to model ", e);
                    }
                }
            }
            if ((clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "LOCAL_LOGGED_IN_USERS")) != null) {
                for (ClientId clientId : clientIds) {
                    try {
                        if (this.isServer(contest)) {
                            if (contest.isLocalLoggedIn(clientId) || this.isThisSite(contest, clientId)) continue;
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                            contest.addRemoteLogin(clientId, fakeId);
                            continue;
                        }
                        fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                        contest.addLocalLogin(clientId, fakeId);
                    }
                    catch (Exception e) {
                        controller.logWarning("Exception in adding login to model ", e);
                    }
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception in adding logins to model ", e);
        }
    }

    protected void addProblemsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        ProblemDataFilesList problemDataFilesList = new ProblemDataFilesList();
        try {
            ProblemDataFiles[] problemDataFiles = (ProblemDataFiles[])PacketFactory.getObjectValue(packet, "PROBLEM_DATA_FILES");
            if (problemDataFiles != null) {
                for (IElementObject iElementObject : problemDataFiles) {
                    problemDataFilesList.add(iElementObject);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
        try {
            Problem[] problems = (Problem[])PacketFactory.getObjectValue(packet, "PROBLEM_LIST");
            if (problems != null) {
                for (IElementObject iElementObject : problems) {
                    ProblemDataFiles problemDataFiles = (ProblemDataFiles)problemDataFilesList.get(iElementObject);
                    if (contest.getProblem(((Problem)iElementObject).getElementId()) != null) {
                        if (problemDataFiles == null) {
                            contest.updateProblem((Problem)iElementObject);
                            continue;
                        }
                        contest.updateProblem((Problem)iElementObject, problemDataFiles);
                        continue;
                    }
                    if (problemDataFiles == null) {
                        contest.addProblem((Problem)iElementObject);
                        continue;
                    }
                    contest.addProblem((Problem)iElementObject, problemDataFiles);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addProfilesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Profile[] profiles = (Profile[])PacketFactory.getObjectValue(packet, "PROFILE_LIST");
            if (profiles != null) {
                for (Profile profile : profiles) {
                    contest.updateProfile(profile);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteAccountsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
            if (accounts != null) {
                for (Account account : accounts) {
                    if (remoteSiteNumber != account.getSiteNumber()) continue;
                    contest.updateAccount(account);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    public void loadIfMissingAccountToModel(IInternalContest contest, IInternalController controller, Packet packet, ClientType.Type type) {
        try {
            int siteNumber = contest.getSiteNumber();
            int count = contest.getAccounts(type, siteNumber).size();
            int numAdded = 0;
            if (count == 0) {
                Account[] accounts = (Account[])PacketFactory.getObjectValue(packet, "ACCOUNT_ARRAY");
                if (accounts != null) {
                    for (Account account : accounts) {
                        if (siteNumber != account.getSiteNumber() || !account.getClientId().getClientType().equals((Object)type) || contest.getAccount(account.getClientId()) != null) continue;
                        contest.updateAccount(account);
                        ++numAdded;
                    }
                }
                controller.getLog().log(Log.INFO, "Loaded " + numAdded + " " + (Object)((Object)type) + " Accounts for site " + siteNumber);
            } else {
                controller.getLog().log(Log.INFO, "No accounts loaded " + count + " accounts exists for site " + siteNumber);
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteAllClientSettingsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            ClientSettings[] clientSettings = (ClientSettings[])PacketFactory.getObjectValue(packet, "CLIENT_SETTINGS_LIST");
            if (clientSettings != null) {
                for (ClientSettings clientSettings2 : clientSettings) {
                    if (remoteSiteNumber != clientSettings2.getSiteNumber()) continue;
                    contest.updateClientSettings(clientSettings2);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteClarificationsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            Clarification[] clarifications = (Clarification[])PacketFactory.getObjectValue(packet, "CLARIFICATION_LIST");
            if (clarifications != null) {
                for (Clarification clarification : clarifications) {
                    if (remoteSiteNumber != clarification.getSiteNumber()) continue;
                    contest.addClarification(clarification);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteContestTimesToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            ContestTime[] contestTimes = (ContestTime[])PacketFactory.getObjectValue(packet, "CONTEST_TIME_LIST");
            if (contestTimes != null) {
                for (ContestTime contestTime : contestTimes) {
                    if (remoteSiteNumber != contestTime.getSiteNumber()) continue;
                    if (contest.getContestTime(contestTime.getSiteNumber()) != null) {
                        contest.updateContestTime(contestTime);
                        continue;
                    }
                    contest.addContestTime(contestTime);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addRemoteLoginsToModel(IInternalContest contest, IInternalController controller, Packet packet, int remoteSiteNumber) {
        try {
            ConnectionHandlerID fakeId;
            ClientId[] clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "LOCAL_LOGGED_IN_USERS");
            if (clientIds != null) {
                for (ClientId clientId : clientIds) {
                    try {
                        if (this.isServer(clientId)) {
                            if (contest.isLocalLoggedIn(clientId) || this.isThisSite(contest, clientId)) continue;
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                            contest.addRemoteLogin(clientId, fakeId);
                            continue;
                        }
                        if (remoteSiteNumber != clientId.getSiteNumber()) continue;
                        fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + "-" + clientId);
                        contest.addRemoteLogin(clientId, fakeId);
                    }
                    catch (Exception e) {
                        controller.logWarning("Exception while adding remote login ", e);
                    }
                }
            }
            if ((clientIds = (ClientId[])PacketFactory.getObjectValue(packet, "REMOTE_LOGGED_IN_USERS")) != null) {
                for (ClientId clientId : clientIds) {
                    try {
                        if (this.isServer(clientId)) {
                            if (contest.isLocalLoggedIn(clientId) || this.isThisSite(contest, clientId)) continue;
                            fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + clientId);
                            contest.addRemoteLogin(clientId, fakeId);
                            continue;
                        }
                        if (remoteSiteNumber != clientId.getSiteNumber()) continue;
                        fakeId = new ConnectionHandlerID("FauxSite" + clientId.getSiteNumber() + "-" + clientId);
                        contest.addRemoteLogin(clientId, fakeId);
                    }
                    catch (Exception e) {
                        controller.logWarning("Exception while adding remote login ", e);
                    }
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception while adding remote logins ", e);
        }
    }

    protected void addRemoteRunsToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Run[] runs = (Run[])PacketFactory.getObjectValue(packet, "RUN_LIST");
            if (runs != null) {
                for (Run run : runs) {
                    if (this.isThisSite(contest, run.getSiteNumber())) continue;
                    contest.updateRun(run, packet.getSourceId());
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void addSitesToModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            Site[] sites = (Site[])PacketFactory.getObjectValue(packet, "SITE_LIST");
            if (sites != null) {
                for (Site site : sites) {
                    contest.updateSite(site);
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    protected void initializeContestTime(IInternalContest contest, IInternalController controller, Packet packet) {
        if (this.isServer(contest) && contest.getContestTime() == null) {
            ContestTime contestTime = new ContestTime(contest.getSiteNumber());
            contest.addContestTime(contestTime);
        }
    }

    private boolean isServer(ClientId id) {
        return id != null && id.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private boolean isServer(IInternalContest contest) {
        ClientId id = contest.getClientId();
        return id != null && id.getClientType().equals((Object)ClientType.Type.SERVER);
    }

    private boolean isThisSite(IInternalContest contest, Account account) {
        return account.getSiteNumber() == contest.getSiteNumber();
    }

    private boolean isThisSite(IInternalContest contest, ClientId id) {
        return this.isThisSite(contest, id.getSiteNumber());
    }

    private boolean isThisSite(IInternalContest contest, int siteNumber) {
        return siteNumber == contest.getSiteNumber();
    }

    private boolean isThisSite(IInternalContest contest, ISubmission submission) {
        return submission.getSiteNumber() == contest.getSiteNumber();
    }

    protected void updateContestTimeInModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            ContestTime contestTime = (ContestTime)PacketFactory.getObjectValue(packet, "CONTEST_TIME");
            if (contestTime != null) {
                if (this.isServer(contest)) {
                    if (this.isThisSite(contest, contestTime.getSiteNumber())) {
                        controller.setContestTime(contestTime);
                    } else if (contest.getContestTime(contestTime.getSiteNumber()) == null) {
                        contest.addContestTime(contestTime);
                    } else {
                        contest.updateContestTime(contestTime);
                    }
                } else {
                    GregorianCalendar serverTransmitTime = (GregorianCalendar)PacketFactory.getObjectValue(packet, "SERVER_CLOCK_OFFSET");
                    contestTime.calculateLocalClockOffset(serverTransmitTime);
                    if (contest.getContestTime(contestTime.getSiteNumber()) == null) {
                        contest.addContestTime(contestTime);
                    } else {
                        contest.updateContestTime(contestTime);
                    }
                }
            }
        }
        catch (Exception e) {
            controller.logWarning("Exception logged ", e);
        }
    }

    public void loadDataIntoModel(IInternalContest contest, IInternalController controller, Packet packet, ConnectionHandlerID connectionHandlerID) throws IOException, ClassNotFoundException, FileSecurityException {
        ClientId who = packet.getDestinationId();
        if (who != null) {
            contest.setClientId(who);
        }
        controller.setSiteNumber(who.getSiteNumber());
        this.setProfileIntoModel(contest, controller, packet);
        this.addSitesToModel(contest, controller, packet);
        if (this.isServer(contest)) {
            controller.initializeServer(contest);
        }
        this.addLanguagesToModel(contest, controller, packet);
        this.addProblemsToModel(contest, controller, packet);
        this.addGroupsToModel(contest, controller, packet);
        this.addJudgementsToModel(contest, controller, packet);
        this.updateContestTimeInModel(contest, controller, packet);
        this.addContestInformationToModel(contest, controller, packet);
        this.addAllClientSettingsToModel(contest, controller, packet);
        this.initializeContestTime(contest, controller, packet);
        this.addAllContestTimesToModel(contest, controller, packet);
        this.addAllRunsToModel(contest, controller, packet);
        this.addAllClarificationsToModel(contest, controller, packet);
        this.addAllAccountsToModel(contest, controller, packet);
        this.addAllConnectionIdsToModel(contest, controller, packet);
        this.addLoginsToModel(contest, controller, packet);
        this.addBalloonSettingsToModel(contest, controller, packet);
        this.addProfilesToModel(contest, controller, packet);
        this.addGeneralProblemToModel(contest, controller, packet);
        this.setFinalizeData(contest, controller, packet);
    }

    protected void setProfileIntoModel(IInternalContest contest, IInternalController controller, Packet packet) {
        try {
            String contestId = (String)PacketFactory.getObjectValue(packet, "CONTEST_IDENTIFIER");
            contest.setContestIdentifier(contestId);
            Profile newProfile = (Profile)PacketFactory.getObjectValue(packet, "NEW_PROFILE");
            Profile profile = (Profile)PacketFactory.getObjectValue(packet, "PROFILE");
            if (newProfile != null) {
                contest.setProfile(newProfile);
            } else if (profile != null) {
                contest.setProfile(profile);
            }
        }
        catch (Exception e) {
            controller.logWarning("Unable to load profile into model ", e);
        }
    }
}

