/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.ILanguage;
import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.api.IRun;
import edu.csus.ecs.pc2.api.IRunJudgement;
import edu.csus.ecs.pc2.api.ITeam;
import edu.csus.ecs.pc2.api.implementation.LanguageImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.implementation.RunJudgementImplemenation;
import edu.csus.ecs.pc2.api.implementation.TeamImplementation;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.PermissionGroup;
import edu.csus.ecs.pc2.core.list.JudgementNotificationsList;
import edu.csus.ecs.pc2.core.model.Account;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ContestInformation;
import edu.csus.ecs.pc2.core.model.ContestTime;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.IRunListener;
import edu.csus.ecs.pc2.core.model.JudgementRecord;
import edu.csus.ecs.pc2.core.model.Run;
import edu.csus.ecs.pc2.core.model.RunEvent;
import edu.csus.ecs.pc2.core.model.RunFiles;
import edu.csus.ecs.pc2.core.model.RunUtilities;
import edu.csus.ecs.pc2.core.model.SerializedFile;
import edu.csus.ecs.pc2.core.security.FileSecurityException;
import edu.csus.ecs.pc2.core.security.Permission;
import edu.csus.ecs.pc2.core.security.PermissionList;
import java.io.IOException;
import java.util.Vector;

public class RunImplementation
implements IRun {
    private boolean solved;
    private boolean deleted;
    private String judgementTitle = "";
    private ITeam submitterTeam;
    private IProblem problem;
    private ILanguage language;
    private int number;
    private int siteNumber;
    private long elapsedMins;
    private ElementId elementId;
    private RunFiles runFiles = null;
    private Boolean listening = new Boolean(true);
    private IInternalController controller = null;
    private FetchRunListenerImplemenation fetchRunListenerImplemenation = null;
    private IInternalContest internalContest = null;
    private boolean answerReceived = false;
    private Run run = null;
    private boolean preliminaryJudged = false;
    private boolean finalJudged = false;
    private PermissionList permissionList = new PermissionList();
    private boolean respectSendToTeam = false;

    public RunImplementation(Run inRun, IInternalContest internalContest, IInternalController controller) {
        this.controller = controller;
        this.internalContest = internalContest;
        this.respectSendToTeam = this.isAllowed(internalContest, internalContest.getClientId(), Permission.Type.RESPECT_NOTIFY_TEAM_SETTING);
        this.run = inRun;
        if (this.respectSendToTeam && inRun.getAllJudgementRecords().length > 0 && !inRun.getJudgementRecord().isSendToTeam()) {
            this.run = RunUtilities.createNewRun(inRun, internalContest);
        }
        this.deleted = this.run.isDeleted();
        this.submitterTeam = new TeamImplementation(this.run.getSubmitter(), internalContest);
        this.problem = new ProblemImplementation(this.run.getProblemId(), internalContest);
        this.language = new LanguageImplementation(this.run.getLanguageId(), internalContest);
        this.number = this.run.getNumber();
        this.siteNumber = this.run.getSiteNumber();
        this.elapsedMins = this.run.getElapsedMins();
        this.elementId = this.run.getElementId();
        IRunJudgement[] judgements = this.getRunJudgements();
        if (judgements.length > 0) {
            IRunJudgement lastRunJudgement = judgements[judgements.length - 1];
            this.solved = lastRunJudgement.isSolved();
            this.preliminaryJudged = lastRunJudgement.isPreliminaryJudgement();
            this.finalJudged = !this.preliminaryJudged;
            this.judgementTitle = this.getJudgementTitle(this.run);
        }
    }

    private void initializePermissions(IInternalContest theContest, ClientId clientId) {
        Account account = theContest.getAccount(clientId);
        if (account != null) {
            this.permissionList.clearAndLoadPermissions(account.getPermissionList());
        } else {
            this.permissionList.clearAndLoadPermissions(new PermissionGroup().getPermissionList(clientId.getClientType()));
        }
    }

    private boolean isAllowed(IInternalContest theContest, ClientId clientId, Permission.Type type) {
        this.initializePermissions(theContest, clientId);
        return this.permissionList.isAllowed(type);
    }

    private String getJudgementTitle(Run run2) {
        JudgementRecord judgementRecord = run2.getJudgementRecord();
        if (judgementRecord != null) {
            String judgementText = this.internalContest.getJudgement(judgementRecord.getJudgementId()).toString();
            String validatorJudgementName = judgementRecord.getValidatorResultString();
            if (judgementRecord.isUsedValidator() && validatorJudgementName != null) {
                if (validatorJudgementName.trim().length() == 0) {
                    validatorJudgementName = "undetermined";
                }
                judgementText = validatorJudgementName;
            }
            return judgementText;
        }
        return "";
    }

    public boolean isSolved() {
        return this.solved;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public ITeam getTeam() {
        return this.submitterTeam;
    }

    public String getJudgementName() {
        return this.judgementTitle;
    }

    public IProblem getProblem() {
        return this.problem;
    }

    public ILanguage getLanguage() {
        return this.language;
    }

    public int getNumber() {
        return this.number;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public long getSubmissionTime() {
        return this.elapsedMins;
    }

    public String[] getSourceCodeFileNames() {
        if (this.runFiles == null) {
            this.fetchRunFiles();
        }
        try {
            if (this.runFiles != null) {
                String[] names = new String[]{this.runFiles.getMainFile().getName()};
                SerializedFile[] files = this.runFiles.getOtherFiles();
                if (files != null) {
                    if (files.length > 0) {
                        names = new String[1 + files.length];
                        names[0] = this.runFiles.getMainFile().getName();
                        for (int i = 0; i < files.length; ++i) {
                            SerializedFile file = files[i];
                            names[i + 1] = file.getName();
                        }
                        return names;
                    }
                    return names;
                }
                return names;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String[0];
    }

    public byte[][] getSourceCodeFileContents() {
        if (this.runFiles == null) {
            this.fetchRunFiles();
        }
        if (this.runFiles != null) {
            Object fileContents = new byte[1][64000];
            fileContents[0] = this.runFiles.getMainFile().getBuffer();
            SerializedFile[] files = this.runFiles.getOtherFiles();
            if (files != null) {
                if (files.length > 0) {
                    fileContents = new byte[1 + files.length][];
                    fileContents[0] = this.runFiles.getMainFile().getBuffer();
                    for (int i = 0; i < files.length; ++i) {
                        SerializedFile file = files[i];
                        fileContents[i + 1] = file.getBuffer();
                    }
                    return fileContents;
                }
                return fileContents;
            }
            return fileContents;
        }
        return new byte[0][0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchRunFiles() {
        if (this.runFiles != null) {
            return;
        }
        if (this.fetchRunListenerImplemenation == null) {
            this.fetchRunListenerImplemenation = new FetchRunListenerImplemenation();
            this.internalContest.addRunListener(this.fetchRunListenerImplemenation);
        }
        try {
            this.controller.fetchRun(this.run);
            Boolean bl = this.listening;
            synchronized (bl) {
                while (!this.answerReceived) {
                    try {
                        this.listening.wait();
                    }
                    catch (InterruptedException e) {
                        this.listening.booleanValue();
                    }
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (FileSecurityException e1) {
            e1.printStackTrace();
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof RunImplementation) {
            RunImplementation runImplementation = (RunImplementation)obj;
            return runImplementation.elementId.equals(this.elementId);
        }
        return false;
    }

    public int hashCode() {
        return this.elementId.toString().hashCode();
    }

    protected boolean isAllowed(Permission.Type type) {
        PermissionList newPermissionList = new PermissionList();
        Account account = this.internalContest.getAccount(this.internalContest.getClientId());
        if (account != null) {
            newPermissionList.clearAndLoadPermissions(account.getPermissionList());
        } else {
            newPermissionList.clearAndLoadPermissions(new PermissionGroup().getPermissionList(this.internalContest.getClientId().getClientType()));
        }
        return newPermissionList.isAllowed(type);
    }

    public IRunJudgement[] getRunJudgements() {
        Vector<RunJudgementImplemenation> vector = new Vector<RunJudgementImplemenation>();
        if (this.run != null && this.run.isJudged()) {
            JudgementRecord[] records = this.run.getAllJudgementRecords();
            ContestInformation contestInformation = this.internalContest.getContestInformation();
            JudgementNotificationsList judgementNotificationsList = contestInformation.getJudgementNotificationsList();
            ContestTime contestTime = this.internalContest.getContestTime();
            boolean respectEOCSetting = this.isAllowed(Permission.Type.RESPECT_EOC_SUPPRESSION);
            for (int i = 0; i < records.length; ++i) {
                if (!respectEOCSetting) {
                    vector.addElement(new RunJudgementImplemenation(records[i], this.run, this.internalContest, this.controller));
                    continue;
                }
                if (RunUtilities.supppressJudgement(judgementNotificationsList, this.run, contestTime)) continue;
                vector.addElement(new RunJudgementImplemenation(records[i], this.run, this.internalContest, this.controller));
            }
        }
        return vector.toArray(new RunJudgementImplemenation[vector.size()]);
    }

    public boolean isFinalJudged() {
        return this.finalJudged;
    }

    public boolean isPreliminaryJudged() {
        return this.preliminaryJudged;
    }

    protected class FetchRunListenerImplemenation
    implements IRunListener {
        protected FetchRunListenerImplemenation() {
        }

        public void runAdded(RunEvent event) {
            this.runChanged(event);
        }

        public void refreshRuns(RunEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runChanged(RunEvent event) {
            if (event.getRun().getElementId().equals(RunImplementation.this.elementId)) {
                RunImplementation.this.runFiles = event.getRunFiles();
                Boolean bl = RunImplementation.this.listening;
                synchronized (bl) {
                    try {
                        RunImplementation.this.answerReceived = true;
                        RunImplementation.this.listening.notify();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public void runRemoved(RunEvent event) {
        }
    }
}

