/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClient;
import edu.csus.ecs.pc2.api.IProblemDetails;
import edu.csus.ecs.pc2.api.IStanding;
import edu.csus.ecs.pc2.api.implementation.ClientImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemDetailsComparator;
import edu.csus.ecs.pc2.api.implementation.ProblemDetailsImplementation;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.implementation.StandingImplementation;
import edu.csus.ecs.pc2.core.log.Log;
import edu.csus.ecs.pc2.core.model.ClientId;
import edu.csus.ecs.pc2.core.model.ClientType;
import edu.csus.ecs.pc2.core.model.ElementId;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import edu.csus.ecs.pc2.core.model.Problem;
import edu.csus.ecs.pc2.core.scoring.DefaultScoringAlgorithm;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenerateStandings {
    private ProblemDetailsComparator detailsComparator = new ProblemDetailsComparator();

    private String[] fetchStandingRow(Node node) {
        String[] outArray = new String[7];
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node standingNode = attributes.item(i);
            String value = standingNode.getNodeValue();
            String name = standingNode.getNodeName();
            if (name.equals("rank")) {
                outArray[0] = value;
                continue;
            }
            if (name.equals("teamName")) {
                outArray[1] = value;
                continue;
            }
            if (name.equals("solved")) {
                outArray[2] = value;
                continue;
            }
            if (name.equals("points")) {
                outArray[3] = value;
                continue;
            }
            if (name.equals("teamId")) {
                outArray[4] = value;
                continue;
            }
            if (name.equals("teamSiteId")) {
                outArray[5] = value;
                continue;
            }
            if (!name.equals("teamKey")) continue;
            outArray[6] = value;
        }
        return outArray;
    }

    IProblemDetails[] getDetails(IClient client, IProblemDetails[] detailList) {
        Vector<IProblemDetails> outvect = new Vector<IProblemDetails>();
        for (IProblemDetails d : detailList) {
            if (d.getClient().getAccountNumber() != client.getAccountNumber() || d.getClient().getSiteNumber() != client.getSiteNumber()) continue;
            outvect.add(d);
        }
        IProblemDetails[] details = outvect.toArray(new IProblemDetails[outvect.size()]);
        Arrays.sort(details, this.detailsComparator);
        return details;
    }

    public void updateProblemDetails(StandingImplementation[] standingsList, IProblemDetails[] detailsList) {
        for (StandingImplementation standings : standingsList) {
            IProblemDetails[] details = this.getDetails(standings.getClient(), detailsList);
            standings.setProblemDetails(details);
        }
    }

    public IProblemDetails[] getProblemDetails(IInternalContest contest, String xmlString, Log log) throws ParserConfigurationException, SAXException, IOException {
        Vector<IProblemDetails> details = new Vector<IProblemDetails>();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
        NodeList list = document.getDocumentElement().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            String name = node.getNodeName();
            if (!name.equals("teamStanding")) continue;
            try {
                IProblemDetails[] clientProblemDetails;
                String[] cols = this.fetchStandingRow(node);
                int clientNumber = Integer.parseInt(cols[4]);
                int siteNumber = Integer.parseInt(cols[5]);
                ClientId clientId = new ClientId(siteNumber, ClientType.Type.TEAM, clientNumber);
                ClientImplementation client = new ClientImplementation(clientId, contest);
                for (IProblemDetails problemDetails : clientProblemDetails = this.getClientProblemDetails(contest, client, node)) {
                    details.add(problemDetails);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.log(Log.WARNING, "Exception while parsing/generating standings row ", e);
            }
        }
        return details.toArray(new IProblemDetails[details.size()]);
    }

    public IProblemDetails[] getProblemDetails(IInternalContest contest, Log log) {
        String xmlString = null;
        try {
            DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
            xmlString = defaultScoringAlgorithm.getStandings(contest, new Properties(), log);
            return this.getProblemDetails(contest, xmlString, log);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Log.WARNING, "Exception logged ", e);
            return new IProblemDetails[0];
        }
    }

    private IProblemDetails[] getClientProblemDetails(IInternalContest contest, IClient clientId, Node parentNode) {
        Vector<ProblemDetailsImplementation> detailsList = new Vector<ProblemDetailsImplementation>();
        NodeList nodeList = parentNode.getChildNodes();
        Problem[] problems = contest.getProblems();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ProblemDetailsImplementation problemDetails;
            Node node = nodeList.item(i);
            String nodeName = node.getNodeName();
            if (!nodeName.equals("problemSummaryInfo") || (problemDetails = this.getClientProblemDetails(node, clientId)).getProblemId() == -1 || problemDetails.getProblemId() >= problems.length - 1) continue;
            ElementId elementId = problems[problemDetails.getProblemId()].getElementId();
            ProblemImplementation problemImplementation = new ProblemImplementation(elementId, contest);
            problemDetails.setProblem(problemImplementation);
            detailsList.add(problemDetails);
        }
        return detailsList.toArray(new IProblemDetails[detailsList.size()]);
    }

    ProblemDetailsImplementation getClientProblemDetails(Node parentNode, IClient clientId) {
        ProblemDetailsImplementation problemDetailsImplementation = new ProblemDetailsImplementation(clientId);
        NamedNodeMap attributes = parentNode.getAttributes();
        for (int j = 0; j < attributes.getLength(); ++j) {
            Node problemNode = attributes.item(j);
            String name = problemNode.getNodeName();
            String value = problemNode.getNodeValue();
            int intvalue = 0;
            try {
                intvalue = Integer.parseInt(value);
            }
            catch (Exception e) {
                intvalue = -1;
            }
            if (name.equals("index")) {
                problemDetailsImplementation.setProblemId(intvalue);
                continue;
            }
            if (name.equals("attempts")) {
                problemDetailsImplementation.setAttempts(intvalue);
                continue;
            }
            if (name.equals("isSolved")) {
                problemDetailsImplementation.setSolved(value.equals("true"));
                continue;
            }
            if (name.equals("points")) {
                problemDetailsImplementation.setPenaltyPoints(intvalue);
                continue;
            }
            if (!name.equals("solutionTime")) continue;
            problemDetailsImplementation.setSolutionTime(intvalue);
        }
        return problemDetailsImplementation;
    }

    public IStanding[] getStandings(IInternalContest contest, Log log) {
        Document document = null;
        String xmlString = null;
        Vector<StandingImplementation> standings = new Vector<StandingImplementation>();
        try {
            DefaultScoringAlgorithm defaultScoringAlgorithm = new DefaultScoringAlgorithm();
            xmlString = defaultScoringAlgorithm.getStandings(contest, new Properties(), log);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new InputSource(new StringReader(xmlString)));
            NodeList list = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (!name.equals("teamStanding")) continue;
                try {
                    String[] cols = this.fetchStandingRow(node);
                    int rank = Integer.parseInt(cols[0]);
                    int numProblemsSolved = Integer.parseInt(cols[2]);
                    int penaltyPoints = Integer.parseInt(cols[3]);
                    int clientNumber = Integer.parseInt(cols[4]);
                    int siteNumber = Integer.parseInt(cols[5]);
                    ClientId clientId = new ClientId(siteNumber, ClientType.Type.TEAM, clientNumber);
                    ClientImplementation client = new ClientImplementation(clientId, contest);
                    IProblemDetails[] clientProblemDetails = this.getClientProblemDetails(contest, client, node);
                    StandingImplementation standingImplementation = new StandingImplementation(contest, clientId, rank, numProblemsSolved, penaltyPoints);
                    standingImplementation.setProblemDetails(clientProblemDetails);
                    standings.addElement(standingImplementation);
                    continue;
                }
                catch (Exception e) {
                    log.log(Log.WARNING, "Exception while parsing/generating standings row ", e);
                }
            }
        }
        catch (Exception e) {
            log.log(Log.WARNING, "Exception logged ", e);
        }
        return standings.toArray(new StandingImplementation[standings.size()]);
    }
}

