/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClarificationEventListener;
import edu.csus.ecs.pc2.api.implementation.ClarificationImplementation;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.ClarificationEvent;
import edu.csus.ecs.pc2.core.model.IClarificationListener;
import edu.csus.ecs.pc2.core.model.IInternalContest;
import java.util.Vector;

public class ClarificationListenerList {
    private Vector<IClarificationEventListener> listenerList = new Vector();
    private IInternalContest contest = null;
    private IInternalController controller = null;

    private void fireClarificationListener(ClarificationEvent clarificationEvent) {
        block6: for (int i = 0; i < this.listenerList.size(); ++i) {
            ClarificationImplementation clarification = new ClarificationImplementation(clarificationEvent.getClarification(), this.contest, this.controller);
            switch (clarificationEvent.getAction()) {
                case ADDED: {
                    this.listenerList.elementAt(i).clarificationAdded(clarification);
                    continue block6;
                }
                case DELETED: {
                    this.listenerList.elementAt(i).clarificationRemoved(clarification);
                    continue block6;
                }
                case ANSWERED_CLARIFICATION: {
                    this.listenerList.elementAt(i).clarificationAnswered(clarification);
                    continue block6;
                }
                case CHECKEDOUT_REANSWER_CLARIFICATION: 
                case CHANGED: 
                case CHECKEDOUT_CLARIFICATION: 
                case CLARIFICATION_AVAILABLE: 
                case CLARIFICATION_REVOKED: 
                case CLARIFICATION_HELD: 
                case CLARIFICATION_NOT_AVAILABLE: 
                case REFRESH_ALL: {
                    continue block6;
                }
            }
        }
    }

    public void addClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.listenerList.add(clarificationEventListener);
    }

    public IInternalContest getContest() {
        return this.contest;
    }

    public void setContestAndController(IInternalContest inContest, IInternalController inController) {
        this.contest = inContest;
        this.controller = inController;
        this.contest.addClarificationListener(new Listener());
    }

    public void removeClarificationListener(IClarificationEventListener clarificationEventListener) {
        this.listenerList.remove(clarificationEventListener);
    }

    class Listener
    implements IClarificationListener {
        Listener() {
        }

        public void clarificationAdded(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }

        public void refreshClarfications(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }

        public void clarificationChanged(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }

        public void clarificationRemoved(ClarificationEvent event) {
            ClarificationListenerList.this.fireClarificationListener(event);
        }
    }
}

