/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2.api.implementation;

import edu.csus.ecs.pc2.api.IClarification;
import edu.csus.ecs.pc2.api.IProblem;
import edu.csus.ecs.pc2.api.ITeam;
import edu.csus.ecs.pc2.api.implementation.ProblemImplementation;
import edu.csus.ecs.pc2.api.implementation.TeamImplementation;
import edu.csus.ecs.pc2.core.IInternalController;
import edu.csus.ecs.pc2.core.model.Clarification;
import edu.csus.ecs.pc2.core.model.IInternalContest;

public class ClarificationImplementation
implements IClarification {
    private boolean answered = false;
    private String question = null;
    private String answer = null;
    private boolean deleted;
    private ITeam team = null;
    private IProblem problem = null;
    private int number;
    private int siteNumber;
    private long submissionTime;

    public ClarificationImplementation(Clarification clarification, IInternalContest contest, IInternalController controller) {
        this.answered = clarification.isAnswered();
        this.question = new String(clarification.getQuestion());
        this.answer = null;
        if (clarification.getAnswer() != null) {
            this.answer = new String(clarification.getAnswer());
        }
        this.deleted = clarification.isDeleted();
        this.team = new TeamImplementation(clarification.getSubmitter(), contest);
        this.problem = new ProblemImplementation(clarification.getProblemId(), contest);
        this.number = clarification.getNumber();
        this.siteNumber = clarification.getSiteNumber();
        this.submissionTime = clarification.getElapsedMins();
    }

    public String getAnswer() {
        return this.answer;
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int getNumber() {
        return this.number;
    }

    public IProblem getProblem() {
        return this.problem;
    }

    public String getQuestion() {
        return this.question;
    }

    public int getSiteNumber() {
        return this.siteNumber;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public ITeam getTeam() {
        return this.team;
    }
}

