/*
 * Decompiled with CFR 0.152.
 */
package edu.csus.ecs.pc2;

import edu.csus.ecs.pc2.core.Utilities;
import edu.csus.ecs.pc2.core.log.Log;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class VersionInfo {
    private static final String VERSION_FILENAME = "VERSION";
    private static String versionNumber = "9";
    private static String versionDate = "";
    private String contactEMail = "mailto:pc2@ecs.csus.edu";
    private static String buildNumber = "";
    private static boolean versionFileRead = false;
    private String manifestSpecificationVersion = "";
    private String manifestImplementationVersion = "";

    public VersionInfo() {
        if (buildNumber.equals("")) {
            this.loadVersionInfoFromFile(this.locateHome() + File.separator + VERSION_FILENAME);
            int violation = this.checkAgainstManifest();
            if (violation == 1) {
                int versionWithoutDate = this.getVersionNumber().indexOf(32);
                System.out.println("Problem with version numbers.  Expected " + this.getVersionNumber().substring(0, versionWithoutDate) + ", but got " + this.manifestSpecificationVersion);
                System.exit(1);
            }
            if (violation == 2) {
                System.out.println("Problem with build numbers.  Expected " + this.getBuildNumber() + ", but got " + this.manifestImplementationVersion);
                System.exit(2);
            }
        }
        String tempVerString = this.getVersionNumber();
        tempVerString = tempVerString.replaceFirst("beta", "");
        tempVerString = tempVerString.replaceFirst("DEBUG", "2");
        this.setVersionNumber(tempVerString);
    }

    public final String getContactEMail() {
        return this.contactEMail;
    }

    public final String getSystemName() {
        return "CSUS Programming Contest System";
    }

    public final String getSystemVersionInfo() {
        String javaVer = System.getProperty("java.version", "?");
        String osName = System.getProperty("os.name", "?");
        String osArch = System.getProperty("os.arch", "?");
        String osVer = System.getProperty("os.version", "?");
        return "Version " + versionNumber + " (" + versionDate + ") Java ver " + javaVer + " build " + buildNumber + " " + osName + " " + osVer + " (" + osArch + ") ";
    }

    public final String getVersionDate() {
        return versionDate;
    }

    public final String getVersionNumber() {
        return versionNumber;
    }

    public static void main(String[] args) {
        String javaVer = System.getProperty("java.version", "?");
        String osName = System.getProperty("os.name", "?");
        String osArch = System.getProperty("os.arch", "?");
        String osVer = System.getProperty("os.version", "?");
        VersionInfo sri = new VersionInfo();
        System.out.println();
        System.out.println(sri.getSystemName());
        System.out.print("Version " + sri.getVersionNumber());
        if (!sri.getVersionDate().trim().equals("")) {
            System.out.print(" (" + sri.getVersionDate() + ")");
        }
        if (!sri.getBuildNumber().trim().equals("")) {
            System.out.print(" build " + sri.getBuildNumber());
        }
        System.out.println();
        System.out.println("Java version " + javaVer);
        System.out.println("OS: " + osName + " " + osVer + " (" + osArch + ") ");
        System.out.println();
        System.out.println(sri.getContactEMail());
        System.out.println();
        System.out.println("(This class: $Id: VersionInfo.java 2182 2010-10-08 20:24:02Z laned $)");
        System.out.println();
        System.exit(0);
    }

    public final String getBuildNumber() {
        return buildNumber;
    }

    public static void printMemoryToLog(Log log) {
        long mem = Runtime.getRuntime().freeMemory();
        log.info("Java freeMemory   " + mem + " " + mem / 1000L + "k");
        mem = Runtime.getRuntime().totalMemory();
        log.info("Java totalMemory  " + mem + " " + mem / 1000L + "k");
        mem = Runtime.getRuntime().maxMemory();
        log.info("Java maxMemory    " + mem + " " + mem / 1000L + "k");
    }

    protected String addNumberEnding(String numberString) {
        if (numberString == null || numberString.trim().length() < 1) {
            return "";
        }
        char lastChar = numberString.charAt(numberString.length() - 1);
        if (!Character.isDigit(lastChar)) {
            return "";
        }
        String ending = "th";
        if (!(numberString.endsWith("11") || numberString.endsWith("12") || numberString.endsWith("13"))) {
            if (numberString.endsWith("1")) {
                return "st";
            }
            if (numberString.endsWith("2")) {
                return "nd";
            }
            if (numberString.endsWith("3")) {
                return "rd";
            }
        }
        return ending;
    }

    protected void loadVersionInfoFromFile(String filename) {
        try {
            if (!new File(filename).exists()) {
                return;
            }
            String[] lines = Utilities.loadFile(filename);
            if (lines.length == 0) {
                System.err.println("Unable to read " + filename + " version information unavailable");
            } else if (lines.length < 2) {
                System.err.println("Unable to find version information in " + filename + ", version information unavailable");
            } else {
                String[] fields = lines[1].split("\\s+");
                if (fields.length == 10) {
                    this.setVersionNumber(fields[1] + " " + fields[2]);
                    String versionString = fields[4] + " " + fields[5] + " " + fields[6] + this.addNumberEnding(fields[6]) + " " + fields[7] + " " + fields[8] + " " + fields[9];
                    this.setVersionDate(versionString.substring(1, versionString.length() - 1));
                    this.setBuildNumber(fields[3]);
                    versionFileRead = true;
                } else {
                    System.err.println("Incorrect number of fields on line 2 in file: \"" + filename + "\", version information unavailable");
                    System.err.println("Expecting 10 fields, found " + fields.length + " fields.");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception loading " + filename);
            e.printStackTrace(System.err);
        }
    }

    private int checkAgainstManifest() {
        Package corePackage = Package.getPackage("edu.csus.ecs.pc2");
        if (corePackage != null) {
            this.manifestSpecificationVersion = corePackage.getSpecificationVersion();
            this.manifestImplementationVersion = corePackage.getImplementationVersion();
            int versionWithoutDate = this.getVersionNumber().indexOf(32);
            if (this.manifestSpecificationVersion != null) {
                if (versionFileRead) {
                    if (!this.getVersionNumber().substring(0, versionWithoutDate).equals(corePackage.getSpecificationVersion())) {
                        return 1;
                    }
                    if (!this.getBuildNumber().equals(corePackage.getImplementationVersion())) {
                        return 2;
                    }
                } else {
                    this.setVersionNumber(corePackage.getSpecificationVersion());
                    this.setBuildNumber(corePackage.getImplementationVersion());
                }
            }
        }
        return 0;
    }

    public String locateHome() {
        String pc2home = ".";
        try {
            String cp = System.getProperty("java.class.path");
            StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                File dir = new File(token);
                if (dir.exists() && dir.isFile() && dir.toString().endsWith("pc2.jar")) {
                    pc2home = new File(dir.getParent() + File.separator + "..").getCanonicalPath();
                    break;
                }
                if (!dir.exists() || !dir.isDirectory() || !dir.toString().endsWith(".classes")) continue;
                pc2home = new File(dir.toString() + File.separator + "..").getCanonicalPath();
            }
        }
        catch (IOException e) {
            System.err.println("Trouble locating pc2home: " + e.getMessage());
            pc2home = ".";
        }
        return pc2home;
    }

    public void setBuildNumber(String newBuildNumber) {
        buildNumber = newBuildNumber;
    }

    public void setVersionDate(String newVersionDate) {
        versionDate = newVersionDate;
    }

    public void setVersionNumber(String newVersionNumber) {
        versionNumber = newVersionNumber;
    }

    public String getSystemURL() {
        return "http://pc2.ecs.csus.edu/";
    }
}

