# -*- coding: cp1252 -*-
#Modulo lista, con las funcionalidades vistas en clase:

import estructura

#lista: valor(any) siguiente(lista)
#any significa cualquier tipo, None significa nada (no tiene valor)
estructura.crear("lista", "valor siguiente")

#Por claridad de conceptos, definimos una lista vacia, la cual para efectos
#practicos, es equivalente a None. Asi se tiene mas consistencia con el apunte
#del curso (y con los puristas de diseo y metodologias de programacin)
listaVacia = None
#ojo: si reemplazamos todos los listaVacia por None, todo deberia funcionar
#de igual manera

#------------------------------------------------------------------------
# esLista: lista -> bool
# True si L es una lista
# ej esLista(lista(1,listaVacia)) es True

def esLista(L):
    #o es una lista tradicional, o es la lista vacia 
    return type(L) == lista or L == listaVacia

assert esLista(lista(1,listaVacia))

#------------------------------------------------------------------------
# esListaVacia: lista -> bool
# True si L es la lista vacia
# ej esLista(lista(1,listaVacia)) es False
def esListaVacia(L):
    return L == listaVacia
    
assert not esListaVacia(lista(1,listaVacia))
assert esListaVacia(listaVacia)

#------------------------------------------------------------------------
# cabeza: lista -> any
# entrega el primer valor de una lista
# ej cabeza(lista("a",lista("b",listaVacia))) entrega "a"

def cabeza(L):
    assert esLista(L)
    
    if esListaVacia(L):
        return listaVacia
    
    return L.valor

#test
assert cabeza(lista("a",lista("b",listaVacia))) == "a"
assert cabeza(listaVacia) == listaVacia

#------------------------------------------------------------------------
# cola: lista -> lista
# entrega la lista, pero sin la primera componente
# ej: cola(lista("a",lista("b",listaVacia))) entrega lista("b",listaVacia)
def cola(L):
    assert esLista(L)
    
    if esListaVacia(L):
        return listaVacia
    
    return L.siguiente

#test
assert cola(lista("a",lista("b",listaVacia))) == lista("b",listaVacia)
assert cola(listaVacia) == listaVacia

#------------------------------------------------------------------------
# largo: lista -> int
# entrega cuantos elementos tiene una lista
# ej: largo(lista(5,lista(4,listaVacia))) entrega 2

def largo(L):
    assert esLista(L)

    #si la lista esta vacia, terminamos
    if esListaVacia(L):
        return 0
    #si no, continuamos contando
    return 1 + largo(cola(L))

#test
assert largo(lista(5,lista(4,listaVacia))) == 2
assert largo(listaVacia) == 0

#------------------------------------------------------------------------
#------------------------------------------------------------------------
##funciones adicionales que no forman parte del core de lista
##(deberian ir en otro modulo llamado lista.utils)

#------------------------------------------------------------------------
# imprimirLista: lista -> None
# imrpime en pantalla los elementos de una lista
# ej: imprimirLista(lista(5,lista(4,listaVacia))) imprime 5 4

def imprimirLista(L):
    assert esLista(L)
    
    if not esListaVacia(L):
        print cabeza(L)
        imprimirLista(cola(L))
    return

#------------------------------------------------------------------------
#suma: lista(num) -> num
#suma de una lista de numeros
#ej: suma(lista(5,lista(4,listaVacia)))-> 9

def suma(L):
    assert esLista(L)
    if L == listaVacia:
        return 0
    else:
        return cabeza(L) + suma(cola(L))

assert suma(listaVacia)== 0
assert suma(lista(5,lista(4,listaVacia))) == 9

#------------------------------------------------------------------------
#enLista: any lista -> bool
#True si un valor x esta en una lista L
#ej enLista(4,lista(5,lista('manzana',listaVacia)))->True

def enLista(x,L):
    assert esLista(L)
    if L == listaVacia: #esListaVacia(L)
        return False
    if cabeza(L) == x:
        return True

    return enLista(x,cola(L))

assert enLista(4,listaVacia) == False
assert enLista(4,lista(5,lista(4,listaVacia))) == True
assert enLista('manzana',lista(5,lista('manzana',listaVacia))) == True

#------------------------------------------------------------------------
#leerLista: str -> lista
#produce una lista de palabras(strings), que terminan con un string arbitrario
#ej: leerLista('.') -> (input: a b c .) -> lista(a,lista(b,lista(c,listaVacia)))

def leerLista(fin):
    assert type(fin) == str
    palabra = raw_input('palabra? ')
    if palabra == fin:
        return listaVacia
    return lista(palabra,leerLista(fin))

#------------------------------------------------------------------------
#lugar: any lista(any) -> int
#retorna la posicin de la primera aparicin de elemento x, en una lista L
#0 si no esta
#ej: lugar(4,lista(5,lista(4,listaVacia)))->2

def lugar(x,L,i=1):
    assert esLista(L)

    if L == listaVacia: #esListaVacia(L)
        return 0
    if cabeza(L) == x:
        return i
    return lugar(x,cola(L),i+1)

assert lugar(4,lista(5,lista(4,listaVacia))) == 2
assert lugar(4,listaVacia) == 0
assert lugar('manzana',lista('manzana',lista(5,listaVacia))) == 1

#------------------------------------------------------------------------
#valor: int lista(any) -> any
#obtiene el elemento en la posicin i de la lista L
#retorna None si el largo de la lista es menor a la posicin i
#ej: valor(2,lista(5,lista(4,listaVacia))) -> 4

def valor(i,L,pos=1):
    assert esLista(L)
    assert type(i) == int and i>=1
    if L == listaVacia:
        return None
    if pos == i:
        return cabeza(L)
    return valor(i,cola(L),pos+1)

assert valor(2,lista(5,lista(4,listaVacia))) == 4
assert valor(4,listaVacia) == None
assert valor(1,lista('manzana',lista(5,listaVacia))) == 'manzana'

#------------------------------------------------------------------------
#menores: lista(any) any -> lista(any)
#genera una lista con los valores de la lista L que sean menores a x
#ej: menores(lista(5,lista(4,listaVacia)),5) -> lista(4,listaVacia)

def menores(L,x):
    assert esLista(L)
    
    if L == listaVacia:
        return listaVacia
    if cabeza(L) < x:
        return lista(cabeza(L),menores(cola(L),x))
    return menores(cola(L),x)

assert menores(lista(5,lista(4,listaVacia)),5) == lista(4,listaVacia)
assert menores(listaVacia,4) == listaVacia
assert menores(lista('manzana',lista('caramelo',listaVacia)),'k') == lista('caramelo',listaVacia)

#------------------------------------------------------------------------
#mayores: lista(any) any -> lista(any)
#genera una lista con los valores de la lista L que sean mayores a x
#ej: mayores(lista(5,lista(4,listaVacia)),4) -> lista(5,listaVacia)

def mayores(L,x):
    assert esLista(L)
    
    if L == listaVacia:
        return listaVacia
    if cabeza(L) > x:
        return lista(cabeza(L),mayores(cola(L),x))
    return mayores(cola(L),x)

assert mayores(lista(5,lista(4,listaVacia)),4) == lista(5,listaVacia)
assert mayores(listaVacia,4) == listaVacia
assert mayores(lista('manzana',lista('caramelo',listaVacia)),'k') == lista('manzana',listaVacia)

#------------------------------------------------------------------------
#menorQue: any any -> bool
#True si x<y, False si no, o bien, no son comparables.
#ej: menorQue(2,4) -> True

def menorQue(x,y):
    if type(x) == type(y):
        return x<y
    return False

assert menorQue(2,4)

#------------------------------------------------------------------------
#mayorQue: any any -> bool
#True si x>y, False si no, o bien, no son comparables.
#ej: menorQue(2,4) -> True

def mayorQue(x,y):
    if type(x) == type(y):
        return x>y
    return False

assert not mayorQue(2,4)

#------------------------------------------------------------------------
#filtro: lista(any) (fun: any any -> bool) any -> lista(any)
#genera una lista con los valores de la lista L que satisfacen la comparacin con fun
#ej: filtro(lista(5,lista(4,listaVacia)),menorQue,5) -> lista(4,listaVacia)

def filtro(L,comparacion,x):
    assert esLista(L)
    
    if L == listaVacia:
        return listaVacia
    if comparacion(cabeza(L),x):
        return lista(cabeza(L),filtro(cola(L),comparacion,x))
    return filtro(cola(L),comparacion,x)

assert filtro(lista(5,lista(4,listaVacia)),menorQue,5)==lista(4,listaVacia)
assert filtro(lista(5,lista(4,listaVacia)),mayorQue,4)==lista(5,listaVacia)

#------------------------------------------------------------------------
#mapa: (fun: any -> any) lista(any) -> lista(any)
#aplica (mapea) la funcion fun en los valores de la lista L
#ej: mapa(f, lista(5,lista(4,listaVacia))) -> lista(f(5),lista(f(4),listaVacia))

def mapa(fun,L):
    assert esLista(L)
    if L == listaVacia:
        return None
    return lista(fun(cabeza(L)),mapa(fun,cola(L)))

#------------------------------------------------------------------------
#alFinal:  any lista(any) -> lista(any)
#Agrega un nuevo elemento al final de la lista L
#ej: alFinal(2,lista(1,listaVacia)) -> lista(1,lista(2,listaVacia))

def alFinal(x,L):
    if L == listaVacia:
        return lista(x,listaVacia)
    return lista(cabeza(L),alFinal(x,cola(L)))

assert alFinal(2,lista(1,listaVacia)) == lista(1,lista(2,listaVacia))

#------------------------------------------------------------------------
#inverso:  lista(any) -> lista(any)
#Entrega los elementos de una Lista en orden inverso
#ej: inverso(lista(1,lista(2,listaVacia))) -> lista(2,lista(1,listaVacia))

def inverso(L):
    assert esLista(L)
    if L == listaVacia:
        return listaVacia
    return alFinal(cabeza(L),inverso(cola(L)))

assert inverso(lista(1,lista(2,listaVacia))) == lista(2,lista(1,None))

#------------------------------------------------------------------------
#juntar:  lista(any) lista(any) -> lista(any)
#Entrega una lista con los elementos de L1 y L2
#ej: juntar(lista(1,listaVacia),lista(2,listaVacia)) -> lista(1,lista(2,None))

def juntar(L1,L2):
    assert esLista(L1) and esLista(L2)
    if L2 == listaVacia:
        return L1
    if L1 == listaVacia:
        return L2
    
    return juntar(alFinal(cabeza(L2),L1),cola(L2))
  

assert juntar(lista(1,listaVacia),lista(2,listaVacia)) == lista(1,lista(2,None))

#--------------------------------------------------------------------------
# listaToList : lista -> list
# retorna una list de python de una lista
# ej: listaToList(lista(1,lista(2,None))) entrega [1,2]
def listaToList(L):
    resp = []
    while L!=listaVacia:
        resp.append(cabeza(L))
        L = cola(L)
    return resp
assert listaToList(lista(1,lista(2,None))) == [1,2]

#-------------------------------------------------------------------------
# listTolista : list -> lista
# retorna una lista de una list de python
# ej: listToLista([1,2]) retorna lista(1,lista(2,None))
def listToLista(L):
    if len(L)==0:
        return None
    return(lista(L.pop(0),listToLista(L)))
assert listToLista([1,2]) == lista(1,lista(2,None))
    


