#__dict : diccionario que asocia nombres con notas
import random

class Evaluacion:

    #__init__ : list -> Evaluacion
    #genera un objeto Evaluacion con la lista de alumnos.
    # nota inicial: 7
    def __init__(self,nombres):
        self.__dict = {}
        for nombre in nombres:
            self.__dict[nombre] = 7

    #setNotasAleatorias : None -> None
    #Entrega una nota aleatoria entre 1 y 7 a cada alumno
    def setNotasAleatorias(self):
        for nombre in self.__dict:
            self.__dict[nombre]=random.random()*6+1

    #setNota : str float -> None
    #cambia la nota del alumno por la solicitada
    def setNota(self,nombre,nota):
        self.__dict[nombre]=nota

    #getNota : str -> float
    #entrega la nota del alumno
    def getNota(self,nombre):
        return self.__dict[nombre]

    #__add__ : Evaluacion -> Evaluacion
    #genera un promedio de ambas evaluaciones
    #si los nombres no coinciden, el comportamiento es indeterminado
    def __add__(self,E2):
        E3 = Evaluacion(self.__dict.keys())
        for nombre in self.__dict:
            E3.setNota(nombre,(E2.getNota(nombre)+self.getNota(nombre))/2.0)
        return E3

#test
Alumnos = ['a','b']
E1 = Evaluacion(Alumnos)
assert E1.getNota('a') == 7 and E1.getNota('b')==7
E2 = Evaluacion(Alumnos)
E2.setNota('a',1)
E2.setNota('b',2)
assert E2.getNota('a') == 1 and E2.getNota('b') == 2
E3 = E1 + E2
assert E3.getNota('a') == 4 and E3.getNota('b') == 4.5
