#Ejemplo de Clases y Herencia: Programacion orientada a objetos :B
#__color: str
class Celular:
    #__init__: str -> Celular
    #crea un objeto celular del color indicado
    #ejemplo: A=Celular('rojo'), B=Celular('verde')
    def __init__(self, color):
        self.__color=color
        #recordar que 'self' es una referencia a si mismo
        #dentro de la clase

    #getColor : None -> str
    #retorna el color del celular
    #ej: A.getColor() entrega 'rojo'
    def getColor(self):
        #Otra cosa: El metodo no recibe nada, pero
        #es necesario incluir 'self' para que pueda usar
        #atributos y metodos de la clase
        return self.__color

    #getSO : None -> str
    #retorna el sistema operativo del celular
    #en todos los casos retorna 'especifico'
    def getSO(self):
        return 'especifico'

#test
A=Celular('rojo')
B=Celular('verde')
assert A.getColor()=='rojo'
assert B.getColor()=='verde'
assert A.getSO()=='especifico'
assert B.getSO()=='especifico'


#Esta clase no es muy descriptiva...
#Pero tiene funcionalidades que se pueden reusar :)

#__color: str
class Smartphone(Celular):
    #Asi es como digo: Esto es un Celular, por lo que
    #quiero los metodos de celular. Sin embargo, quiero cambiar
    #algunas cosas....

    #El constructor es el mismo, pues puedo elegir diferentes colores!
    #Solo reescribo los metodos que quiero cambiar

    #getSO : None -> str
    #retorna el sistema operativo del smartphone
    #que es 'Android'
    def getSO(self):
        return 'Android'

#test
S = Smartphone('celeste')
assert S.getSO() == 'Android'
assert S.getColor() == 'celeste'

#Podria querer tener un IPhone entre mis registros, pero solo pueden
#ser 'blanco' o 'negro'. Deberia lanzar un error si el usuario se equivoca.
#Puedo hacerlo con assert, pero mas bello aun con excepciones:

#haga esto con todas las excepciones! no necesita definir otra cosa:
class ColorIncorrecto(Exception):
    def __init__(self):
        pass


#__color: str
class IPhone(Celular):
    #Necesito reescribir el constructor

    #__init__: str -> IPhone
    #crea un IPhone del color dado. Si no es de color
    #blanco o negro, se lanza una excepcion
    def __init__(self,color):
        if color!='blanco' and color!='negro':
            raise ColorIncorrecto()
        self.__color=color

    #getSO : None -> str
    #retorna el sistema operativo del iphone
    #es decir, 'IOS'
    def getSO(self):
        return 'IOS'

#test
lanzoExcepcion = False

try:

    I = IPhone('rojo')


except ColorIncorrecto:

    lanzoExcepcion = True
    
#si lanzo la excepcion, esta bien! :D    
assert lanzoExcepcion

I = IPhone('blanco')
assert I.getSO() == 'IOS'
        
