# -*- coding: utf-8; -*-
#
# "THE BEER-WARE LICENSE" (Revision 42):
# <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Nicolás Lehmann

import estructura
from lista import *

# empleado: nombre (string) rut (string) salario (int) subalternos (lista(empleado))
estructura.crear("empleado", "nombre salario subalternos")

# salarioObreros: empleado -> int
# Calcula la suma de sueldos de todos los obreros que se encuentran bajo
# la jerarquía.
# ej:
# o1 = empleado("Pedro", 100000, listaVacia)
# o2 = empleado("Juan", 120000, listaVacia)
# o3 = empleado("Diego", 120000, listaVacia)
# e1 = empleado("Gloria", 500000, crearLista(o1, crearLista(o2, listaVacia)))
# e2 = empleado("Miguel", 700000, crearLista(o3, listaVacia))
# hp = empleado("Horst", 100000000, crearLista(e1, crearLista(e1, listaVacia)))
# salarioObreros(hp) retorna 340000
def salarioObreros(unEmpleado):
    if vacia(unEmpleado.subalternos):
        return unEmpleado.salario
    else:
        return salarioObrerosLista(unEmpleado.subalternos)

# salarioObrerosLista: lista(empleado) -> num
# Retorna la suma de los salarios de obreros bajo la jerarquía de cada
# empleado de una lista.
# o1 = empleado("Pedro", 100000, listaVacia)
# o2 = empleado("Juan", 120000, listaVacia)
# o3 = empleado("Diego", 120000, listaVacia)
# e1 = empleado("Gloria", 500000, crearLista(o1, crearLista(o2, listaVacia)))
# e2 = empleado("Miguel", 700000, crearLista(o3, listaVacia))
# salarioObreros(crearLista(e1, crearLista(e1, listaVacia))) retorna 340000
def salarioObrerosLista(empleados):
    if vacia(empleados):
        return 0
    else:
        return salarioObreros(cabeza(empleados)) + salarioObrerosLista(cola(empleados))

o1 = empleado("Pedro", 100000, listaVacia)
o2 = empleado("Juan", 120000, listaVacia)
o3 = empleado("Diego", 120000, listaVacia)
l1 = crearLista(o1, crearLista(o2, listaVacia))
l2 = crearLista(o3, listaVacia)
e1 = empleado("Gloria", 500000, l1)
e2 = empleado("Miguel", 700000, l2)
l3 = crearLista(e1, crearLista(e2, listaVacia))
hp = empleado("Horst", 100000000, l3)
assert salarioObreros(hp) == 340000
assert salarioObrerosLista(l3) == 340000
assert salarioObrerosLista(l1) == 220000
