# -*- coding: utf-8; -*-
#
# "THE BEER-WARE LICENSE" (Revision 42):
# <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Nicolás Lehmann

import estructura

# nodo: val (int) izq (nodo) der (nodo)
estructura.crear("nodo", "val izq der")

# nodo vacio
nodoVacio = None

# crearNodo: int nodo nodo -> nodo
# Crear un nodo que guarda el entero correspondiente y tiene los respectivos
# subarboles izquierdo y derecho
def crearNodo(val, izq, der):
    return nodo(val, izq, der)

# vacio: nodo -> bool
# Determina si el parametro corresponde a un nodo vacio
def vacio(nodo):
    return nodo == nodoVacio

# esABB: nodo -> bool
# Determina si un árbol binario es ABB
# ej:
# n1 = crearNodo(10, nodoVacio, nodoVacio)
# n2 = crearNodo(20, nodoVacio, nodoVacio)
# n3 = crearNodo(15, n1, n2)
# esABB(n3) retorna True
def esABB(nodo):
    if vacio(nodo):
        return True

    if not vacio(nodo.izq) and nodo.val < maxValue(nodo.izq):
        return False

    if not vacio(nodo.der) and nodo.val > maxValue(nodo.der):
        return False

    if not esABB(nodo.der) or not esABB(nodo.izq):
        return False

    return True

# maxValue: nodo -> int
# Retorna el valor máximo del árbol
# ej:
# n1 = crearNodo(10, nodoVacio, nodoVacio)
# n2 = crearNodo(20, nodoVacio, nodoVacio)
# n3 = crearNodo(15, n1, n2)
# maxValue(n3) retorna 20
def maxValue(nodo):
    assert not vacio(nodo)
    if vacio(nodo.izq) and vacio(nodo.der):
        return nodo.val
    elif vacio(nodo.izq):
        return maxValue(nodo.der)
    elif vacio(nodo.der):
        return maxValue(nodo.izq)
    else:
        return max(maxValue(nodo.izq), maxValue(nodo.der))

# insertar: nodo int -> nodo
# Devuelve un nuevo ABB con un valor insertado
# ej:
# n1 = crearNodo(10, nodoVacio, nodoVacio)
# n2 = crearNodo(20, nodoVacio, nodoVacio)
# n3 = crearNodo(15, n1, nodoVacio)
# insertar(n3, 20) retorna crearNodo(15, n1, n2)
def insertar(nodo, val):
    assert esABB(nodo)
    if vacio(nodo):
        return crearNodo(val, nodoVacio, nodoVacio)
    else:
        if val < nodo.val:
            nuevoIzq = insertar(nodo.izq, val)
            return crearNodo(nodo.val, nuevoIzq, nodo.der)
        else:
            nuevoDer = insertar(nodo.der, val)
            return crearNodo(nodo.val, nodo.izq, nuevoDer)

# recorrer: nodo -> None
# Imprime los valores del árbol separados por un salto de línea recorriendolo
# en inorden
# n1 = crearNodo(10, nodoVacio, nodoVacio)
# n2 = crearNodo(20, nodoVacio, nodoVacio)
# n3 = crearNodo(15, n1, nodoVacio)
# insertar(n3, 20) retorna crearNodo(15, n1, n2)
# recorrer(n3) imprime
# 10
# 15
# 20
def recorrer(nodo):
    if not vacio(nodo):
        recorrer(nodo.izq)
        print nodo.val
        recorrer(nodo.der)

n1 = crearNodo(10, nodoVacio, nodoVacio)
n2 = crearNodo(20, nodoVacio, nodoVacio)
assert esABB(crearNodo(15, n1, n2))
assert maxValue(crearNodo(15, n1, n2)) == 20
assert not esABB(crearNodo(30, n1, n2))
assert insertar(crearNodo(15, n1, nodoVacio), 20) == crearNodo(15, n1, n2)
