# -*- coding: utf-8; -*-
#
# "THE BEER-WARE LICENSE" (Revision 42):
# <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Nicolás Lehmann

import estructura
from lista import *

# cerveza: nombre(string) amargura(int) color(int) densidad(number)
estructura.crear("cerveza", "nombre amargura color densidad")


# filtrar: lista(cerveza) -> lista(cerveza)
# Toma una lista de cerveza y filtra las que cumplen con tener
# un valor de amargura entre 40 y 60, y un color entre 10 y 15
# ej:
# cerveza1 = cerveza("IPA Coriander", 40, 10, 1.02)
# cerveza2 = cerveza("Golden Ale", 20, 10, 1.02)
# cervezas = crearLista(cerveza1, crearLista(cerveza2, listaVacia))
# filtrar(cervezas) devuelve crearLista(cerveza1)
def filtrar(cervezas):
    if vacia(cervezas):
        return listaVacia
    else:
        c = cabeza(cervezas)
        if 40 <= c.amargura <= 60 and 10 <= c.color <= 15:
            return crearLista(c, filtrar(cola(cervezas)))
        else:
            return filtrar(cola(cervezas))

cerveza1 = cerveza("IPA Coriander", 40, 10, 1.02)
cerveza2 = cerveza("Golden Ale", 20, 10, 1.02)
cervezas1 = crearLista(cerveza1, crearLista(cerveza2, listaVacia))
cervezas2 = crearLista(cerveza2, listaVacia)
assert filtrar(cervezas1) == crearLista(cerveza1, listaVacia)
assert filtrar(cervezas2) == listaVacia
