# -*- coding: utf-8; -*-
#
# "THE BEER-WARE LICENSE" (Revision 42):
# <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Nicolás Lehmann
from lista import *


# rango: int int -> lista(int)
# Recibe dos enteros a y b, y retorna una lista con los enteros en el
# rango [a,b]
# ej: rango(1,3) retorna crearLista(1, crearLista(2, crearLista(3, listaVacia)))
def rango(a, b):
    # caso base: rango vacio
    if a > b:
        return listaVacia
    else:
        return crearLista(a, rango(a+1, b))

lista1 = crearLista(2, crearLista(3, crearLista(4, listaVacia)))
assert rango(2,4) == lista1
assert rango(6,1) == listaVacia

# sumaLista: list(num) -> num
# recibe una lista de numberos y retorna la suma de todos ellos
# ej: sumarLista(crearLista(1, crearLista(10, listaVacia))) == 11
def sumaLista(l):
    if vacia(l):
        return 0
    else:
        return cabeza(l) + sumaLista(cola(l))

assert sumaLista(crearLista(1, crearLista(2, listaVacia))) == 3
assert sumaLista(listaVacia) == 0

if __name__ == "__main__":
    print sumaLista(rango(1,100))
