# -*- coding: utf-8; -*-
#
# "THE BEER-WARE LICENSE" (Revision 42):
# <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Nicolás Lehmann

from lista import *

# unir: lista lista -> lista
# Toma dos listas como argumentos y devuelve la contatenación
# de ellas.
# ej:
# lista1 = crearLista(1, crearLista(5, crearLista(5, listaVacia)))
# lista2 = crearLista(4, crearLista(7, listaVacia))
# unir(lista1, lista2) retorna
# crearLista(1, crearLista(5, crearLista(5, crearLista(4, crearLista(7,
# listaVacia)))))
def unir(lista1, lista2):
    if vacia(lista1):
        return lista2
    else:
        lista3 = unir(cola(lista1), lista2)
        return crearLista(cabeza(lista1), lista3)

l1 = crearLista(1, crearLista(5, crearLista(5, listaVacia)))
l2 = crearLista(4, crearLista(7, listaVacia))
l3 = crearLista(1, crearLista(5, crearLista(5, crearLista(4, crearLista(7, listaVacia)))))
assert unir(l1, l2) == l3


# invertir: lista -> lista
# Invierte una lista
# ej:
# lista1 = crearLista(1, crearLista(2, crearLista(4, listaVacia)))
# invertir(lista1) retorn
# crearLista(4, crearLista(2, crearLista(1, listaVacia)))
def invertir(l):
    if vacia(l):
        return listaVacia
    else:
        return unir(invertir(cola(l)), crearLista(cabeza(l), listaVacia))

lista1 = crearLista(1, crearLista(2, crearLista(4, listaVacia)))
lista2 = crearLista(4, crearLista(2, crearLista(1, listaVacia)))
assert invertir(lista1) == lista2
assert invertir(listaVacia) == listaVacia
