# -*- coding: utf-8; -*-
#
# "THE BEER-WARE LICENSE" (Revision 42):
# <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Nicolás Lehmann

# costoMegabytes: num -> num
# Calcula el costo del plan dado un consumo especificado de
# megabytes
# ej: costoMegabytes(10) retorna 3000
def costoMegabytes(megas):
    assert megas >= 0
    base = 3000
    if megas <= 80:
        return base
    elif megas <= 100:
        return base + (megas - 80)*40
    elif megas <= 500:
        return base + 20*40 + (megas - 100)*40*1.5
    else:
        return base + 20*40 + 500*40*1.5 + (megas - 500)*100

assert costoMegabytes(80) == 3000
assert costoMegabytes(0) == 3000
assert costoMegabytes(90) == 3400
assert costoMegabytes(180) == 8600
assert costoMegabytes(1000) == 83800
