# -*- coding: utf-8; -*-
#
# "THE BEER-WARE LICENSE" (Revision 42):
# <nlehmann@dcc.uchile.cl> wrote this file. As long as you retain this notice you
# can do whatever you want with this stuff. If we meet some day, and you think
# this stuff is worth it, you can buy me a beer in return Nicolás Lehmann

# esPrimoAux: int int -> bool
# Determina si un entero positivo es divisible por algun entero menor o igual
# que otro entero positivo especificado.
# ej: esPrimoAux(10, 8) devuelve True y esPrimoAux(3, 2) devuelve False
def divisible(n, d):
    assert 0 < n and 0 < d
    if d == 1:
        return False
    if n % d == 0:
        return True
    return divisible(n, d - 1)

assert not divisible(1, 1)
assert not divisible(9, 2)
assert not divisible(13, 12)
assert divisible(14, 12)

# esPrimo: int -> bool
# Determina si un entero positivo es o no primo.
# ej: esPrimo(2) retorna True mientras que
# esPrimo(10) retorna False
def esPrimo(n):
    assert n > 0
    if n == 1:
        return False
    return not divisible(n, n - 1)

assert not esPrimo(1)
assert esPrimo(2)
assert not esPrimo(4)


# primosMenores: int -> None
# Imprime de mayor a menor todos los primos menores o iguales que un entero
# especificado.
# ej: primosMenores(8) imprime los números 7, 5, 3 y 2
def primosMenores(n):
    if n > 1:
        if esPrimo(n):
            print n
        primosMenores(n-1)

# primosEntre: int int -> None
# Imprime de menor a mayor todos los primos en un rango especificado
# ej: primosEntre(10,23) imprime los números 11, 13, 17, 19 y 23
def primosEntre(a, b):
    if a < b:
        if esPrimo(a):
            print a
        primosEntre(a+1, b)


# primerosPrimos: int int -> None
# Imprime una cantidad especifica de primos mayores o iguales que n.
# ej: primos(3, 23) imprime 23, 29 y 31
def primosMayores(cantidad, n):
    if cantidad > 0:
        if esPrimo(n):
            print n
            primosMayores(cantidad - 1, n + 1)
        else:
            primosMayores(cantidad, n + 1)

# techoLogAux: int int int -> int
# Eleva 2 consecutivamente hasta alcanzar una potencia mayor o igual que un
# número especificado. Recibe además exponente y el valor actual de la potencia.
# ej: techoLogAux(5, 1, 0) devuelve 3
def techoLogAux(n, exponente, valor):
    assert 2**exponente == valor
    if valor >= n:
        return exponente
    return techoLogAux(n, exponente+1, 2*valor)

assert techoLogAux(5, 0, 1) == 3
assert techoLogAux(1024, 9, 512) == 10

# techoLog: int -> int
# Calcula el menor entero x tal que 2**x es mayor o igual que n
# ej: techoLog(5) devuelve 3
def techoLog(n):
    assert n > 0
    return techoLogAux(n, 0, 1)

assert techoLog(1) == 0
assert techoLog(1025) == 11
assert techoLog(512) == 9

# producto: int int -> int
# Calcula la multiplicación de dos enteros positivos
# ej: producto(3, 4) retorna 12
def producto(x, y):
    assert x > 0 and y > 0
    if y == 1:
        return x
    return x + producto(x, y - 1)

assert producto(3, 1) == 3
assert producto(5, 5) == 25
assert producto(1, 1) == 1

# potencia: num int -> num
# Eleva un número a una potencia entera
# ej: potencia(80, 0) es igual a 1
def potencia(base, exponente):
    assert exponente >= 0
    assert not(base == 0 and exponente == 0)
    if base == 0:
        return 0
    if exponente == 0:
        return 1
    return base * potencia(base, exponente - 1)

assert potencia(0, 4) == 0
assert potencia(2, 0) == 1
assert potencia(2, 10) == 1024

# sumaDivisores: int int -> int
# Calcula la suma de los divisores propios de un número
# menores o iguales que otro número especifidado.
# ej: sumaDivisores(10, 5) retorna 7
def sumaDivisores(a, b):
    assert a > 0 and b > 0
    if b == 1:
        return 1
    else:
        if a % b == 0 and a != b:
            return b + sumaDivisores(a, b - 1)
        return sumaDivisores(a, b - 1)

assert sumaDivisores(10, 5) == 8
assert sumaDivisores(10, 10) == 8
assert sumaDivisores(20, 25) == 22

# numAmigos: int int -> bool
# Determina si dos números son amigos, ie, la suma de los divisores
# propios de cada uno es igual al otro.
# ej: numAmigos(220, 284) devuelve True
def numAmigos(x, y):
    assert x > 0 and y > 0
    assert x != y
    return sumaDivisores(x, x) == y and sumaDivisores(y, y) == x

assert not numAmigos(1, 2)
assert numAmigos(220, 284)

print "Primos menores que 100 de mayor a menor"
primosMenores(100)
print "Primos menores que 100 de menor a mayor"
primosEntre(1, 100)
print "Primeros 50 primos"
primosMayores(10, 1)
