# -*- coding: utf-8; -*-

# invertirNumero: int -> int
# invierte un nmero de 3 dgitos.
# ejemplo: invertirNumero(123) = 321

def invertirNumero(numero):
    primer_digito = numero % 10
    segundo_digito = (numero/10) % 10
    tercer_digito = (numero/100) % 10
    return tercer_digito + 10*segundo_digito + 100*primer_digito

assert invertirNumero(123) == 321
assert invertirNumero(156) == 651

# palindromo: int -> boolean
# recibe un nmero de tres dgitos y retorna true si ste
# es un palindromo y false en caso contrario
# ejemplo: palindromo(123) = False
# ejemplo: palindromo(121) = True

def palindromo(numero):
    return numero == invertirNumero(numero)

assert not palindromo(123)
assert palindromo(121)
