import estructura
from lista import *
import math

# Diseno de la estructura

# punto3D: x (int) y (int) z (int)
estructura.crear("punto3D", "x y z")


# Funciones

# Contrato
# 	distancia:  punto3D punto3D -> num
# Proposito
# 	calcular la distancia entre dos puntos 3D
# Ejemplo:
# 	distancia(punto3D(1, 1, 1), punto3D(1, 1, 2))  devuelve 1
# Plantilla
# def distancia(punto1, punto2):
#	...  punto1.x ... punto2.x ...
#	...  punto1.x ... punto2.y ...
#	...  punto1.x ... punto2.z ...
#	...  punto1.y ... punto2.x ...
#	...  punto1.y ... punto2.y ...
#	...  punto1.y ... punto2.z ...
#	...  punto1.z ... punto2.x ...
#	...  punto1.z ... punto2.y ...
#	...  punto1.z ... punto2.z ...
# Cuerpo de la funcion
def distancia(punto1, punto2):
	distanciax = punto1.x - punto2.x
	distanciay = punto1.y - punto2.y
	distanciaz = punto1.z - punto2.z
	return math.sqrt(distanciax**2 + distanciay**2 + distanciaz**2)
# Tests
epsilon = 0.00001
assert abs( distancia(punto3D(0,0,0), punto3D(1,1,1)) - 1.73205 ) < epsilon
assert abs( distancia(punto3D(0,0,0), punto3D(0,3,4)) - 5 ) < epsilon
assert abs( distancia(punto3D(0,0,0), punto3D(0,0,1)) - 1 ) < epsilon



# Contrato
# 	distanciaTotal:  lista(punto3D) -> num
# Proposito
# 	calcular la distancia total entre los puntos contiguos de la lista entregada
# Ejemplo:
# 	distanciaTotal( lista(punto3D(1, 1, 1), lista(punto3D(1, 1, 2), lista(punto3D(1, 2, 2), listaVacia))))  devuelve 2
# Plantilla
# def distanciaTotal(listaPuntos):
#		if(vacia(listaPuntos)):
#			...
#		else:
#			... cabeza(listaPuntos) ...
#			... cola(listaPuntos) ...
# Cuerpo de la funcion
def distanciaTotal(listaPuntos):
	if(vacia(cola(listaPuntos))):
		return 0
	else:
		punto1 = cabeza(listaPuntos)
		punto2 = cabeza(cola(listaPuntos))
		return distancia(punto1, punto2) + distanciaTotal(cola(listaPuntos))
# Tests
epsilon = 0.00001
assert abs( distanciaTotal( lista(punto3D(0,0,0), lista( punto3D(0,0,1), listaVacia))) - 1) < epsilon
assert abs( distanciaTotal( lista(punto3D(0,0,0), lista( punto3D(0,0,1), lista( punto3D(0,0,2), listaVacia)))) - 2) < epsilon
assert abs( distanciaTotal( lista(punto3D(0,0,0), lista( punto3D(1,1,1), lista( punto3D(2,2,2), listaVacia)))) - 3.464101) < epsilon



# Programa interactivo
print "ingrese las coordenadas del punto 1: "
x = input("x?")
y = input("y?")
z = input("z?")
punto1 = punto3D(x,y,z)
print "ingrese las coordenadas del punto 2: "
x = input("x?")
y = input("y?")
z = input("z?")
punto2 = punto3D(x,y,z)
print "ingrese las coordenadas del punto 3: "
x = input("x?")
y = input("y?")
z = input("z?")
punto3 = punto3D(x,y,z)
print "ingrese las coordenadas del punto 4: "
x = input("x?")
y = input("y?")
z = input("z?")
punto4 = punto3D(x,y,z)
print "ingrese las coordenadas del punto 5: "
x = input("x?")
y = input("y?")
z = input("z?")
punto5 = punto3D(x,y,z)
listaPuntos = lista(punto1, lista(punto2, lista(punto3, lista(punto4, lista(punto5, listaVacia)))))
total = distanciaTotal(listaPuntos)
print "la distancia total del camino es", total
