from lista import *

nombres = crearLista("Manuel", crearLista("Jaime", crearLista("Gloria", crearLista("Ana", crearLista("Manuel", crearLista("Ana", crearLista("Ana", listaVacia)))))))


# Contrato
# 	buscar: lista(str) str -> bool
# Proposito
# 	determina si un nombre está presente en la lista dada o no.
# Ejemplo:
# 	buscar( "ismael", lista( "camilo", lista("mario", listaVacia))), "diego")  devuelve False
# Plantilla
# def buscar(listaCurso, nombre):
#		if(vacia(listaCurso)):
#			...
#		else:
#			... cabeza(listaPuntos) ... nombre ...
#			... cola(listaPuntos) ... nombre ...
# Cuerpo de la funcion
def buscar(listaCurso, nombre):
	if vacia(listaCurso):
		return 0
	else:
		if cabeza(listaCurso) == nombre:
			return True
		else:
			return buscar(cola(listaCurso), nombre) 
# Tests
assert buscar(nombres, "Seba") == False
assert buscar(nombres, "Jaime")
assert buscar(nombres, "Ana")
assert buscar(nombres, "manuel") == False



# Contrato
# 	totalAlumnos: lista(str) -> int
# Proposito
# 	calcula el total de alumnos presentes en la lista.
# Ejemplo:
# 	totalAlumnos( "ismael", lista( "camilo", lista("mario", listaVacia))))  devuelve 3
# Plantilla
# def buscar(listaCurso):
#		if(vacia(listaCurso)):
#			...
#		else:
#			... cabeza(listaPuntos) ...
#			... cola(listaPuntos) ...
# Cuerpo de la funcion
def totalAlumnos(listaCurso):
	if vacia(listaCurso):
		return 0
	else:
		return 1 + totalAlumnos(cola(listaCurso))
			
# Tests
assert(totalAlumnos(nombres)==7)
assert(totalAlumnos(crearLista("casa", listaVacia)==1))
assert(totalAlumnos( "ismael", lista( "camilo", lista("mario", listaVacia)))) == 3)
assert(totalAlumnos(listaVacia)==0)



# Contrato
# 	contar: lista(str) str -> int
# Proposito
# 	la cantidad de alumnos con el nombre dado hay en la lista.
# Ejemplo:
# 	contar( lista( "ismael", lista( "camilo", lista("mario", listaVacia))), "diego")  devuelve 0
# Plantilla
# def contar(listaCurso, nombre):
#		if(vacia(listaCurso)):
#			...
#		else:
#			... cabeza(listaPuntos) ... nombre ...
#			... cola(listaPuntos) ... nombre ...
# Cuerpo de la funcion
def contar(listaCurso, nombre):
	if vacia(listaCurso):
		return 0
	else:
		if cabeza(listaCurso) == nombre:
			return 1 + contar(cola(listaCurso), nombre)
		else:
			return contar(cola(listaCurso), nombre)
			
# Tests
assert(contar(nombres, "Seba")==0)
assert(contar(nombres, "Jaime")==1)
assert(contar(nombres, "Ana")==3)
assert(contar(nombres, "Manuel")==2)



# Contrato
# 	borrar: lista(str) str -> lista(str)
# Proposito
# 	entrega una lista a la que se le han borrado los nombres especificados
# Ejemplo:
# 	borrar( lista( "ismael", lista( "camilo", lista("mario", listaVacia))), "mario")  devuelve lista( "ismael", lista( "camilo", listaVacia)))
# Plantilla
# def contar(listaCurso, nombre):
#		if(vacia(listaCurso)):
#			...
#		else:
#			... cabeza(listaPuntos) ... nombre ...
#			... cola(listaPuntos) ... nombre ...
# Cuerpo de la funcion
def borrar(listaCurso, nombre):
	if vacia(listaCurso):
		return listaVacia
	else:
		if cabeza(listaCurso) == nombre:
			return borrar(cola(listaCurso), nombre)
		else:
			return crearLista(cabeza(listaCurso), borrar(cola(listaCurso), nombre))
# Tests
assert(borrar(nombres, "Manuel") == crearLista("Jaime", crearLista("Gloria", crearLista("Ana", crearLista("Ana", crearLista("Ana", listaVacia))))))
assert(borrar(nombres, "Ana") == crearLista("Manuel", crearLista("Jaime", crearLista("Gloria", crearLista("Manuel", listaVacia)))))
assert(borrar( borrar(nombres, "Ana"), "Manuel") == crearLista("Jaime", crearLista("Gloria", listaVacia)))
assert(borrar(nombres, "Seba") == nombres)
