import estructura

# Diseno de la estructura

# tiempo: horas (int) minutos (int) segundos (int)
estructura.crear("tiempo", "horas minutos segundos")

# Funciones

# Contrato
# 	validarHora:  tiempo -> bool
# Proposito
# 	determinar si una estructura tiempo corresponde a una correcta representacion horaria (de 24 horas)
# Ejemplo:
# 	validarHora(tiempo(23, 15, 11))  devuelve  True
# Plantilla
# def validarHora(tiempo):
#	...  tiempo.horas ...  
#	...  tiempo.minutos ... 
#	...  tiempo.segundos ... 
# Cuerpo de la funcion
def validarHora(unTiempo):
	horasOk = unTiempo.horas < 24 and unTiempo.horas >=0
	minutosOk = unTiempo.minutos < 59 and unTiempo.minutos >=0
	segundosOk = unTiempo.segundos < 59 and unTiempo.segundos >=0
	return horasOk and minutosOk and segundosOk
# Tests
assert validarHora(tiempo(23, 15, 11)) == True
assert validarHora(tiempo(17, 1, 1)) == True
assert validarHora(tiempo(12, 72, 59)) == False


# Contrato
# 	normalizarTiempo:  tiempo -> tiempo
# Proposito
# 	crear una nueva estructura tiempo a partir de los valores de horas minutos y segundos normalizados de otra.
# Ejemplo:
# 	normalizarTiempo( tiempo(14, 59, 65) ) devuelve tiempo(15, 00, 5)
# Plantilla
# def normalizarTiempo(tiempo1):
#	...  tiempo.horas ...  
#	...  tiempo.minutos ... 
#	...  tiempo.segundos ... 
# Cuerpo de la funcion
def normalizarTiempo(unTiempo):
	segundos = unTiempo.segundos
	minutos = unTiempo.minutos
	horas = unTiempo.horas
	if(segundos > 59):
		minutosCompletos = segundos/60
		segundos = segundos%60
		minutos = minutos + minutosCompletos
	if(minutos > 59):
		horasCompletas = minutos/60
		minutos = minutos%60
		horas = horas + horasCompletas
	if(horas > 23):
		horas = horas%24
	return tiempo(horas, minutos, segundos)
# Tests
assert normalizarTiempo(tiempo(14, 59, 65)) == tiempo(15, 00, 5)


# Contrato
# 	sumarTiempo:  tiempo tiempo -> tiempo
# Proposito
# 	sumar dos estructuras de tiempo
# Ejemplo:
# 	sumarTiempo(tiempo(5, 15, 11), tiempo(2, 1, 21))  devuelve  tiempo(7, 16, 32)
# Plantilla
# def sumarTiempo(tiempo1, tiempo2):
#	...  tiempo1.horas ... tiempo2.horas ... 
#	...  tiempo1.horas ... tiempo2.minutos ... 
#	...  tiempo1.horas ... tiempo2.segundos ... 
#	...  tiempo1.minutos ... tiempo2.horas ...
#	...  tiempo1.minutos ... tiempo2.minutos ...
#	...  tiempo1.minutos ... tiempo2.segundos ...
#	...  tiempo1.segundos ... tiempo2.horas ...
#	...  tiempo1.segundos ... tiempo2.minutos ...
#	...  tiempo1.segundos ... tiempo2.segundos ...
# Cuerpo de la funcion
def sumarTiempo(tiempo1, tiempo2):
	horas = tiempo1.horas + tiempo2.horas
	minutos = tiempo1.minutos + tiempo2.minutos
	segundos = tiempo1.segundos + tiempo2.segundos
	return tiempo(horas, minutos, segundos)
# Tests
assert sumarTiempo(tiempo(5, 15, 11), tiempo(2, 1, 21)) == tiempo(7, 16, 32)


# Contrato
# 	totalDias:  tiempo -> int
# Proposito
# 	determinar el total de dias contemplados en una representacion de la estructura tiempo
# Ejemplo:
# 	totalDias(tiempo(235, 115, 11))  devuelve  9
# Plantilla
# def totalDias(tiempo):
#	...  tiempo.horas ...  
#	...  tiempo.minutos ... 
#	...  tiempo.segundos ... 
# Cuerpo de la funcion
def totalDias(unTiempo):
	totalMinutos = unTiempo.horas*60 + unTiempo.minutos
	totalSegundos = totalMinutos*60 + unTiempo.segundos
	dias = totalSegundos/(60*60*24)
	return dias
# Tests
assert totalDias(tiempo(23, 1, 1)) == 0
assert totalDias(tiempo(23, 59, 200)) == 1
assert totalDias(tiempo(235, 115, 11)) == 9
