    
## NEW MODEL IDEA
## Model File 5.0 10.01.13
## Prototype Model for Leeville
## Andrea Brickey and Alexandra Newman - Colorado School of Mines

#Things to do


#########Sets###############
set A;			#set of all mining activities (a in A)
set B;			#set of all activity types b
set II;		#number of subsets in II
set I{i in II};	#subset of activity types j measured in tons
set JJ;		#number of subsets in II
set J{j in JJ};	#subset of all activity types i measured in feet
set K within B;	#set of activity types k for ore producing activities
set OU{K};		#set of all classified ore units, above cutoff grade, (primary, 							#secondary,explorationand mining)
set AH{B}; 		#set of all activities that belong to type b 
set P{A}; 		#set of all predecessors for unit a
set T;			#set of periods in the time horizon, t = 1 to |T|


###############Parameters###################

###Production###
param cm{i in II, b in I[i], a in AH[b]};	#physical attribute of material tonnage in activity j for unit a						#(tons)
param cf{j in JJ, b in J[j], a in AH[b]};   	#physical attribute of linear feet in activity i for unit a(ln.ft)

param cg{b in K, a in OU[b]};	#recoverable grade per ton in activity type b for unit a (oz/ton)
param ct{b in K, a in OU[b]};	#tons for ore in activity type b for unit a (tons)
param mfover{j in JJ,t in T};	#maximum linear feet for activity type i at time t (ln.ft/day)
param mfunder{j in JJ,t in T};	#maximum linear feet for activity type i at time t (ln.ft/day)
param mmover{i in II,t in T};	#maximum tonnage for activity type j at time t (tons/day)
param mmunder{i in II,t in T};	#maximum tonnage for activity type j at time t (tons/day)

param days{t in T};		#number of days in time period t
param es{a in A};		#early start for unit a
param rate default 0.10;	#discount rate for objective function
param comp{a in A};		#days to complete activity a

###Ventilation###

param q{a in A}; 	#quantity of air needed to complete activity (ft^3)
param v{t in T};	#total airflow quantity in t (ft^3/day)
param f{t in T};	#fixed consumed airflow quantity in t (ft^3/day)

#### Initial Values

param y0{a in A, t in T: t >= es[a]} default 0;  #inital value

##############Variables#####################

var y{a in A, t in T: t >= es[a]} binary, := y0[a,t];      #1 if unit a is active during time period t, 0 if otherwise for all a in A


	
############Objective Function###############


maximize OUNCES: sum{b in K,a in OU[b],t in T: t >= es[a]} (cg[b,a] * ct[b,a] * y[a,t]) * (1/(1+rate)^t); #maximize gold production from primary, secondary, exploration developments and mining areas above #cutoff grade



############Constraints######################


####Min/Max Constraints####

subject to FOOT{j in JJ,t in T}: mfunder[j,t] * days[t] <= sum{b in J[j], a in AH[b]: t >= es[a]} cf[j,b,a] * y[a,t] <= 
mfover[j,t]* days[t];

subject to TON{i in II,t in T}: mmunder[i,t] * days[t] <= sum{b in I[i], a in AH[b]: t >= es[a]} cm[i,b,a] * y[a,t] <= 
mmover[i,t]* days[t];


####Precedence####

subject to PRECEED{a in A, p in P[a], t in T: t >= es[a]}:  sum{u in es[a]..t}y[a,u] <= sum{u in es[a]..t}y[p,u];

####Ventilation####

subject to VENT{t in T}: sum{a in A:t >= es[a]} q[a] * y[a,t] <= (v[t] - f[t]) * days[t]; 

####Day (Rate) Check####

#subject to DAY{a in A, p in P[a], t in T: t >= es[a]}: dur[a] * y[a,t] + dur[p] * y[p,t]  <= days[t];

####Limits####

subject to MINEONCE{a in A}: sum{t in T: t >= es[a]} y[a,t] <= 1;



