#####################	SETS
param NM>=1, integer ;
param NG>=1, integer ;
param NK1>=1, integer ;	### número de tramos
param NK2>=1, integer ;
param NK3>=1, integer ;
param NK6>=1, integer ;
param NK7>=1, integer ;

set PRODUCTS ;
## Etapas
set STAGES1 ;		## etapas batch
set STAGES2 ;		## etapas semicontinuas
set STAGES3 ;		## etapas cromatográficas
set STAGES4 ;		## última etapa cromatográfica
set STAGES:= STAGES1 union STAGES2 union STAGES3 union STAGES4 ;
## unidades
set UNIT1:= STAGES1 union STAGES2 union STAGES3 union STAGES4 ;
set UNIT2 within {STAGES2 union STAGES3 union STAGES4} ;			# etapas con tanque de permeado
set UNIT3:= STAGES2 union STAGES3 union STAGES4 ;
## Etapas de acuerdo con cada producto
set PSTAGES1 within {PRODUCTS, STAGES1} ;
set PSTAGES2 within {PRODUCTS, STAGES2} ;
set PSTAGES3 within {PRODUCTS, STAGES3} ;
set PSTAGES4 within {PRODUCTS, STAGES4} ;
set PSTAGES5:= PSTAGES3 union PSTAGES4 ;
## unidades de acuerdo con cada producto
set PUNIT2S within {PRODUCTS, STAGES2} ;					# unidades 2 en etapas semicontinuas
set PUNIT1:= PSTAGES1 union PSTAGES2 union PSTAGES3 union PSTAGES4 ;
set PUNIT2:= PUNIT2S union PSTAGES3 union PSTAGES4 ;
set PUNIT3:= PSTAGES2 union PSTAGES3 union PSTAGES4 ;
## unidades con T0 y con T1
set PSTAGEST0:= PSTAGES1 union PSTAGES3 union PSTAGES4 ;
set PSTAGEST1:= PSTAGES2 union PSTAGES3 ;
## unidades en paralelo
set UNITSM:= 1..NM ordered ;
set UNITSG:= 1..NG ordered ;
## transformaciones MIP
set TMIP1:= 1..NK1+1 ; 	## conjunto de puntos
set TMIP2:= 1..NK2+1 ;
set TMIP3:= 1..NK3+1 ;
set TMIP6:= 1..NK6+1 ;
set TMIP7:= 1..NK7+1 ;

##### PARAMETERS
## Coeficientes de costo
param c1{j in UNIT1} ;
param c2{j in UNIT2} ;
param c3{j in UNIT3} ;
param gamma1{j in UNIT1} ;
param gamma2{j in UNIT2} ;
param gamma3{j in UNIT3} ;

## Factores de tamaño y tiempo
param S1{PUNIT1} ;
param S2{PUNIT2} ;
param S3{PUNIT3} ;
param T0{PSTAGEST0} ;
param T1{PSTAGEST1} ;

## coeficientes de horizonte de producción
param d{i in PRODUCTS} ;
param delta ;
param rho ;
param NR ;

# límites de variables
param y1LO{j in UNIT1} ;
param y1UP{j in UNIT1} ;
param y2LO{j in UNIT2} ;
param y2UP{j in UNIT2} ;
param y3LO{j in UNIT3} ;
param y3UP{j in UNIT3} ;
param y4LO{i in PRODUCTS} ;
param y4UP{i in PRODUCTS} ;
param y5LO{i in PRODUCTS} ;
param y5UP{i in PRODUCTS} ;

param y1lo{j in UNIT1} := log(y1LO[j]) ;
param y1up{j in UNIT1} := log(y1UP[j]) ;
param y2lo{j in UNIT2} := log(y2LO[j]) ;
param y2up{j in UNIT2} := log(y2UP[j]) ;
param y3lo{j in UNIT3} := log(y3LO[j]) ;
param y3up{j in UNIT3} := log(y3UP[j]) ;
param y4lo{i in PRODUCTS} := log(y4LO[i]) ;
param y4up{i in PRODUCTS} := min(log(y4UP[i]),min{(i,j) in PSTAGES1} (y1up[j]+log(NG)-log(S1[i,j])),min{(i,j) in PSTAGES2 union PSTAGES3 union PSTAGES4} (y1up[j]-log(S1[i,j])),min{(i,j) in PUNIT2S union PSTAGES3 union PSTAGES4}(y2up[j]-log(S2[i,j])),min{(i,j) in PSTAGES3}(y3up[j]+log(NG)-log(S3[i,j]))) ;
param y5lo{i in PRODUCTS} := max(log(y5LO[i]),max{(i,j) in PSTAGES1}log(T0[i,j])-log(NM)) ;
param y5up{i in PRODUCTS} := log(y5UP[i]) ;

param z1lo{j in UNIT1} := gamma1[j]*y1lo[j] ;
param z1up{j in UNIT1} := if j in STAGES1 then (log(NG) + log(NM) + gamma1[j]*y1up[j]) else (log(NM) + gamma1[j]*y1up[j]) ;
param z2lo{j in UNIT2} := gamma2[j]*y2lo[j] ; 
param z2up{j in UNIT2} := log(NM) + gamma2[j]*y2up[j] ;
param z3lo{j in UNIT3} := gamma3[j]*y3lo[j] ;
param z3up{j in UNIT3} := log(NG) + log(NM) + gamma3[j]*y3up[j] ;
param z6lo{(i,j) in PSTAGES3} := log(T1[i,j]) + y4lo[i] - log(NG) - y3up[j] ;
param z6up{(i,j) in PSTAGES3} := min (log(T1[i,j]) + y4up[i] - y3lo[j] , log(T1[i,j]) - log(S3[i,j]) ) ;
param z7lo{i in PRODUCTS} := max (max{(i,j) in PSTAGES1} (log(T0[i,j]) + log(S1[i,j]) - y1up[j]- log(NG) - log(NM)) , max{(i,j) in PSTAGES2} (log(T1[i,j]) - y3up[j] -log(NG) - log(NM)) , y5lo[i] - y4up[i]) ;
param z7up{i in PRODUCTS} := y5up[i] - y4lo[i] ;

param v1lo{j in UNIT1} := c1[j]*exp(gamma1[j]*y1lo[j]) ;
param v1up{j in UNIT1} := if j in STAGES1 then (c1[j]*exp(log(NG)+log(NM)+gamma1[j]*y1up[j])) else (c1[j]*exp(log(NM)+gamma1[j]*y1up[j])) ;
param v2lo{j in UNIT2} := c2[j]*exp(gamma2[j]*y2lo[j]) ;
param v2up{j in UNIT2} := c2[j]*exp(log(NM)+gamma2[j]*y2up[j]) ;
param v3lo{j in UNIT3} := c3[j]*exp(gamma3[j]*y3lo[j]) ;
param v3up{j in UNIT3} := c3[j]*exp(log(NG)+log(NM)+gamma3[j]*y3up[j]) ;

## constantes para transformaciones MIP
param a1{j in UNIT1, k in TMIP1} 	:=	(z1up[j] - z1lo[j])/NK1 ;
param b1{j in UNIT1, k in TMIP1}	:=	z1lo[j] + (k-1)*a1[j,k] ;
param beta1{j in UNIT1, k in TMIP1}	:=	c1[j]*exp(b1[j,k]) ;
param alpha1{j in UNIT1, k in TMIP1}	:=	c1[j]*exp(b1[j,k]) ;

param a2{j in UNIT2, k in TMIP2}	:=	(z2up[j] - z2lo[j])/NK2 ;
param b2{j in UNIT2, k in TMIP2}	:=	z2lo[j] + (k-1)*a2[j,k] ;
param beta2{j in UNIT2, k in TMIP2}	:=	c2[j]*exp(b2[j,k]) ;
param alpha2{j in UNIT2, k in TMIP2}	:=	c2[j]*exp(b2[j,k]) ;

param a3{j in UNIT3, k in TMIP3}	:=	( z3up[j] - z3lo[j] )/NK3 ;
param b3{j in UNIT3, k in TMIP3}	:=	z3lo[j] + (k-1)*a3[j,k] ;
param beta3{j in UNIT3, k in TMIP3}	:=	c3[j]*exp(b3[j,k]) ;
param alpha3{j in UNIT3, k in TMIP3}	:=	c3[j]*exp(b3[j,k]);

param a6{(i,j) in PSTAGES3, k in TMIP6}	:=	(z6up[i,j]-z6lo[i,j])/NK6 ; 
param b6{(i,j) in PSTAGES3, k in TMIP6}	:=	z6lo[i,j] + (k-1)*a6[i,j,k] ;
param beta6{(i,j) in PSTAGES3, k in TMIP6}	:=	log(T0[i,j]+exp(b6[i,j,k])) ;
param alpha6{(i,j) in PSTAGES3, k in TMIP6}	:=	exp(b6[i,j,k])/(T0[i,j]+exp(b6[i,j,k])) ;

param a7{i in PRODUCTS, k in TMIP7}	:=	(z7up[i] - z7lo[i])/NK7 ;
param b7{i in PRODUCTS, k in TMIP7}	:=	z7lo[i] + (k-1)*a7[i,k] ;
param beta7{i in PRODUCTS, k in TMIP7}	:=	exp(b7[i,k]) ;
param alpha7{i in PRODUCTS, k in TMIP7}	:=	exp(b7[i,k]) ;

##### VARIABLES
var r>= 0 , <= NR ;
var y1{j in UNIT1}	>= y1lo[j] , <= y1up[j] ;
var y2{j in UNIT2}	>= y2lo[j] , <= y2up[j] ;
var y3{j in UNIT3}	>= y3lo[j] , <= y3up[j] ;
var y4{i in PRODUCTS}	>= y4lo[i] , <= y4up[i] ;
var y5{i in PRODUCTS}	>= y5lo[i] , <= y5up[i] ;
var y6{j in STAGES, k in UNITSG} binary, >= 0 , <= 1 ;
var y7{j in STAGES, k in UNITSM} binary, >= 0 , <= 1 ;
var x1{j in STAGES} >= log(1) , <= log(NG) ;
var x2{j in STAGES} >= log(1) , <= log(NM) ;
var v1{j in UNIT1} >= v1lo[j] , <= v1up[j] ;
var v2{j in UNIT2} >= v2lo[j] , <= v2up[j] ;
var v3{j in UNIT3} >= v3lo[j] , <= v3up[j] ;
var v6{(i,j) in PSTAGES3} >= 0 ;
var v7{i in PRODUCTS} >= 0 ;
 
##### OBJECTIVE
minimize cost:
	  sum{j in STAGES1} v1[j]
	+ sum{j in STAGES2} ( v1[j] + v3[j] ) 
	+ sum{j in STAGES2 inter UNIT2} (v2[j])
	+ sum{j in STAGES3 union STAGES4} (v1[j] + v2[j] + v3[j]) 
	+ r*rho ;

##### CONSTRAINTS
## Restricciones para etapas batch
subject to C1_BATCH{(i,j) in PSTAGES1}:
	y1[j] + x1[j] >= log(S1[i,j]) + y4[i] ;
subject to C2_BATCH{(i,j) in PSTAGES1}:
	y5[i] + x2[j] >= log(T0[i,j]) ;

## Restricciones para unidades semicontinuas
subject to C1_SEMIC{(i,j) in PSTAGES2}:
	y1[j] >= log(S1[i,j]) + y4[i] ;
subject to C2_SEMIC{(i,j) in PUNIT2}:
	y2[j] >= log(S2[i,j]) + y4[i] ;
subject to C3_SEMIC{(i,j) in PSTAGES2}:
	y5[i] + y3[j] + x1[j] + x2[j] >= log(T1[i,j]) + y4[i] ;

### Restricciones para etapas cromatográficas
subject to C1_CHROM{(i,j) in PSTAGES5}:
	y1[j] >= log(S1[i,j]) + y4[i] ;
subject to C2_CHROM{(i,j) in PSTAGES5}:
	y2[j] >= log(S2[i,j]) + y4[i] ;
subject to C3_CHROM{(i,j) in PSTAGES5}:
	y3[j] + x1[j] >= log(S3[i,j]) + y4[i] ;
subject to C4_CHROM{(i,j) in PSTAGES3, k in TMIP6}:
	y5[i] + x2[j] >= alpha6[i,j,k]*(log(T1[i,j])+y4[i]-x1[j]-y3[j] -b6[i,j,k]) + beta6[i,j,k] ;
subject to C5_CHROM{(i,j) in PSTAGES4}:
	y5[i] + x2[j] >= log(T0[i,j]);

## Definición de variables v
subject to C1v1{j in STAGES1, k in TMIP1}:
	v1[j] >= alpha1[j,k]*(x1[j]+x2[j]+gamma1[j]*y1[j] - b1[j,k]) + beta1[j,k] ;
subject to C2v1{j in UNIT1 diff STAGES1, k in TMIP1}:
	v1[j] >= alpha1[j,k]*(x2[j]+gamma1[j]*y1[j] - b1[j,k]) + beta1[j,k] ;
subject to C1v2{j in UNIT2, k in TMIP2}:
	v2[j] >= alpha2[j,k]*(x2[j]+gamma2[j]*y2[j] - b2[j,k]) + beta2[j,k] ;
subject to C1v3{j in UNIT3, k in TMIP3}:
	v3[j] >= alpha3[j,k]*(x1[j]+x2[j]+gamma3[j]*y3[j] - b3[j,k]) + beta3[j,k] ;
subject to C1v7{i in PRODUCTS,k in TMIP7}:
	v7[i] >= d[i]*alpha7[i,k]*(y5[i]-y4[i]-b7[i,k])+d[i]*beta7[i,k] ;

## Horizonte de planificación
subject to CHP:
	sum{i in PRODUCTS} v7[i] <= delta + r;

## Variables binarias para número de etapas en paralelo
subject to EP1{j in STAGES}:
	x1[j] = sum{k in UNITSG} y6[j,k]*log(k) ;
subject to EP2{j in STAGES}:
	sum{k in UNITSG} y6[j,k] = 1 ;
subject to EP3{j in STAGES}:
	x2[j] = sum{k in UNITSM} y7[j,k]*log(k) ;
subject to EP4{j in STAGES}:
	sum{k in UNITSM} y7[j,k] = 1 ;
