(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     74015,       1857]
NotebookOptionsPosition[     70954,       1746]
NotebookOutlinePosition[     71589,       1771]
CellTagsIndexPosition[     71546,       1768]
WindowTitle->Penrose Tiles - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Penrose Tiles", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"c1", "=", 
   RowBox[{"N", "[", 
    RowBox[{"GoldenRatio", "-", "1"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.35752955334616*^9, 3.35752959778394*^9}, {
   3.35752965790933*^9, 3.35752973236293*^9}, 3.386340021344612*^9},
 CellID->350378124],

Cell[BoxData[
 RowBox[{
  RowBox[{"c2", "=", 
   RowBox[{"N", "[", 
    RowBox[{"2", "-", "GoldenRatio"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.35752955334616*^9, 3.35752959778394*^9}, {
   3.35752965790933*^9, 3.35752973437857*^9}, 3.3606980522824*^9, 
   3.36069875580703*^9, 3.3863400236102514`*^9, 3.386340053797945*^9},
 CellID->109016730],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Deflate", "[", 
    RowBox[{"a", "[", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"d", "=", 
        RowBox[{
         RowBox[{"c1", " ", "x"}], "+", 
         RowBox[{"c2", " ", "y"}]}]}], ",", 
       RowBox[{"e", "=", 
        RowBox[{
         RowBox[{"c1", " ", "y"}], "+", 
         RowBox[{"c2", " ", "z"}]}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "[", 
        RowBox[{"d", ",", "z", ",", "x"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"d", ",", "z", ",", "e"}], "]"}], ",", 
       RowBox[{"o", "[", 
        RowBox[{"y", ",", "e", ",", "d"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.35752955334616*^9, 3.35752959778394*^9}, {
   3.35752965790933*^9, 3.35752973855047*^9}, 3.36069805498556*^9, 
   3.36069875688517*^9, {3.386340035188451*^9, 3.3863400521885595`*^9}, {
   3.406315561786758*^9, 3.4063155636654882`*^9}},
 CellID->249180850],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Deflate", "[", 
    RowBox[{"o", "[", 
     RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "]"}], ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"d", "=", 
       RowBox[{
        RowBox[{"c2", " ", "x"}], "+", 
        RowBox[{"c1", " ", "z"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"o", "[", 
        RowBox[{"z", ",", "d", ",", "y"}], "]"}], ",", 
       RowBox[{"a", "[", 
        RowBox[{"y", ",", "x", ",", "d"}], "]"}]}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.35752955334616*^9, 3.35752959778394*^9}, {
   3.35752965790933*^9, 3.35752974089423*^9}, {3.36069805820435*^9, 
   3.36069806253253*^9}, {3.3863400364384584`*^9, 3.3863400527198133`*^9}, {
   3.406315565535335*^9, 3.406315567165347*^9}},
 CellID->435160463],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Deflate", "[", "x_List", "]"}], ":=", 
   RowBox[{"Join", "@@", 
    RowBox[{"Deflate", "/@", "x"}]}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.35752955334616*^9, 3.35752959778394*^9}, {
   3.35752965790933*^9, 3.35752974347237*^9}, {3.36069806104813*^9, 
   3.3606980645638*^9}},
 CellID->417362862],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Deflate", "[", 
    RowBox[{"x_", ",", "n_"}], "]"}], ":=", 
   RowBox[{"Nest", "[", 
    RowBox[{"Deflate", ",", "x", ",", "n"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.35752955334616*^9, 3.35752959778394*^9}, {
   3.35752965790933*^9, 3.35752974680052*^9}, 3.36069806515756*^9, 
   3.36069875947895*^9},
 CellID->80745030],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineGraph", "[", "t_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"t", "/.", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a", "[", 
       RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[Rule]", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "[", 
       RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[Rule]", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}]}]}], 
    "}"}]}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.36069918049996*^9, {3.386339944390995*^9, 
   3.3863399457660036`*^9}, {3.3863399918756733`*^9, 3.386339994719442*^9}, {
   3.3863407285991383`*^9, 3.3863407302241488`*^9}, 3.405972627102908*^9, {
   3.405973284663487*^9, 3.4059732854954348`*^9}, 3.405976973060142*^9, 
   3.405980219765366*^9, {3.405980364993978*^9, 3.4059804170120153`*^9}, 
   3.405980455491922*^9, 3.4059804918738623`*^9, {3.40631447497217*^9, 
   3.4063145764986973`*^9}, {3.406316660564887*^9, 3.406316680098256*^9}, {
   3.406316712716984*^9, 3.406316776366787*^9}, 3.406316833352132*^9, {
   3.406316880717533*^9, 3.4063168814337254`*^9}, 3.406316917492757*^9, {
   3.406317503938114*^9, 3.4063175079548597`*^9}, {3.406317548515916*^9, 
   3.406317561043812*^9}, {3.406320013646831*^9, 3.4063200206461906`*^9}},
 CellID->495227176],

Cell[BoxData[
 RowBox[{
  RowBox[{"LineGraph1", "[", "t_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Thickness", "[", ".005", "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Thickness", "[", ".005", "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "}"}], "&"}], "[", 
   RowBox[{"Last", "@", 
    RowBox[{"Reap", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"t", "/.", "\[IndentingNewLine]", "\[InvisibleSpace]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[RuleDelayed]", 
          "\[IndentingNewLine]", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"r", "=", 
              RowBox[{"Norm", "[", 
               RowBox[{"x", "-", "z"}], "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sow", "[", 
               RowBox[{
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
                "\"\<line\>\""}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Sow", "[", 
               RowBox[{
                RowBox[{"Circle", "[", 
                 RowBox[{"x", ",", 
                  RowBox[{"r", "/", "GoldenRatio"}], ",", 
                  RowBox[{"angles", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "z"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "]"}], ",", 
                "\"\<redcircle\>\""}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Sow", "[", 
               RowBox[{
                RowBox[{"Circle", "[", 
                 RowBox[{"y", ",", "r", ",", 
                  RowBox[{"angles", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"y", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "z"}], "}"}]}], "]"}]}], "]"}], ",", 
                "\"\<bluecircle\>\""}], "]"}]}], "\[IndentingNewLine]", 
             "}"}]}], "]"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"o", "[", 
           RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[RuleDelayed]", 
          "\[IndentingNewLine]", 
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"r", "=", 
              RowBox[{"Norm", "[", 
               RowBox[{"x", "-", "z"}], "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sow", "[", 
               RowBox[{
                RowBox[{"Line", "[", 
                 RowBox[{"{", 
                  RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
                "\"\<line\>\""}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Sow", "[", 
               RowBox[{
                RowBox[{"Circle", "[", 
                 RowBox[{"y", ",", 
                  RowBox[{"r", " ", "/", 
                   SuperscriptBox["GoldenRatio", "3"]}], ",", 
                  RowBox[{"angles", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"y", ",", "z"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}], "]"}], ",", 
                "\"\<redcircle\>\""}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Sow", "[", 
               RowBox[{
                RowBox[{"Circle", "[", 
                 RowBox[{"x", ",", 
                  RowBox[{"r", " ", "/", 
                   SuperscriptBox["GoldenRatio", "2"]}], ",", 
                  RowBox[{"angles", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "z"}], "}"}]}], "]"}]}], "]"}], ",", 
                "\"\<bluecircle\>\""}], "]"}]}], "\[IndentingNewLine]", 
             "}"}]}], "]"}]}]}], "\[IndentingNewLine]", "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<line\>\"", ",", "\"\<redcircle\>\"", ",", "\"\<bluecircle\>\""}], 
       "}"}]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.3863399487816477`*^9, 3.3863399745943127`*^9}, 
   3.4059726342653418`*^9, {3.405973286991837*^9, 3.405973287850153*^9}, 
   3.40597697114032*^9, 3.405980218666366*^9, {3.405980483485395*^9, 
   3.405980498904797*^9}, {3.4063146952228947`*^9, 3.406314715365291*^9}, {
   3.406316609617795*^9, 3.406316642882883*^9}, 3.406316831554473*^9, {
   3.406316876198043*^9, 3.40631687710599*^9}, 3.406316919435521*^9, {
   3.4063171290671797`*^9, 3.4063171347456303`*^9}, {3.406317553876796*^9, 
   3.406317559380081*^9}, {3.4063199460284567`*^9, 3.406319954532078*^9}, {
   3.406320029147272*^9, 3.406320047231131*^9}, {3.406320484488871*^9, 
   3.406320485576189*^9}, {3.4063216369782553`*^9, 3.406321639018772*^9}, {
   3.406321786236182*^9, 3.4063218153601217`*^9}, {3.406326724652512*^9, 
   3.406326751946907*^9}},
 CellID->181627242],

Cell[BoxData[
 RowBox[{
  RowBox[{"agraph", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", "=", 
      RowBox[{"Norm", "[", 
       RowBox[{"x", "-", "z"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sow", "[", 
       RowBox[{
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
        "\"\<line\>\""}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Sow", "[", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{"x", ",", 
          RowBox[{"r", "/", "GoldenRatio"}], ",", 
          RowBox[{"angles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "z"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "]"}], ",", 
        "\"\<redcircle\>\""}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Sow", "[", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{"y", ",", "r", ",", 
          RowBox[{"angles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"y", ",", "x"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "z"}], "}"}]}], "]"}]}], "]"}], ",", 
        "\"\<bluecircle\>\""}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
   "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.3863401218452554`*^9, 3.3863401405485*^9}, {
   3.3863403058308077`*^9, 3.3863403442373037`*^9}, {3.405980195092371*^9, 
   3.405980208372666*^9}, {3.406315317925956*^9, 3.406315329058831*^9}, {
   3.4063154244820633`*^9, 3.406315433570033*^9}, {3.4063198109066963`*^9, 
   3.4063198975423*^9}, 3.406319982209908*^9},
 CellID->334554016],

Cell[BoxData[
 RowBox[{
  RowBox[{"ograph", "[", 
   RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", "=", 
      RowBox[{"Norm", "[", 
       RowBox[{"x", "-", "z"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sow", "[", 
       RowBox[{
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
        "\"\<line\>\""}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Sow", "[", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{"y", ",", 
          RowBox[{"r", " ", "/", 
           SuperscriptBox["GoldenRatio", "3"]}], ",", 
          RowBox[{"angles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"y", ",", "z"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}], "]"}], ",", 
        "\"\<redcircle\>\""}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Sow", "[", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{"x", ",", 
          RowBox[{"r", " ", "/", 
           SuperscriptBox["GoldenRatio", "2"]}], ",", 
          RowBox[{"angles", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "z"}], "}"}]}], "]"}]}], "]"}], ",", 
        "\"\<bluecircle\>\""}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4063199911571074`*^9, 3.406320005256257*^9}},
 CellID->1662112483],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"angles", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a_", ",", "b_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c_", ",", "d_"}], "}"}]}], "]"}], ":=", "\[IndentingNewLine]", 
   
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"v1", "=", 
        RowBox[{"b", "-", "a"}]}], ",", 
       RowBox[{"v2", "=", 
        RowBox[{"d", "-", "c"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"shortway", "[", 
      RowBox[{
       RowBox[{"ArcTan", "@@", "v1"}], ",", 
       RowBox[{"ArcTan", "@@", "v2"}]}], "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.405980339322967*^9, 3.405980340736643*^9}},
 CellID->578058261],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"shortway", "[", 
    RowBox[{"theta1_", ",", "theta2_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"t2", "=", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"N", "[", "theta1", "]"}], ",", 
          RowBox[{"N", "[", "theta2", "]"}]}], "]"}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"t1", "=", 
        RowBox[{"Min", "[", 
         RowBox[{
          RowBox[{"N", "[", "theta1", "]"}], ",", 
          RowBox[{"N", "[", "theta2", "]"}]}], "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"N", "[", 
          RowBox[{"t2", "-", "t1"}], "]"}], "]"}], "<", 
        RowBox[{"N", "[", "\[Pi]", "]"}]}], ",", "\[IndentingNewLine]", 
       RowBox[{"N", "[", 
        RowBox[{"{", 
         RowBox[{"t1", ",", "t2"}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"N", "[", 
        RowBox[{"{", 
         RowBox[{"t2", ",", 
          RowBox[{"t1", "+", 
           RowBox[{"2", " ", "\[Pi]"}]}]}], "}"}], "]"}]}], 
      "\[IndentingNewLine]", "]"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, 3.405980091567192*^9, {3.405980165299295*^9, 
   3.405980185148849*^9}},
 CellID->175443619],

Cell[BoxData[
 RowBox[{
  RowBox[{"KiteColor", "=", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.2", ",", "0.2", ",", "1."}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.386340462503686*^9, 3.3863404682693477`*^9}},
 CellID->650751037],

Cell[BoxData[
 RowBox[{
  RowBox[{"DartColor", "=", 
   RowBox[{"RGBColor", "[", 
    RowBox[{"0.7", ",", "0.7", ",", "1."}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.386340462503686*^9, 3.386340471956871*^9}},
 CellID->195899434],

Cell[BoxData[
 RowBox[{
  RowBox[{"ColorGraph", "[", "t_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"#", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"KiteColor", ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"DartColor", ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", "3", "]"}], "]"}]}], "}"}]}], "}"}], "&"}], "[", 
   "\[IndentingNewLine]", 
   RowBox[{"Last", "@", 
    RowBox[{"Reap", "[", 
     RowBox[{
      RowBox[{"t", "/.", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "[", 
           RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[RuleDelayed]", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sow", "[", 
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
              "\"\<line\>\""}], "]"}], ",", 
            RowBox[{"Sow", "[", 
             RowBox[{
              RowBox[{"Polygon", "[", 
               RowBox[{"{", 
                RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
              "\"\<kitepolygon\>\""}], "]"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"o", "[", 
           RowBox[{"x_", ",", "y_", ",", "z_"}], "]"}], "\[RuleDelayed]", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Sow", "[", 
             RowBox[{
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
              "\"\<line\>\""}], "]"}], ",", 
            RowBox[{"Sow", "[", 
             RowBox[{
              RowBox[{"Polygon", "[", 
               RowBox[{"{", 
                RowBox[{"y", ",", "z", ",", "x"}], "}"}], "]"}], ",", 
              "\"\<dartpolygon\>\""}], "]"}]}], "}"}]}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<line\>\"", ",", "\"\<kitepolygon\>\"", ",", 
        "\"\<dartpolygon\>\""}], "}"}]}], "]"}]}], "]"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.3863404771287794`*^9, 3.386340512410255*^9}, 
   3.4059726397383003`*^9, 3.405972937920739*^9, {3.405976858032043*^9, 
   3.40597688162038*^9}, 3.405976933022134*^9, {3.405979998286697*^9, 
   3.405980005144744*^9}, {3.405980039329565*^9, 3.4059800425031433`*^9}, {
   3.406314736074114*^9, 3.406314747072657*^9}, {3.40631481224438*^9, 
   3.4063148147419167`*^9}, {3.406315636481439*^9, 3.406315669886544*^9}, {
   3.406316361394425*^9, 3.4063163774639883`*^9}, 3.4063173043845873`*^9, 
   3.406320535742775*^9, {3.406320780121611*^9, 3.40632090323878*^9}, {
   3.406320997717463*^9, 3.4063211363280487`*^9}, {3.4063212077082863`*^9, 
   3.406321221714974*^9}, {3.406321295372714*^9, 3.406321319094965*^9}, {
   3.4063270328866253`*^9, 3.4063270413171997`*^9}, {3.4063807061838293`*^9, 
   3.406380707279831*^9}},
 CellID->89967496],

Cell[BoxData[
 RowBox[{
  RowBox[{"AcuteTriangle", "=", 
   RowBox[{"N", "[", 
    RowBox[{"a", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"GoldenRatio", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"72", " ", "\[Degree]"}], "]"}]}], ",", 
        RowBox[{"GoldenRatio", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"72", " ", "\[Degree]"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.3863401865175447`*^9, 3.3863401882831807`*^9}},
 CellID->319692024],

Cell[BoxData[
 RowBox[{
  RowBox[{"ObtuseTriangle", "=", 
   RowBox[{"N", "[", 
    RowBox[{"o", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"c1", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"36", " ", "\[Degree]"}], "]"}]}], ",", 
        RowBox[{"c1", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"36", " ", "\[Degree]"}], "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.386340037438465*^9, 3.3863400380790944`*^9}},
 CellID->303177311],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sun", "=", 
   RowBox[{"N", "[", "\[IndentingNewLine]", 
    RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"a", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"36", "+", 
                 RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], "]"}],
              ",", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"36", "+", 
                 RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], 
              "]"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"a", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "36"}], "+", 
                 RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], "]"}],
              ",", 
             RowBox[{"Sin", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "36"}], "+", 
                 RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], 
              "]"}]}], "}"}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.386340242689779*^9, 3.3863402448147926`*^9}, {
   3.405980259922526*^9, 3.405980267387702*^9}, 3.40631594828443*^9},
 CellID->29140724],

Cell[BoxData[
 RowBox[{
  RowBox[{"Kite", "=", 
   RowBox[{"Sun", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellID->321370962],

Cell[BoxData[
 RowBox[{
  RowBox[{"star", "=", "\[IndentingNewLine]", 
   RowBox[{"N", "[", "\[IndentingNewLine]", 
    RowBox[{"Flatten", "[", "\[IndentingNewLine]", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"o", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}]}], "}"}], ",", 
           RowBox[{"GoldenRatio", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], 
               "]"}], ",", 
              RowBox[{"Sin", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"36", "+", 
                  RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], 
               "]"}]}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"o", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"72", " ", "i", " ", "\[Degree]"}], "]"}]}], "}"}], ",", 
           RowBox[{"GoldenRatio", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Cos", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "36"}], "+", 
                  RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], 
               "]"}], ",", 
              RowBox[{"Sin", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "36"}], "+", 
                  RowBox[{"72", " ", "i"}]}], ")"}], " ", "\[Degree]"}], 
               "]"}]}], "}"}]}]}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.386340237580371*^9, 3.386340239767885*^9}, 
   3.3997388400777283`*^9, {3.405980275515998*^9, 3.4059802843035192`*^9}, 
   3.406315953161837*^9},
 CellID->16703915],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dart", "=", 
   RowBox[{"star", "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.35696210375764*^9, 3.399738858717995*^9},
 CellID->693712215],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{"outlines", ",", 
        RowBox[{"If", "[", 
         RowBox[{"cr", ",", "LineGraph1", ",", "LineGraph"}], "]"}], ",", 
        "ColorGraph"}], "]"}], "[", 
      RowBox[{"Deflate", "[", 
       RowBox[{"init", ",", "n"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "400"}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "\"\<steps\>\""}], "}"}], ",", "0", ",", 
     "5", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"init", ",", "Sun", ",", "\"\<initial condition\>\""}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AcuteTriangle", "\[Rule]", "\"\<acute triangle\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"ObtuseTriangle", "\[Rule]", "\"\<obtuse triange\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Kite", "\[Rule]", "\"\<kite\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Dart", "\[Rule]", "\"\<dart\>\""}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Sun", "\[Rule]", "\"\<sun\>\""}], ",", "\[IndentingNewLine]", 
       
       RowBox[{"star", "\[Rule]", "\"\<star\>\""}]}], "}"}], ",", 
     "\[IndentingNewLine]", "SetterBar"}], "}"}], ",", "\[IndentingNewLine]", 
   "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"outlines", ",", "True", ",", "\"\<outlines only\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"cr", ",", "True", ",", "\"\<show construction lines\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4063271052132587`*^9, {3.406380732520953*^9, 
   3.4063807337267017`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`cr$$ = True, $CellContext`init$$ = {
     $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
      0.5877852522924731}], 
     $CellContext`a[{1., 0.}, {0., 0.}, {
      0.8090169943749475, -0.5877852522924731}], 
     $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
      0.}, {-0.30901699437494745`, 0.9510565162951535}], 
     $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 0.}, {
      0.8090169943749475, 0.5877852522924731}], 
     $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 0.}, {-1.,
       0.}], 
     $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
      0.}, {-0.30901699437494745`, 0.9510565162951535}], 
     $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
      0.}, {-0.30901699437494745`, -0.9510565162951535}], 
     $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
      0.}, {-1., 0.}], 
     $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 0.}, {
      0.8090169943749475, -0.5877852522924731}], 
     $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
      0.}, {-0.30901699437494745`, -0.9510565162951535}]}, $CellContext`n$$ = 
    2, $CellContext`outlines$$ = True, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 0, "steps"}, 0, 5, 1}, {{
       Hold[$CellContext`init$$], {
        $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
         0.5877852522924731}], 
        $CellContext`a[{1., 0.}, {0., 0.}, {
         0.8090169943749475, -0.5877852522924731}], 
        $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
         0.}, {-0.30901699437494745`, 0.9510565162951535}], 
        $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 0.}, {
         0.8090169943749475, 0.5877852522924731}], 
        $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
         0.}, {-1., 0.}], 
        $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
         0.}, {-0.30901699437494745`, 0.9510565162951535}], 
        $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
         0.}, {-0.30901699437494745`, -0.9510565162951535}], 
        $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
         0.}, {-1., 0.}], 
        $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
         0.}, {0.8090169943749475, -0.5877852522924731}], 
        $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
         0.}, {-0.30901699437494745`, -0.9510565162951535}]}, 
       "initial condition"}, {$CellContext`a[{0., 0.}, {0.5000000000000001, 
         1.5388417685876268`}, {1., 0.}] -> 
       "acute triangle", $CellContext`o[{1., 0.}, {0.5000000000000001, 
         0.3632712640026805}, {0., 0.}] -> "obtuse triange", {
         $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
          0.5877852522924731}], 
         $CellContext`a[{1., 0.}, {0., 0.}, {
          0.8090169943749475, -0.5877852522924731}]} -> "kite", {
         $CellContext`o[{0., 0.}, {1., 0.}, {1.3090169943749475`, 
          0.9510565162951536}], 
         $CellContext`o[{0., 0.}, {1., 0.}, {
          1.3090169943749475`, -0.9510565162951536}]} -> "dart", {
         $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
          0.5877852522924731}], 
         $CellContext`a[{1., 0.}, {0., 0.}, {
          0.8090169943749475, -0.5877852522924731}], 
         $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
          0.}, {-0.30901699437494745`, 0.9510565162951535}], 
         $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
          0.}, {0.8090169943749475, 0.5877852522924731}], 
         $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
          0.}, {-1., 0.}], 
         $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
          0.}, {-0.30901699437494745`, 0.9510565162951535}], 
         $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
          0.}, {-0.30901699437494745`, -0.9510565162951535}], 
         $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
          0.}, {-1., 0.}], 
         $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
          0.}, {0.8090169943749475, -0.5877852522924731}], 
         $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
          0.}, {-0.30901699437494745`, -0.9510565162951535}]} -> "sun", {
         $CellContext`o[{0., 0.}, {1., 0.}, {1.3090169943749475`, 
          0.9510565162951536}], 
         $CellContext`o[{0., 0.}, {1., 0.}, {
          1.3090169943749475`, -0.9510565162951536}], 
         $CellContext`o[{0., 0.}, {0.30901699437494745`, 
          0.9510565162951535}, {-0.5000000000000001, 1.5388417685876268`}], 
         $CellContext`o[{0., 0.}, {0.30901699437494745`, 
          0.9510565162951535}, {1.3090169943749475`, 0.9510565162951536}], 
         $CellContext`o[{0., 0.}, {-0.8090169943749475, 
          0.5877852522924731}, {-1.618033988749895, 0.}], 
         $CellContext`o[{0., 0.}, {-0.8090169943749475, 
          0.5877852522924731}, {-0.5000000000000001, 1.5388417685876268`}], 
         $CellContext`o[{0., 
          0.}, {-0.8090169943749475, -0.5877852522924731}, \
{-0.5000000000000001, -1.5388417685876268`}], 
         $CellContext`o[{0., 
          0.}, {-0.8090169943749475, -0.5877852522924731}, \
{-1.618033988749895, 0.}], 
         $CellContext`o[{0., 0.}, {
          0.30901699437494745`, -0.9510565162951535}, {
          1.3090169943749475`, -0.9510565162951536}], 
         $CellContext`o[{0., 0.}, {
          0.30901699437494745`, -0.9510565162951535}, {-0.5000000000000001, \
-1.5388417685876268`}]} -> "star"}}, {{
       Hold[$CellContext`outlines$$], True, "outlines only"}, {
      True, False}}, {{
       Hold[$CellContext`cr$$], True, "show construction lines"}, {
      True, False}}}, Typeset`size$$ = {500., {198., 202.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`n$1342$$ = 0, $CellContext`init$1343$$ = 
    False, $CellContext`outlines$1344$$ = False, $CellContext`cr$1345$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`cr$$ = True, $CellContext`init$$ = {
          $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
           0.5877852522924731}], 
          $CellContext`a[{1., 0.}, {0., 0.}, {
           0.8090169943749475, -0.5877852522924731}], 
          $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
           0.}, {-0.30901699437494745`, 0.9510565162951535}], 
          $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
           0.}, {0.8090169943749475, 0.5877852522924731}], 
          $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
           0.}, {-1., 0.}], 
          $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
           0.}, {-0.30901699437494745`, 0.9510565162951535}], 
          $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
           0.}, {-0.30901699437494745`, -0.9510565162951535}], 
          $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
           0.}, {-1., 0.}], 
          $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
           0.}, {0.8090169943749475, -0.5877852522924731}], 
          $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
           0.}, {-0.30901699437494745`, -0.9510565162951535}]}, \
$CellContext`n$$ = 0, $CellContext`outlines$$ = True}, "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1342$$, 0], 
        Hold[$CellContext`init$$, $CellContext`init$1343$$, False], 
        Hold[$CellContext`outlines$$, $CellContext`outlines$1344$$, False], 
        Hold[$CellContext`cr$$, $CellContext`cr$1345$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        If[$CellContext`outlines$$, 
         If[$CellContext`cr$$, $CellContext`LineGraph1, \
$CellContext`LineGraph], $CellContext`ColorGraph][
         $CellContext`Deflate[$CellContext`init$$, $CellContext`n$$]], 
        ImageSize -> {500, 400}], 
      "Specifications" :> {{{$CellContext`n$$, 0, "steps"}, 0, 5, 1, 
         Appearance -> "Labeled"}, {{$CellContext`init$$, {
           $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
            0.5877852522924731}], 
           $CellContext`a[{1., 0.}, {0., 0.}, {
            0.8090169943749475, -0.5877852522924731}], 
           $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
            0.}, {-0.30901699437494745`, 0.9510565162951535}], 
           $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
            0.}, {0.8090169943749475, 0.5877852522924731}], 
           $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
            0.}, {-1., 0.}], 
           $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
            0.}, {-0.30901699437494745`, 0.9510565162951535}], 
           $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
            0.}, {-0.30901699437494745`, -0.9510565162951535}], 
           $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
            0.}, {-1., 0.}], 
           $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
            0.}, {0.8090169943749475, -0.5877852522924731}], 
           $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
            0.}, {-0.30901699437494745`, -0.9510565162951535}]}, 
          "initial condition"}, {$CellContext`a[{0., 0.}, {0.5000000000000001,
             1.5388417685876268`}, {1., 0.}] -> 
          "acute triangle", $CellContext`o[{1., 0.}, {0.5000000000000001, 
            0.3632712640026805}, {0., 0.}] -> "obtuse triange", {
            $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
             0.5877852522924731}], 
            $CellContext`a[{1., 0.}, {0., 0.}, {
             0.8090169943749475, -0.5877852522924731}]} -> "kite", {
            $CellContext`o[{0., 0.}, {1., 0.}, {1.3090169943749475`, 
             0.9510565162951536}], 
            $CellContext`o[{0., 0.}, {1., 0.}, {
             1.3090169943749475`, -0.9510565162951536}]} -> "dart", {
            $CellContext`a[{1., 0.}, {0., 0.}, {0.8090169943749475, 
             0.5877852522924731}], 
            $CellContext`a[{1., 0.}, {0., 0.}, {
             0.8090169943749475, -0.5877852522924731}], 
            $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
             0.}, {-0.30901699437494745`, 0.9510565162951535}], 
            $CellContext`a[{0.30901699437494745`, 0.9510565162951535}, {0., 
             0.}, {0.8090169943749475, 0.5877852522924731}], 
            $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
             0.}, {-1., 0.}], 
            $CellContext`a[{-0.8090169943749475, 0.5877852522924731}, {0., 
             0.}, {-0.30901699437494745`, 0.9510565162951535}], 
            $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
             0.}, {-0.30901699437494745`, -0.9510565162951535}], 
            $CellContext`a[{-0.8090169943749475, -0.5877852522924731}, {0., 
             0.}, {-1., 0.}], 
            $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
             0.}, {0.8090169943749475, -0.5877852522924731}], 
            $CellContext`a[{0.30901699437494745`, -0.9510565162951535}, {0., 
             0.}, {-0.30901699437494745`, -0.9510565162951535}]} -> "sun", {
            $CellContext`o[{0., 0.}, {1., 0.}, {1.3090169943749475`, 
             0.9510565162951536}], 
            $CellContext`o[{0., 0.}, {1., 0.}, {
             1.3090169943749475`, -0.9510565162951536}], 
            $CellContext`o[{0., 0.}, {0.30901699437494745`, 
             0.9510565162951535}, {-0.5000000000000001, 1.5388417685876268`}], 
            $CellContext`o[{0., 0.}, {0.30901699437494745`, 
             0.9510565162951535}, {1.3090169943749475`, 
             0.9510565162951536}], 
            $CellContext`o[{0., 0.}, {-0.8090169943749475, 
             0.5877852522924731}, {-1.618033988749895, 0.}], 
            $CellContext`o[{0., 0.}, {-0.8090169943749475, 
             0.5877852522924731}, {-0.5000000000000001, 1.5388417685876268`}], 
            $CellContext`o[{0., 
             0.}, {-0.8090169943749475, -0.5877852522924731}, \
{-0.5000000000000001, -1.5388417685876268`}], 
            $CellContext`o[{0., 
             0.}, {-0.8090169943749475, -0.5877852522924731}, \
{-1.618033988749895, 0.}], 
            $CellContext`o[{0., 0.}, {
             0.30901699437494745`, -0.9510565162951535}, {
             1.3090169943749475`, -0.9510565162951536}], 
            $CellContext`o[{0., 0.}, {
             0.30901699437494745`, -0.9510565162951535}, \
{-0.5000000000000001, -1.5388417685876268`}]} -> "star"}, ControlType -> 
         SetterBar}, 
        Delimiter, {{$CellContext`outlines$$, True, "outlines only"}, {
         True, False}}, {{$CellContext`cr$$, True, 
          "show construction lines"}, {True, False}}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {279., 284.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`LineGraph1[
          Pattern[$CellContext`t, 
           Blank[]]] := ({
          Part[#, 1], {Red, 
           Thickness[0.005], 
           Part[#, 2]}, {Blue, 
           Thickness[0.005], 
           Part[#, 3]}}& )[
          Last[
           Reap[
            ReplaceAll[$CellContext`t, {$CellContext`a[
                Pattern[$CellContext`x, 
                 Blank[]], 
                Pattern[$CellContext`y, 
                 Blank[]], 
                Pattern[$CellContext`z, 
                 Blank[]]] :> 
              With[{$CellContext`r = Norm[$CellContext`x - $CellContext`z]}, {
                
                 Sow[
                  Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                  "line"], 
                 Sow[
                  Circle[$CellContext`x, $CellContext`r/GoldenRatio, 
                   $CellContext`angles[{$CellContext`x, $CellContext`z}, \
{$CellContext`x, $CellContext`y}]], "redcircle"], 
                 Sow[
                  Circle[$CellContext`y, $CellContext`r, 
                   $CellContext`angles[{$CellContext`y, $CellContext`x}, \
{$CellContext`y, $CellContext`z}]], "bluecircle"]}], $CellContext`o[
                Pattern[$CellContext`x, 
                 Blank[]], 
                Pattern[$CellContext`y, 
                 Blank[]], 
                Pattern[$CellContext`z, 
                 Blank[]]] :> 
              With[{$CellContext`r = Norm[$CellContext`x - $CellContext`z]}, {
                
                 Sow[
                  Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                  "line"], 
                 Sow[
                  Circle[$CellContext`y, $CellContext`r/GoldenRatio^3, 
                   $CellContext`angles[{$CellContext`y, $CellContext`z}, \
{$CellContext`y, $CellContext`x}]], "redcircle"], 
                 Sow[
                  Circle[$CellContext`x, $CellContext`r/GoldenRatio^2, 
                   $CellContext`angles[{$CellContext`x, $CellContext`y}, \
{$CellContext`x, $CellContext`z}]], "bluecircle"]}]}], {
            "line", "redcircle", "bluecircle"}]]], $CellContext`angles[{
           Pattern[$CellContext`a, 
            Blank[]], 
           Pattern[$CellContext`b, 
            Blank[]]}, {
           Pattern[$CellContext`c, 
            Blank[]], 
           Pattern[$CellContext`d, 
            Blank[]]}] := 
        With[{$CellContext`v1 = $CellContext`b - $CellContext`a, \
$CellContext`v2 = $CellContext`d - $CellContext`c}, 
          $CellContext`shortway[
           Apply[ArcTan, $CellContext`v1], 
           Apply[ArcTan, $CellContext`v2]]], $CellContext`shortway[
          Pattern[$CellContext`theta1, 
           Blank[]], 
          Pattern[$CellContext`theta2, 
           Blank[]]] := With[{$CellContext`t2 = Max[
             N[$CellContext`theta1], 
             N[$CellContext`theta2]], $CellContext`t1 = Min[
             N[$CellContext`theta1], 
             N[$CellContext`theta2]]}, 
          If[Abs[
             N[$CellContext`t2 - $CellContext`t1]] < N[Pi], 
           N[{$CellContext`t1, $CellContext`t2}], 
           
           N[{$CellContext`t2, $CellContext`t1 + 
             2 Pi}]]], $CellContext`LineGraph[
          Pattern[$CellContext`t, 
           Blank[]]] := ReplaceAll[$CellContext`t, {$CellContext`a[
             Pattern[$CellContext`x, 
              Blank[]], 
             Pattern[$CellContext`y, 
              Blank[]], 
             Pattern[$CellContext`z, 
              Blank[]]] -> 
           Line[{$CellContext`y, $CellContext`z, $CellContext`x}], \
$CellContext`o[
             Pattern[$CellContext`x, 
              Blank[]], 
             Pattern[$CellContext`y, 
              Blank[]], 
             Pattern[$CellContext`z, 
              Blank[]]] -> 
           Line[{$CellContext`y, $CellContext`z, $CellContext`x}]}], \
$CellContext`ColorGraph[
          Pattern[$CellContext`t, 
           Blank[]]] := ({
          Part[#, 1], {$CellContext`KiteColor, 
           Part[#, 2]}, {$CellContext`DartColor, 
           Part[#, 3]}}& )[
          Last[
           Reap[
            ReplaceAll[$CellContext`t, {$CellContext`a[
                Pattern[$CellContext`x, 
                 Blank[]], 
                Pattern[$CellContext`y, 
                 Blank[]], 
                Pattern[$CellContext`z, 
                 Blank[]]] :> {
                Sow[
                 Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                 "line"], 
                Sow[
                 Polygon[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                 "kitepolygon"]}, $CellContext`o[
                Pattern[$CellContext`x, 
                 Blank[]], 
                Pattern[$CellContext`y, 
                 Blank[]], 
                Pattern[$CellContext`z, 
                 Blank[]]] :> {
                Sow[
                 Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                 "line"], 
                Sow[
                 Polygon[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                 "dartpolygon"]}}], {
            "line", "kitepolygon", "dartpolygon"}]]], $CellContext`KiteColor = 
        RGBColor[0.2, 0.2, 1.], $CellContext`DartColor = 
        RGBColor[0.7, 0.7, 1.], $CellContext`Deflate[
          $CellContext`a[
           Pattern[$CellContext`x, 
            Blank[]], 
           Pattern[$CellContext`y, 
            Blank[]], 
           Pattern[$CellContext`z, 
            Blank[]]]] := 
        With[{$CellContext`d = $CellContext`c1 $CellContext`x + \
$CellContext`c2 $CellContext`y, $CellContext`e = $CellContext`c1 \
$CellContext`y + $CellContext`c2 $CellContext`z}, {
           $CellContext`a[$CellContext`d, $CellContext`z, $CellContext`x], 
           $CellContext`a[$CellContext`d, $CellContext`z, $CellContext`e], 
           $CellContext`o[$CellContext`y, $CellContext`e, $CellContext`d]}], \
$CellContext`Deflate[
          $CellContext`o[
           Pattern[$CellContext`x, 
            Blank[]], 
           Pattern[$CellContext`y, 
            Blank[]], 
           Pattern[$CellContext`z, 
            Blank[]]]] := 
        With[{$CellContext`d = $CellContext`c2 $CellContext`x + \
$CellContext`c1 $CellContext`z}, {
           $CellContext`o[$CellContext`z, $CellContext`d, $CellContext`y], 
           $CellContext`a[$CellContext`y, $CellContext`x, $CellContext`d]}], \
$CellContext`Deflate[
          Pattern[$CellContext`x, 
           Blank[List]]] := Apply[Join, 
          Map[$CellContext`Deflate, $CellContext`x]], $CellContext`Deflate[
          Pattern[$CellContext`x, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := 
        Nest[$CellContext`Deflate, $CellContext`x, $CellContext`n], \
$CellContext`c1 = 0.6180339887498949, $CellContext`c2 = 0.3819660112501051}; 
      Typeset`initDone$$ = True); ReleaseHold[
       HoldComplete[{$CellContext`c1 = N[GoldenRatio - 1]; 
         Null, $CellContext`c2 = N[2 - GoldenRatio]; 
         Null, $CellContext`Deflate[
            $CellContext`a[
             Pattern[$CellContext`x, 
              Blank[]], 
             Pattern[$CellContext`y, 
              Blank[]], 
             Pattern[$CellContext`z, 
              Blank[]]]] := 
          With[{$CellContext`d = $CellContext`c1 $CellContext`x + \
$CellContext`c2 $CellContext`y, $CellContext`e = $CellContext`c1 \
$CellContext`y + $CellContext`c2 $CellContext`z}, {
             $CellContext`a[$CellContext`d, $CellContext`z, $CellContext`x], 
             $CellContext`a[$CellContext`d, $CellContext`z, $CellContext`e], 
             $CellContext`o[$CellContext`y, $CellContext`e, $CellContext`d]}]; 
         Null, $CellContext`Deflate[
            $CellContext`o[
             Pattern[$CellContext`x, 
              Blank[]], 
             Pattern[$CellContext`y, 
              Blank[]], 
             Pattern[$CellContext`z, 
              Blank[]]]] := 
          With[{$CellContext`d = $CellContext`c2 $CellContext`x + \
$CellContext`c1 $CellContext`z}, {
             $CellContext`o[$CellContext`z, $CellContext`d, $CellContext`y], 
             $CellContext`a[$CellContext`y, $CellContext`x, $CellContext`d]}]; 
         Null, $CellContext`Deflate[
            Pattern[$CellContext`x, 
             Blank[List]]] := Apply[Join, 
            Map[$CellContext`Deflate, $CellContext`x]]; 
         Null, $CellContext`Deflate[
            Pattern[$CellContext`x, 
             Blank[]], 
            Pattern[$CellContext`n, 
             Blank[]]] := 
          Nest[$CellContext`Deflate, $CellContext`x, $CellContext`n]; Null, 
         LineGraph[
           Pattern[$CellContext`t, 
            Blank[]]] := ReplaceAll[$CellContext`t, {$CellContext`a[
              Pattern[$CellContext`x, 
               Blank[]], 
              Pattern[$CellContext`y, 
               Blank[]], 
              Pattern[$CellContext`z, 
               Blank[]]] -> 
            Line[{$CellContext`y, $CellContext`z, $CellContext`x}], \
$CellContext`o[
              Pattern[$CellContext`x, 
               Blank[]], 
              Pattern[$CellContext`y, 
               Blank[]], 
              Pattern[$CellContext`z, 
               Blank[]]] -> 
            Line[{$CellContext`y, $CellContext`z, $CellContext`x}]}], \
$CellContext`LineGraph1[
           Pattern[$CellContext`t, 
            Blank[]]] := ({
           Part[#, 1], {Red, 
            Thickness[0.005], 
            Part[#, 2]}, {Blue, 
            Thickness[0.005], 
            Part[#, 3]}}& )[
           Last[
            Reap[
             ReplaceAll[$CellContext`t, {$CellContext`a[
                 Pattern[$CellContext`x, 
                  Blank[]], 
                 Pattern[$CellContext`y, 
                  Blank[]], 
                 Pattern[$CellContext`z, 
                  Blank[]]] :> 
               With[{$CellContext`r = Norm[$CellContext`x - $CellContext`z]}, {
                  Sow[
                   Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                   "line"], 
                  Sow[
                   Circle[$CellContext`x, $CellContext`r/GoldenRatio, 
                    $CellContext`angles[{$CellContext`x, $CellContext`z}, \
{$CellContext`x, $CellContext`y}]], "redcircle"], 
                  Sow[
                   Circle[$CellContext`y, $CellContext`r, 
                    $CellContext`angles[{$CellContext`y, $CellContext`x}, \
{$CellContext`y, $CellContext`z}]], "bluecircle"]}], $CellContext`o[
                 Pattern[$CellContext`x, 
                  Blank[]], 
                 Pattern[$CellContext`y, 
                  Blank[]], 
                 Pattern[$CellContext`z, 
                  Blank[]]] :> 
               With[{$CellContext`r = Norm[$CellContext`x - $CellContext`z]}, {
                  Sow[
                   Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                   "line"], 
                  Sow[
                   Circle[$CellContext`y, $CellContext`r/GoldenRatio^3, 
                    $CellContext`angles[{$CellContext`y, $CellContext`z}, \
{$CellContext`y, $CellContext`x}]], "redcircle"], 
                  Sow[
                   Circle[$CellContext`x, $CellContext`r/GoldenRatio^2, 
                    $CellContext`angles[{$CellContext`x, $CellContext`y}, \
{$CellContext`x, $CellContext`z}]], "bluecircle"]}]}], {
             "line", "redcircle", "bluecircle"}]]], $CellContext`agraph[
           Pattern[$CellContext`x, 
            Blank[]], 
           Pattern[$CellContext`y, 
            Blank[]], 
           Pattern[$CellContext`z, 
            Blank[]]] := 
         With[{$CellContext`r = Norm[$CellContext`x - $CellContext`z]}, {
            Sow[
             Line[{$CellContext`y, $CellContext`z, $CellContext`x}], "line"], 
            
            Sow[
             Circle[$CellContext`x, $CellContext`r/GoldenRatio, 
              $CellContext`angles[{$CellContext`x, $CellContext`z}, \
{$CellContext`x, $CellContext`y}]], "redcircle"], 
            Sow[
             Circle[$CellContext`y, $CellContext`r, 
              $CellContext`angles[{$CellContext`y, $CellContext`x}, \
{$CellContext`y, $CellContext`z}]], "bluecircle"]}], $CellContext`ograph[
           Pattern[$CellContext`x, 
            Blank[]], 
           Pattern[$CellContext`y, 
            Blank[]], 
           Pattern[$CellContext`z, 
            Blank[]]] := 
         With[{$CellContext`r = Norm[$CellContext`x - $CellContext`z]}, {
            Sow[
             Line[{$CellContext`y, $CellContext`z, $CellContext`x}], "line"], 
            
            Sow[
             Circle[$CellContext`y, $CellContext`r/GoldenRatio^3, 
              $CellContext`angles[{$CellContext`y, $CellContext`z}, \
{$CellContext`y, $CellContext`x}]], "redcircle"], 
            Sow[
             Circle[$CellContext`x, $CellContext`r/GoldenRatio^2, 
              $CellContext`angles[{$CellContext`x, $CellContext`y}, \
{$CellContext`x, $CellContext`z}]], "bluecircle"]}], $CellContext`angles[{
             Pattern[$CellContext`a, 
              Blank[]], 
             Pattern[$CellContext`b, 
              Blank[]]}, {
             Pattern[$CellContext`c, 
              Blank[]], 
             Pattern[$CellContext`d, 
              Blank[]]}] := 
          With[{$CellContext`v1 = $CellContext`b - $CellContext`a, \
$CellContext`v2 = $CellContext`d - $CellContext`c}, 
            $CellContext`shortway[
             Apply[ArcTan, $CellContext`v1], 
             Apply[ArcTan, $CellContext`v2]]]; Null, $CellContext`shortway[
            Pattern[$CellContext`theta1, 
             Blank[]], 
            Pattern[$CellContext`theta2, 
             Blank[]]] := With[{$CellContext`t2 = Max[
               N[$CellContext`theta1], 
               N[$CellContext`theta2]], $CellContext`t1 = Min[
               N[$CellContext`theta1], 
               N[$CellContext`theta2]]}, 
            If[Abs[
               N[$CellContext`t2 - $CellContext`t1]] < N[Pi], 
             N[{$CellContext`t1, $CellContext`t2}], 
             N[{$CellContext`t2, $CellContext`t1 + 2 Pi}]]]; 
         Null, $CellContext`KiteColor = RGBColor[0.2, 0.2, 1.]; 
         Null, $CellContext`DartColor = RGBColor[0.7, 0.7, 1.]; 
         Null, $CellContext`ColorGraph[
           Pattern[$CellContext`t, 
            Blank[]]] := ({
           Part[#, 1], {$CellContext`KiteColor, 
            Part[#, 2]}, {$CellContext`DartColor, 
            Part[#, 3]}}& )[
           Last[
            Reap[
             ReplaceAll[$CellContext`t, {$CellContext`a[
                 Pattern[$CellContext`x, 
                  Blank[]], 
                 Pattern[$CellContext`y, 
                  Blank[]], 
                 Pattern[$CellContext`z, 
                  Blank[]]] :> {
                 Sow[
                  Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                  "line"], 
                 Sow[
                  Polygon[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                  "kitepolygon"]}, $CellContext`o[
                 Pattern[$CellContext`x, 
                  Blank[]], 
                 Pattern[$CellContext`y, 
                  Blank[]], 
                 Pattern[$CellContext`z, 
                  Blank[]]] :> {
                 Sow[
                  Line[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                  "line"], 
                 Sow[
                  Polygon[{$CellContext`y, $CellContext`z, $CellContext`x}], 
                  "dartpolygon"]}}], {
             "line", "kitepolygon", 
              "dartpolygon"}]]], $CellContext`AcuteTriangle = N[
            $CellContext`a[{0, 0}, {
             GoldenRatio Cos[72 Degree], GoldenRatio Sin[72 Degree]}, {1, 
             0}]]; Null, $CellContext`ObtuseTriangle = N[
            $CellContext`o[{1, 
             0}, {$CellContext`c1 Cos[36 Degree], $CellContext`c1 
              Sin[36 Degree]}, {0, 0}]]; Null, $CellContext`Sun = N[
            Flatten[
             Table[{
               $CellContext`a[{
                 Cos[72 $CellContext`i Degree], 
                 Sin[72 $CellContext`i Degree]}, {0, 0}, {
                 Cos[(36 + 72 $CellContext`i) Degree], 
                 Sin[(36 + 72 $CellContext`i) Degree]}], 
               $CellContext`a[{
                 Cos[72 $CellContext`i Degree], 
                 Sin[72 $CellContext`i Degree]}, {0, 0}, {
                 Cos[(-36 + 72 $CellContext`i) Degree], 
                 Sin[(-36 + 72 $CellContext`i) Degree]}]}, {$CellContext`i, 0,
                4}]]]; Null, $CellContext`Kite = 
          Part[$CellContext`Sun, {1, 2}]; Null, $CellContext`star = N[
            Flatten[
             Table[{
               $CellContext`o[{0, 0}, {
                 Cos[72 $CellContext`i Degree], 
                 Sin[72 $CellContext`i Degree]}, GoldenRatio {
                  Cos[(36 + 72 $CellContext`i) Degree], 
                  Sin[(36 + 72 $CellContext`i) Degree]}], 
               $CellContext`o[{0, 0}, {
                 Cos[72 $CellContext`i Degree], 
                 Sin[72 $CellContext`i Degree]}, GoldenRatio {
                  Cos[(-36 + 72 $CellContext`i) Degree], 
                  Sin[(-36 + 72 $CellContext`i) Degree]}]}, {$CellContext`i, 
               0, 4}]]]; 
         Null, $CellContext`Dart = Part[$CellContext`star, {1, 2}]; Null}]]; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->638402187],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Penrose's non-periodic tiling is constructed by a substitution system that \
successively \"deflates\" tiles, splitting them in two.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Penrose Tiles",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/PenroseTiles/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/PenroseTiles/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/PenroseTiles/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/PenroseTiles/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/PenroseTiles/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[CellGroupData[{

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Stephen Wolfram",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Stephen+\
Wolfram"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Stephen+Wolfram"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "Based on a program by: ",
 ButtonBox["Lyman Hurd",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Lyman+Hurd"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Lyman+Hurd"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->1012215094],

Cell[TextData[{
 "Optimized by: ",
 ButtonBox["Joe Bolte",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Joe+Bolte"], 
    None}]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->499388398]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
PenroseTiles"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Penrose Tiles - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[615, 23, 133, 3, 70, "Section"],
Cell[751, 28, 3700, 64, 70, "Section"],
Cell[4454, 94, 337, 9, 70, "Input",
 InitializationCell->True,
 CellID->350378124],
Cell[4794, 105, 406, 10, 70, "Input",
 InitializationCell->True,
 CellID->109016730],
Cell[5203, 117, 1181, 34, 70, "Input",
 InitializationCell->True,
 CellID->249180850],
Cell[6387, 153, 951, 27, 70, "Input",
 InitializationCell->True,
 CellID->435160463],
Cell[7341, 182, 398, 11, 70, "Input",
 InitializationCell->True,
 CellID->417362862],
Cell[7742, 195, 431, 12, 70, "Input",
 InitializationCell->True,
 CellID->80745030],
Cell[8176, 209, 1506, 32, 70, "Input",
 CellID->495227176],
Cell[9685, 243, 5644, 132, 70, "Input",
 CellID->181627242],
Cell[15332, 377, 1858, 49, 70, "Input",
 InitializationCell->True,
 CellID->334554016],
Cell[17193, 428, 1653, 46, 70, "Input",
 CellID->1662112483],
Cell[18849, 476, 785, 25, 70, "Input",
 InitializationCell->True,
 CellID->578058261],
Cell[19637, 503, 1452, 42, 70, "Input",
 InitializationCell->True,
 CellID->175443619],
Cell[21092, 547, 290, 8, 70, "Input",
 InitializationCell->True,
 CellID->650751037],
Cell[21385, 557, 288, 8, 70, "Input",
 InitializationCell->True,
 CellID->195899434],
Cell[21676, 567, 3219, 80, 70, "Input",
 InitializationCell->True,
 CellID->89967496],
Cell[24898, 649, 712, 21, 70, "Input",
 InitializationCell->True,
 CellID->319692024],
Cell[25613, 672, 693, 21, 70, "Input",
 InitializationCell->True,
 CellID->303177311],
Cell[26309, 695, 2481, 66, 70, "Input",
 InitializationCell->True,
 CellID->29140724],
Cell[28793, 763, 226, 8, 70, "Input",
 InitializationCell->True,
 CellID->321370962],
Cell[29022, 773, 2650, 69, 70, "Input",
 InitializationCell->True,
 CellID->16703915],
Cell[31675, 844, 290, 9, 70, "Input",
 InitializationCell->True,
 CellID->693712215],
Cell[31968, 855, 2390, 63, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34395, 923, 31560, 649, 70, "Output",
 CellID->638402187],
Cell[CellGroupData[{
Cell[65980, 1576, 209, 6, 70, "Section"],
Cell[66192, 1584, 156, 3, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66396, 1593, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[66754, 1604, 850, 24, 70, "Text"],
Cell[CellGroupData[{
Cell[67629, 1632, 439, 14, 70, "Text"],
Cell[68071, 1648, 455, 15, 70, "Text",
 CellID->1012215094],
Cell[68529, 1665, 358, 13, 70, "Text",
 CellID->499388398]
}, Open  ]],
Cell[CellGroupData[{
Cell[68924, 1683, 815, 24, 70, "Text"],
Cell[69742, 1709, 1184, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature YRj7nOS@GOlnOC0wjkPjuEAg *)
