package com.example.httprequestexample;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

public class MyHttpClient {
	/**
	 * Hace una peticion GET a la url "url"
	 * 
	 * @param url, la url a la que queremos acceder
	 * @return el contenido de la pagina con url "url"
	 */
    static String HttpConnectionGET(String url) {
    	// el "browser" o cliente http, que sabe como obtener lo que hay tras una URL
    	DefaultHttpClient cliente = new DefaultHttpClient();
    	
    	// el metodo GET usualmente es para obtener el contenido de una pagina
    	// aca vamos a pedir la URL "url"
    	HttpGet get = new HttpGet(url);
    	
    	// como un String, solo que podemos modificarlo
    	// (sabias que no se puede hacer eso con un objeto de tipo String?)
    	StringBuilder sb = new StringBuilder();
    	
    	try {    		
    		// obtenemos la respuesta haciendo una peticion de tipo GET al cliente
    		HttpResponse respuesta = cliente.execute(get);
    		
    		// el statusLine engloba lo que es la respuesta del servidor al hacer la peticion
    		StatusLine statusLine = respuesta.getStatusLine();
    		
    		// el numero como tal... conocen el 404 supongo
    		int statusCode = statusLine.getStatusCode();
    		
    		switch(statusCode) {
    		case 200: // success!
    			// el buffered reader lee el contenido de la pagina dada por la URL "url"
    			BufferedReader bf = new BufferedReader(new InputStreamReader(respuesta.getEntity().getContent()));
    			String linea;
    			
    			// leemos hasta que se acabe el archivo y lo ponemos en el StringBuilder
    			while( (linea=bf.readLine()) != null ) {
    				sb.append(linea);
    			}
    			break;
    		case 404: // not found    			
    			sb.append("Not found!");
    			break;
    		case 500: // internal server error    			
    			sb.append("El servidor esta echando humo, esta confundido o es chileno... tuvo un error interno D:!");
    			break;
    		default: // cualquier otro status: 503, 303, etc..
    			sb.append("Otro status code: " + statusCode);    			
    			break;
    		}
    	} catch(ClientProtocolException e) {
            e.printStackTrace();
            sb.append("Error: " + e.getMessage() );
        } catch (IOException e) {
            e.printStackTrace();
            sb.append("Error: " + e.getMessage() );
        }
    	
    	return sb.toString();
    }
	
}
