package com.example.httprequestexample;

import java.io.IOException;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

import android.app.Activity;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;

public class MainActivity extends Activity {
	
	ProgressBar pb;
	Button bt;
	TextView ans;
	
	static final String URL = "http://isitchristmas.com/";
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        
        pb = (ProgressBar) findViewById(R.id.progressBar1);
        pb.setVisibility(View.INVISIBLE);
        
        bt = (Button) findViewById(R.id.button1);
        ans = (TextView) findViewById(R.id.textView2);
        
        bt.setOnClickListener(new OnClickListener() {
			
			public void onClick(View v) {
			
				// al deshabilitarlo impedimos que se haga una peticion y el sonido muchas veces
				// al terminar la tarea se rehabilita
				bt.setEnabled(false);
				
				// 
				new ClaseQueSeConectaAInternetYDescargaUnaPaginaHandler().execute(URL);
				
			}
		});
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
    
  
    /*
     * AsyncTask es una "tarea asincrona"
     * se ejecuta en segundo plano mientras el usuario puede seguir
     * realizando acciones con la aplicacion o el telefono, es decir,
     * no tiene que esperar a que termine la operacion para poder
     * seguir usando el telefono
     * 
     * los parametros que hay despues del AsyncTask se refieren a los tipos que usara para
     * - Parametro de entrada (String)
     * - Lo que usara para medir el progreso de la tarea (Void)
     * - Lo que retornara como resultado al realizar la tarea (String)
     * 
     * los tipos se pueden cambiar o adaptar a los que uno quiera, para este ejemplo los puse como
     * String, Void, String..
     */
    public class ClaseQueSeConectaAInternetYDescargaUnaPaginaHandler extends AsyncTask<String, Void, String> {

    	// surprise ;)
    	MediaPlayer mp;
    	
    	// que se va a hacer mientras (antes de) se ejecuta la tarea...
    	@Override
    	protected void onPreExecute() {
    		pb.setVisibility(View.VISIBLE);
    		pb.setIndeterminate(true);    		
    		ans.setText("");
    		
    		mp = MediaPlayer.create(MainActivity.this, R.raw.my_sound);
			mp.start();
			
    	}
    	
    	// ejecucion de la tarea, en segundo plano
		@Override
		protected String doInBackground(String... params) {
			String url = params[0];
			
			// esta es la tarea que toma tiempo indeterminado, pues
			// depende de factores sobre los que no se tiene control
			String content = MyHttpClient.HttpConnectionGET(url);
			
			return content;
		}
		
		
		// lo que hara al terminar
		@Override
		protected void onPostExecute(String result) {
			super.onPostExecute(result);			
			
			// apagamos el progressbar
			pb.setVisibility(View.INVISIBLE);
			pb.setIndeterminate(false);
			
			String so = extractAnswer(result);
			
			
			ans.setText(so);
			
			// rehabilitamos el boton
			bt.setEnabled(true);
		}
    }
    
    /*
     * extrae del html obtenido lo que nos importa,
     * saber si es o no navidad en este momento
     * 
     * para esto usamos la libreria Jsoup, que con dos lineas
     * nos permite obtener el contenido de un tag html
     */
    private static String extractAnswer(String html) {
    	Document doc = Jsoup.parse(html);
    	return doc.getElementById("answer").text();
    }
          
}
