package com.example.sharedpreferencesexample;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.os.Bundle;
import android.view.Menu;

public class MainActivity extends Activity {

	SharedPreferences prefs;
	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        prefs = this.getSharedPreferences("com.example.sharedprefencesexample", Context.MODE_PRIVATE);
        
        setNumero(8);
        System.out.println(getNumero());
    }
    
    
    public void setNumero(int num) {
    	Editor preferenciasEditables = prefs.edit();
    	
    	// el commit guarda los cambios! si no se llama sobre este editor
    	// no se guardara el valor
    	preferenciasEditables.putInt("identificadorDeEsteCampo", num).commit();
    }
    
    public int getNumero() {
    	// si "identificadorDeEsteCampo" no existe, retorna 42
    	int miNumero = prefs.getInt("identificadorDeEsteCampo", 42);
    	
    	return miNumero;
    }
    
    public void agregar(int num) {
    	int antiguo = getNumero();
    	
    	setNumero(antiguo + num);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
}
