package com.example.database;

import java.util.ArrayList;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.provider.BaseColumns;
import android.util.Log;

/*
 * almacenamiento: SQLite
 * referencias: 
 * 
 * http://developer.android.com/guide/topics/data/data-storage.html
 * http://www.youtube.com/watch?v=c5n90wiv75M
 * http://coding.smashingmagazine.com/2011/03/28/get-started-developing-for-android-with-eclipse-reloaded/
 * 
 */
public class PokedexData {

	public static final String TAG = "PokedexData";
	
	public static final String DB_NAME = "pokedex.db";
	public static final int VERSION = 1;
	
	public static final String TABLE_NAME = "pokemon";
	
	public static final String ID = BaseColumns._ID;
	public static final String NAME = "name";
	public static final String TYPE = "type";
	public static final String GENDER = "gender";
	public static final String DESC = "description";
	public static final String LOCATION = "location";	
	public static final String CREATED_AT = "created_at";
	
	Context context;
	DbHelper dbHelper;
	SQLiteDatabase db;
	
	public PokedexData(Context ctx) {
		this.context = ctx;
		this.dbHelper = new DbHelper();
	}
	
	public void insert(Pokemon pokemon) {
		db = dbHelper.getWritableDatabase();
		
		ContentValues values = new ContentValues();
		values.put(NAME, pokemon.name);
		values.put(TYPE, pokemon.type);
		values.put(GENDER, pokemon.gender);
		values.put(DESC, pokemon.description);
		values.put(LOCATION, pokemon.location);
		
		db.insert(TABLE_NAME, null, values);
		db.close();
	}
	
	public Cursor getAll() {
		db = dbHelper.getWritableDatabase();
		
		Cursor cursor = null;
		cursor = db.query(TABLE_NAME, new String[]{
				ID, NAME, TYPE, GENDER, DESC, LOCATION, CREATED_AT
		}, null, null, null, null, null);
		
//		ArrayList<Pokemon> res = new ArrayList<Pokemon>();
//		while(cursor.moveToNext()) {
//			/*
//			 * en el mismo orden en que se pasaron las columnas en db.query(..)
//			 */
////			String id = cursor.getString(0);
//			String name = cursor.getString(1);
//			String type = cursor.getString(2);
//			String gender = cursor.getString(3);
//			String desc = cursor.getString(4);
//			String location = cursor.getString(5);
////			String created_at = cursor.getString(6);
//			
//			Pokemon pk = new Pokemon(name, gender, type, desc, location);
//			res.add(pk);
//		}
		
		if(cursor != null) 
			cursor.moveToFirst();
		
		db.close();
		return cursor;
	}
	
	class DbHelper extends SQLiteOpenHelper {

		public DbHelper() {
			super(context, DB_NAME, null, VERSION);
			// TODO Auto-generated constructor stub
		}

		@Override
		public void onCreate(SQLiteDatabase db) {
			// TODO Auto-generated method stub
			String sql = "create table " + TABLE_NAME +
						 " (" + ID + " integer primary key autoincrement, " +
						 NAME + " text, " +
						 TYPE + " text, " +
						 GENDER + " text, " +
						 DESC + " text, " +
						 LOCATION + " text, " +
						 CREATED_AT + " date default CURRENT_DATE) ";
			
			Log.d(TAG, "onCreate called, sql = " + sql);
			db.execSQL(sql);			
		}

		@Override
		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
			// TODO Auto-generated method stub
			db.execSQL("drop if exists "+ TABLE_NAME);
			onCreate(db);
		}
		
	}

}
