package com.example.database;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class MainActivity extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        final PokedexData pd = new PokedexData(this);
        
        final EditText e_name = (EditText) findViewById(R.id.editText1);
        final EditText e_type = (EditText) findViewById(R.id.editText2);
        final EditText e_gender = (EditText) findViewById(R.id.editText3);
        final EditText e_location = (EditText) findViewById(R.id.editText4);
        final EditText e_desc = (EditText) findViewById(R.id.editText5);
        
        Button add = (Button) findViewById(R.id.button1);
        Button view = (Button) findViewById(R.id.button2);
        
        add.setOnClickListener(new OnClickListener() {
			
			public void onClick(View v) {
				Pokemon p = new Pokemon(e_name.getText().toString(),
						e_gender.getText().toString(),
						e_type.getText().toString(),
						e_desc.getText().toString(),
						e_location.getText().toString());
				
				pd.insert(p);
				Toast.makeText(MainActivity.this, "Pokemon agregado al Pokedex!", Toast.LENGTH_LONG).show();
			}
		});
        
        
        view.setOnClickListener(new OnClickListener() {
			
			public void onClick(View v) {
				Intent i = new Intent(MainActivity.this, ListActivity.class);
				startActivity(i);
			}
		});
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
}
