package com.example.actionbarexample;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.View;
import android.widget.Toast;

import com.markupartist.android.widget.ActionBar;
import com.markupartist.android.widget.ActionBar.Action;

/*
 * documentacion de uso del actionbar en
 * https://github.com/johannilsson/android-actionbar
 */

public class MainActivity extends Activity {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        ActionBar actionBar = (ActionBar) findViewById(R.id.actionbar);
	    // You can also assign the title programmatically by passing a
	    // CharSequence or resource id.
	    actionBar.setTitle("Hello Mundo!");	    
	    actionBar.setHomeAction(new Action() {			
			@Override
			public void performAction(View view) {
				Intent i = new Intent(MainActivity.this, MainActivity.class);
				startActivity(i);
			}			
			@Override
			public int getDrawable() {
				return android.R.drawable.ic_lock_idle_alarm;				
			}
		});
	    
	    actionBar.addAction(new Action() {
			@Override
			public void performAction(View view) {
				Toast.makeText(MainActivity.this, "Me gusta saludar: hola!", Toast.LENGTH_LONG).show();
			}
			
			@Override
			public int getDrawable() {
				return android.R.drawable.btn_default;
			}
		});
    }
    

    
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }
}
