/*
 * Decompiled with CFR 0.152.
 */
package com.markupartist.android.widget;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.markupartist.android.widget.actionbar.R;
import java.util.LinkedList;

public class ActionBar
extends RelativeLayout
implements View.OnClickListener {
    private LayoutInflater mInflater;
    private RelativeLayout mBarView;
    private ImageView mLogoView;
    private View mBackIndicator;
    private TextView mTitleView;
    private LinearLayout mActionsView;
    private ImageButton mHomeBtn;
    private RelativeLayout mHomeLayout;
    private ProgressBar mProgress;

    public ActionBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mBarView = (RelativeLayout)this.mInflater.inflate(R.layout.actionbar, null);
        this.addView((View)this.mBarView);
        this.mLogoView = (ImageView)this.mBarView.findViewById(R.id.actionbar_home_logo);
        this.mHomeLayout = (RelativeLayout)this.mBarView.findViewById(R.id.actionbar_home_bg);
        this.mHomeBtn = (ImageButton)this.mBarView.findViewById(R.id.actionbar_home_btn);
        this.mBackIndicator = this.mBarView.findViewById(R.id.actionbar_home_is_back);
        this.mTitleView = (TextView)this.mBarView.findViewById(R.id.actionbar_title);
        this.mActionsView = (LinearLayout)this.mBarView.findViewById(R.id.actionbar_actions);
        this.mProgress = (ProgressBar)this.mBarView.findViewById(R.id.actionbar_progress);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionBar);
        String title = a.getString(0);
        if (title != null) {
            this.setTitle(title);
        }
        a.recycle();
    }

    public void setHomeAction(Action action) {
        this.mHomeBtn.setOnClickListener((View.OnClickListener)this);
        this.mHomeBtn.setTag((Object)action);
        this.mHomeBtn.setImageResource(action.getDrawable());
        this.mHomeLayout.setVisibility(0);
    }

    public void clearHomeAction() {
        this.mHomeLayout.setVisibility(8);
    }

    public void setHomeLogo(int resId) {
        this.mLogoView.setImageResource(resId);
        this.mLogoView.setVisibility(0);
        this.mHomeLayout.setVisibility(8);
    }

    public void setDisplayHomeAsUpEnabled(boolean show) {
        this.mBackIndicator.setVisibility(show ? 0 : 8);
    }

    public void setTitle(CharSequence title) {
        this.mTitleView.setText(title);
    }

    public void setTitle(int resid) {
        this.mTitleView.setText(resid);
    }

    public void setProgressBarVisibility(int visibility) {
        this.mProgress.setVisibility(visibility);
    }

    public int getProgressBarVisibility() {
        return this.mProgress.getVisibility();
    }

    public void setOnTitleClickListener(View.OnClickListener listener) {
        this.mTitleView.setOnClickListener(listener);
    }

    public void onClick(View view) {
        Object tag = view.getTag();
        if (tag instanceof Action) {
            Action action = (Action)tag;
            action.performAction(view);
        }
    }

    public void addActions(ActionList actionList) {
        int actions = actionList.size();
        int i = 0;
        while (i < actions) {
            this.addAction((Action)actionList.get(i));
            ++i;
        }
    }

    public void addAction(Action action) {
        int index = this.mActionsView.getChildCount();
        this.addAction(action, index);
    }

    public void addAction(Action action, int index) {
        this.mActionsView.addView(this.inflateAction(action), index);
    }

    public void removeAllActions() {
        this.mActionsView.removeAllViews();
    }

    public void removeActionAt(int index) {
        this.mActionsView.removeViewAt(index);
    }

    public void removeAction(Action action) {
        int childCount = this.mActionsView.getChildCount();
        int i = 0;
        while (i < childCount) {
            Object tag;
            View view = this.mActionsView.getChildAt(i);
            if (view != null && (tag = view.getTag()) instanceof Action && tag.equals(action)) {
                this.mActionsView.removeView(view);
            }
            ++i;
        }
    }

    public int getActionCount() {
        return this.mActionsView.getChildCount();
    }

    private View inflateAction(Action action) {
        View view = this.mInflater.inflate(R.layout.actionbar_item, (ViewGroup)this.mActionsView, false);
        ImageButton labelView = (ImageButton)view.findViewById(R.id.actionbar_item);
        labelView.setImageResource(action.getDrawable());
        view.setTag((Object)action);
        view.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public static abstract class AbstractAction
    implements Action {
        private final int mDrawable;

        public AbstractAction(int drawable) {
            this.mDrawable = drawable;
        }

        @Override
        public int getDrawable() {
            return this.mDrawable;
        }
    }

    public static interface Action {
        public int getDrawable();

        public void performAction(View var1);
    }

    public static class ActionList
    extends LinkedList<Action> {
    }

    public static class IntentAction
    extends AbstractAction {
        private Context mContext;
        private Intent mIntent;

        public IntentAction(Context context, Intent intent, int drawable) {
            super(drawable);
            this.mContext = context;
            this.mIntent = intent;
        }

        @Override
        public void performAction(View view) {
            try {
                this.mContext.startActivity(this.mIntent);
            }
            catch (ActivityNotFoundException e) {
                Toast.makeText((Context)this.mContext, (CharSequence)this.mContext.getText(R.string.actionbar_activity_not_found), (int)0).show();
            }
        }
    }
}

