package com.example.database;

import android.app.Activity;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.widget.SimpleCursorAdapter;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListView;

public class ListActivity extends Activity {

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.pokemon_list);
		fillList();
	}
	
	
	private void fillList() {
		PokedexData pd = new PokedexData(this);
		Cursor seen = pd.getAll();
		
		String[] dataFrom = new String[] {
			PokedexData.NAME,
			PokedexData.GENDER,
			PokedexData.TYPE,
			PokedexData.LOCATION,
			PokedexData.DESC,
		};
		
		int[] layoutTo = new int[] {
			R.id.name,
			R.id.gender,
			R.id.type,
			R.id.location,
			R.id.description,
		};
		
		SimpleCursorAdapter adapter = new SimpleCursorAdapter(
			this,
			R.layout.pokemon,
			seen,
			dataFrom,
			layoutTo,
			0);
		
		ListView list = (ListView) findViewById(R.id.list);
		list.setAdapter(adapter);
		
		list.setOnItemClickListener(new OnItemClickListener() {

			public void onItemClick(AdapterView<?> arg0, View arg1, int arg2,
					long arg3) {
				
				Toast.makeText(ListActivity.this, "hola", Toast.LENGTH_LONG).show();
				
			}
		});
			
	}
	
	
}
