package com.example.c21;

import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends Activity implements OnClickListener {

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        
        /*
         * obtener el boton de la interfaz
         * res/layout/activity_main.xml
         * 
         */
        Button b = (Button) findViewById(R.id.button1);
        
        /*
         * asignar un listener ("escuchador de eventos")
         * al boton, este listener es el mismo objeto de tipo MainActivity
         * 
         */
        b.setOnClickListener( this );
        
        
        Button b2 = (Button) findViewById(R.id.pequenoboton);        
        b2.setOnClickListener(this);
    }

    /*
     * metodo que se invoca al presionar el boton (fisico)
     * "opciones" del telefono, lo que hace es mostrar una lista
     * de opciones definidas en
     * res/menu/activity_main.xml
     * 
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }

    /*
     * el metodo onClick debe ser implementado por toda clase que
     * declare implementar la interfaz android.view.View.OnClickListener
     * 
     * cuando un boton que tenga asignado un OnClickListener sea clickeado
     * se llamara este metodo cuyo parametro sera el boton clickeado
     * 
     */
	@Override
	public void onClick(View v) {
		/*
		 * obtenemos el TextView de la interfaz que dice "Hello World"
		 * y lo cambiamos por otra cosa dependiendo del boton que haya 
		 * sido clickeado
		 * 
		 */
		TextView tv = (TextView) findViewById(R.id.textView1);
		
		/*
		 * segun el id del boton (dado en la propiedad 'android:id="@+id/button1"' 
		 * en res/layout/activity_main.xml donde este el boton), se ejecutara una u otra opcion
		 * dado que hay mas de un boton con un listener asignado
		 * 
		 */
		switch(v.getId()) {
		case R.id.button1:
			tv.setText("Bye bye wolrd pls");
			break;
		case R.id.pequenoboton:
			tv.setText("oh, hai :D");
			break;
		}
		
	}
}











