clear
global VD VQ Vf Rs LDQ Lmen1 muno ws Rf

%MQUINA SINCRNICA CON ENROLLADOS AMORTIGUADORES
%CALCULA LAS CORRIENTES DE CORTOCIRCUITO

%PARMETROS DE LA MQUINA
LD=1.236;
LQ=0.7948;
ws=1.0;
MAf=1.0;
MDf=MAf;

% Tiempo del segundo transitorio
aux_Tpd=100*pi;
TpD=1.038*aux_Tpd;
%TpD0=3.96;

R=0.009;
LpD=0.3387;
Lf=MDf^2/(LD-LpD);
Rf=(Lf-MDf*MDf/LD)/(TpD*(100*pi));
TpD0=Lf/Rf/(100*pi)
Tp0divTpD=TpD0/TpD;
XDdivXpD=LD/LpD;
Vf=Rf;
MAdd=1;
MAqq=1;
Mfdd=0.92305;

% Afectan la corriente peak de partida
% Variaciones hasta un 10%
aux_i_subtras=1.0;
Ldd=0.988637*aux_i_subtras;
Lqq=1.788173*aux_i_subtras;

% Afectan el tiempo del Subtrasitorio
aux_T_subtrans=1;
Rdd=0.141621/aux_T_subtrans;
Rqq=0.547814/aux_T_subtrans;
LDseg=+LD -1/Ldd-(1-Mfdd/Ldd)^2/(Lf-Mfdd^2/Ldd);
LQseg=LQ-MAqq^2/Lqq;

% Tiempo del subtransitorio (primer transitorio)
Td2prim=1/Rdd*(Ldd-(Mfdd^2*LD+Lf-2*Mfdd)/(LD*Lf-1))/(100*pi);
Tq2prim=1/Rqq*(Lqq-MAqq^2/LQ)/(100*pi);

Tfseg=1/Rdd*(Ldd-Mfdd*MAdd/MAf)/(100*pi);
K=2*(LD-LpD)/LpD*Tfseg/Td2prim;
TsD0=1/Rdd*(Ldd-Mfdd^2/Lf)/(100*pi);
TsD0divTd2prim=TsD0/Td2prim;
XpDdivXsegD=LpD/LDseg;

Rs=[R 0 0  0   0
    0 R 0  0   0
    0 0 Rf 0   0
    0 0 0 Rdd  0
    0 0 0  0  Rqq];

LDQ=[LD   0   MDf  MAdd   0 
     0   LQ    0    0    MAqq
     MDf  0    Lf  Mfdd   0
     MAdd 0   Mfdd Ldd    0
     0   MAqq  0    0    Lqq];

muno=[0 -1 0 0 0 
      1  0 0 0 0
      0  0 0 0 0
      0  0 0 0 0
      0  0 0 0 0];

Lmen1=inv(LDQ);
If0=Vf/Rf;

%RESUELVE LAS ECUACIONES DIFERENCIALES DEL CORTOCIRCUITO
VD=0;
VQ=0;
i0=[0
    0
    If0
    0
    0];
lam0=LDQ*i0;
t0=0;
%Tiempo de integracion - Duracion
taux=0.8*1 %Tiempo en segundos - modificar
tf=taux*100*pi*10*2;

[t,lam]=ode45('msin_am',t0,tf,lam0);
 
%CALCULA LAS CORRIENTES IABC EN FUNCIN DEL TIEMPO

% alfa_cero regula donde ocurre la falla
% alfa = t + alfa_cero
alfa = t + pi/2;

iDQf=Lmen1*lam';
tseg=t/(2*pi*50);
icero=zeros(length(t),1);
for m=1:length(t)
  Ttr=sqrt(2/3)*[cos(alfa(m)) cos(alfa(m)-2*pi/3) cos(alfa(m)+2*pi/3)
               -sin(alfa(m)) -sin(alfa(m)-2*pi/3) -sin(alfa(m)+2*pi/3)
               1/sqrt(2) 1/sqrt(2) 1/sqrt(2)];
  iDQ=[iDQf(1,m)'
       iDQf(2,m)'
       icero(m,1)];
  iabc(m,:)=sqrt(3/2)*(Ttr'*iDQ)';
end

%GRAFICA LOS RESULTADOS

figure(1);
subplot(221),plot(tseg,iabc(:,1)),grid,title('iA');
subplot(222),plot(tseg,iabc(:,2)),grid,title('iB');
subplot(223),plot(tseg,iabc(:,3)),grid,title('iC');
subplot(224),plot(tseg,iDQf(3,:)),grid,title('if');

figure(2);
set(gca,'FontSize',14,'FontName','Times');
plot( tseg(1:1000),iabc(1:1000,1),'b' ),grid,title('iA','fontsize',14,'Color','b');
figure(3);
plot( tseg(1:1000),iabc(1:1000,2),'r' ),grid,title('iB','fontsize',14,'Color','r');
figure(4);
plot( tseg(1:1000),iabc(1:1000,3),'g' ),grid,title('iC','fontsize',14,'Color','g');
figure(5);
plot( tseg(1:1000),iDQf(3,1:1000) ),grid,title('if','fontsize',14,'Color','b');

%CALCULA UNA EXPRESIN APROXIMADA DE IA IB
EQ=MDf*If0*ws;kr=1;EAmx=kr*EQ;
kprox1=kr*(1/LD+(1/LpD-1/LD)*exp(-tseg/(TpD)));
kprox2=kr*(1/LDseg-1/LpD)*exp(-tseg/Td2prim);
aprox1=kprox1.*cos(2*pi*50*tseg+alfa(1));
aprox1b=kprox2.*cos(2*pi*50*tseg+alfa(1));
bprox1=kprox1.*cos(2*pi*50*tseg+alfa(1)-2*pi/3);
bprox1b=kprox2.*cos(2*pi*50*tseg+alfa(1)-2*pi/3);
aregp=kr*1/LD;
Linv=1/2*(1/LDseg+1/LQseg);LsH=1/Linv

aten=Rs(1,1)/LsH*(100*pi);
aprox2=kr/LsH*exp(-aten*tseg)*cos(alfa(1));
bprox2=kr/LsH*exp(-aten*tseg)*cos(alfa(1)-2*pi/3);
aprox3=1/2*(1/LDseg-1/LQseg)*exp(-aten*tseg).*cos(4*pi*50*tseg+alfa(1));
bprox3=1/2*(1/LDseg-1/LQseg)*exp(-aten*tseg).*cos(4*pi*50*tseg+alfa(1)-2*pi/3);
iaprox=-(aprox1+aprox1b-aprox2-aprox3);
figure(6);
plot(tseg(1:1000),iaprox(1:1000),'b',tseg(1:1000),iabc(1:1000,1),'r'),title('Corriente ia Rojo Real - ia Azul Aproximacion','fontsize',14,'Color','b');

%pause

% ibprox=-(bprox1+bprox1b-bprox2-bprox3);
% % subplot(1,1,1)
% figure(2)
% plot(tseg,iaprox,tseg,iabc(:,1)),title('Corriente ia (Verde Real - Azul Aproximacion)'),pause
% 
% % subplot(1,1,1)
% figure(3)
% plot(tseg,ibprox,tseg,iabc(:,2)),title('Corriente ib (Verde Real - Azul Aproximacion)'),pause
% 
% if1=If0*(LD-LpD)/LpD*exp(-tseg/TpD);
% if2=If0*(LD-LpD)/LpD*(1-Tfseg/Td2prim)*exp(-tseg/Td2prim);
% if3=If0*(LD-LpD)/LpD*( Tfseg/Td2prim*exp(-aten*tseg).*cos(2*pi*50*tseg)
% );b
% ifprox=If0+if1-if2-if3;
% % subplot(1,1,1)
% figure(4)
% plot(tseg,ifprox,'b',tseg,iDQf(3,:),'r'),title('Corriente if (Verde Real - Azul Aproximacion)'),pause

% %REGIMEN PERMANENTE 
% V=[VD VQ Vf 0 0]';
% idqrp=inv(Rs+muno*LDQ)*V;
% iAmx=sqrt(2/3)*sqrt(idqrp(1)^2+idqrp(2)^2);
% ifield=idqrp(3);

