/**
* HSensorColor class for using the color sensor V2 made by Hitechnic.
* Official documentation on the named Color sensor available on:
*  http://www.hitechnic.com/cgi-bin/commerce.cgi?preadd=action&key=NCO1038
**/

/**
* You are allowed to modify, share and use this class however you want.
* Made by Gonzalo Infante.
*
* Version 1.0
* May 9th, 2012
**/

import lejos.nxt.*;

class HSensorColor extends lejos.nxt.ColorSensor{
	private I2CSensor sensor;
	private int high,low;
	public HSensorColor(SensorPort port){
		super(port);
		sensor = new I2CSensor(port);
		this.high = 0;
		this.low = -100;
	}
	public HSensorColor(SensorPort port,int color){
		super(port,color);
		sensor = new I2CSensor(port);
		this.high = 0;
		this.low = -100;
	}
	@Override
	public lejos.nxt.ColorSensor.Color getColor(){
		byte[] colors = query(0x42,4);
		int[] converted = convertColorLevels(colors[1],colors[2],colors[3]);
		return new lejos.nxt.ColorSensor.Color(
			converted[0],
			converted[1],
			converted[2],
			getLightLevel(converted[0],converted[1],converted[2]),
			(int)colors[0]
			);
	}
	@Override
	public int getColorID(){
		byte[] colorID = query(0x42,1);
		return (int)(colorID[0]);
	}
	@Override
	public int getFloodlight(){
		return lejos.robotics.Color.WHITE;
	}
	@Override
	public int getHigh(){
		return this.high;
	}
	@Override
	public int getLow(){
		return this.low;
	}
	@Override
	public int getRawLightValue(){
		byte[] colors = query(0x43,3);
		return getLightLevel(colors[0],colors[1],colors[2]);
	}
	@Override
	public int getNormalizedLightValue(){
		return (int)(255-getRawLightValue()*(-2.55));
	}
	@Override
	public int getLightValue(){
		return (getRawLightValue()-low)*255/(high-low);
	}
	@Override
	public lejos.nxt.ColorSensor.Color getRawColor(){
		byte[] colors = query(0x42,4);
		return new lejos.nxt.ColorSensor.Color(
				colors[1],
				colors[2],
				colors[3],
				getLightLevel(colors[1],colors[2],colors[3]),
				colors[0]
				);
	}
	@Override
	public void calibrateHigh(){
		this.high = this.getRawLightValue();
	}
	@Override
	public void calibrateLow(){
		this.low = this.getRawLightValue();
	}
	@Override
	public void setHigh(int high){
		this.high = high;
	}
	@Override
	public void setLow(int low){
		this.low = low;
	}
	
	//Private methods
	private int getLightLevel(int red, int green, int blue){
		return (int)((0.3*red+0.59*green+0.11*blue)/3);
	}
	private int[] convertColorLevels(byte red, byte green, byte blue){
		return new int[]{(int)(255-red*(-2.55)),
			(int)(255-green*(-2.55)),
			(int)(255-blue*(-2.55))};
	}
	private byte[] query(int memAddress, int length){
		byte[] data = new byte[length];
		sensor.getData(memAddress,data,length);
		return data;
	}	
}