package source;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipSearch {

    private static String fileName = "ZIP_CODES.gzip";

    static double lat = 0, lon = 0;
    static String city;
    static String county;

    public static void main(String[] args) {
        int zip = 56267;

        try {
            zipsearch(zip);
          // compress();
        } catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
        }

    }

    private static void compress(){
        try {
            // Create the GZIP output stream
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(fileName));
        
            // Open the input file
            File inFile = new File("src/SourceCode/ZIP_CODES.txt");
            if(!inFile.exists()){
                throw new RuntimeException(inFile.toString() + " not found!");
            }
            FileInputStream in = new FileInputStream(inFile);
        
            // Transfer bytes from the input file to the GZIP output stream
            byte[] buf = new byte[1024];
            int len;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
//                System.out.println("Writing 1k");
                
            }
            in.close();
        
            // Complete the GZIP file
            out.finish();
            out.close();
        } catch (IOException e) {
        }
    }
    
    static void zipsearch(int zipc) throws IOException {

        URL fl = ZipSearch.class.getResource(fileName);
        if (fl == null) {
            throw new RuntimeException("Zip code file not found!");
        }

        BufferedReader in = null;

        in = new BufferedReader(new InputStreamReader(new GZIPInputStream(fl.openStream())));

        String s;
        String desiredZip = "" + zipc;

        while ((s = in.readLine()) != null) {
            String zipString = s.substring(1, 6);

            //            System.out.println("Is <" + zipString + "> == <" + desiredZip + ">");
            if (desiredZip.equals(zipString)) {
                //                System.out.println("Found desired zip! " + s);
                s = s.replaceAll("\"", "");
                String[] lineData = s.split(",");

                lat = Double.parseDouble(lineData[1]);
                lon = Double.parseDouble(lineData[2]);
                city = lineData[3] + ", " + lineData[4];
                county = lineData[5];
                return;
            }
        }
        throw new RuntimeException("Invalid Zip Code, not found in file");
    }

}
