package source;



import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.WindowConstants;

/*
 * Created on May 18, 2005
 * Solar Radiation Estimator - SUNCALC 
 * 
 *  Predicts net radiation from only average temperature extremes
 *  and daily precipitation records.. 
 *  
 *  
 *  * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

/**
 * @author spokas
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SolarCalc {
	static double latitude;

	static double longitude;

	static double alt;
static int np=0;

	static double Rabs;

	static double La = 0;

	static double zangle = 0;

	static double Sd = 0;

	static double Sp = 0;

	static double Spo = 1360.0;

	static double St = 0;

	static double Sb = 0;

	static double Sr = 0;

	static// needed variables for cloud cover estimataion..
	int rain[] = new int[500];

	static int maxairtemp[] = new int[500];

	static int minairtemp[] = new int[500];
	static double data[] = new double[500];
	static// 
	int day;

	static double temp;

	static double time;

	static double halfdaylength;

	static double solarnoon = 0;

	static double solarD = 0;
	static String outputfile;
	
	static double standardmeridian;

	static int yearofcalc;

	static double LC;

	static double ET;

	static double albedo;

	static double taosave[] = new double[500];

	static double tao;

	static double Pa;

	static double m;

	static double sunrise = 0;

	static double sunset = 0;

	static double Fp = 0;

	static double Fd = 1;

	double Fa = 1;

	double Fe = 1;

	static int result;

	static double decday;
	

	static int deltaT[] = new int[500];

	static double airtemp = 20;

	static int dayofyear;
	static File file;
	static PrintStream pf = null;
    static Component c = null;
    

	public static void main(String[] args) throws NumberFormatException,
			IOException, InterruptedException {

		DecimalFormat pl3 = new DecimalFormat("0.000");
		DecimalFormat pl2 = new DecimalFormat("0.00");

		// set values:
		
		dayofyear = 1;
		
		// Display splash screen... 
					
		SplashScreen.show(null);
		
		// lat and long of field site --> need degrees 
		// longitute in degrees, longitudes west of Meridian are negative
		// latitute in degrees, latitudes south of equator are negative

		
		 JFrame frame = new JFrame();
	     frame.setTitle("Site Selection");
	     frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
	     JComponent panel = new LatLongGUI().buildPanel();
	     frame.getContentPane().add(panel);
	     frame.pack();
	    
		
		     
        // center dialog window on the screen:
        
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    	screenSize.height = screenSize.height/2;
    	screenSize.width = screenSize.width/2;
    	int y = screenSize.height - 150;
      	int x = screenSize.width - 60;
    	frame.setLocation(x, y);
        
        
    	 frame.setVisible(true);  
        
        
    	 while (LatLongGUI.Latlon==false)
        	{ 
        	// wait for dialog to be ready
        	Thread.sleep(10);
        	
        	}
       
    	 
    	 
        frame.hide();
        
        
        
        // gathe site information from GUI window... 
        
        latitude = Double.parseDouble(LatLongGUI._lat);
        longitude = Double.parseDouble(LatLongGUI._lon);
        yearofcalc = (int) Double.parseDouble(LatLongGUI._yr);
        alt = Double.parseDouble(LatLongGUI._elev);
       
        
		// soil albedo (Avg = 0.15 or so)

		albedo = 0.15;

		

		// Read weather data file (uses dialog box currently)



		int weatherData = JOptionPane.showConfirmDialog(null,
				"Load Site Weather Data?");

		if (weatherData == JOptionPane.YES_OPTION) {
			ReadWeatherFile();
		}


		
		// Prepare output file... User selected with double check to overwrite.
				
		int kf=1;
		    
		while (kf==1)
		
		{
		JFileChooser chooser = new JFileChooser(  );
		   
	    chooser.setDialogTitle("Select Model Output File");
	    
	    int result = chooser.showSaveDialog(c);
	    
		if (result == JFileChooser.CANCEL_OPTION) System.exit(0);
		
		file = chooser.getSelectedFile();
		
		if (file.exists())
		{
		// Check if overwrite file... 
			int n = JOptionPane.showConfirmDialog(null,
					"Do you wish to overwrite the file\n"+file.getAbsolutePath(),
				    "Output File Exists",
				    JOptionPane.YES_NO_OPTION);
		
			if (n == JOptionPane.NO_OPTION) { 
				// Not OK to overwrite. keep flag =1
				kf=1; }
			if (n == JOptionPane.YES_OPTION) { 
				// File OK to overwrite -- then set flag to 0
				kf=0; }
			
		}
		
		else {
			// if file does not exist then set flag to 0
			kf=0;}
				
		}
		
		
		// Open file for output -- nested in try block
		
		try {
	    
	        FileOutputStream f = null;
		    f = new FileOutputStream(file);
			// attach a PrintStream to it so we can print in text form
			pf = new PrintStream(f);
		
			// save text version of output file.
			
				outputfile =file.getAbsolutePath();
				
		
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		

		// convert lat and long to radian numbers:

		latitude = latitude * Math.PI / 180;
		longitude = longitude * Math.PI / 180;

		// check for leap year..set max days appropriately

		if (yearofcalc < 100) {
			// If the year is greater than 40 assume it
			// is from 1900's. If the year is less than
			// 40 assume it is from 2000's.

			if (yearofcalc > 40) {
				yearofcalc = yearofcalc + 1900;
			} else {
				yearofcalc = yearofcalc + 2000;
			}
		}

		// Determine if the year is a leap year:

		boolean isLeapYear;
		int maxdays;

		isLeapYear = (yearofcalc % 4 == 0)
				&& ((yearofcalc % 100 != 0) || (yearofcalc % 400) == 0);

		if (isLeapYear) {
			// leap year...
			maxdays = 366;
		} else { 
			// not a leap year
			maxdays = 365;
		}
		LivePlot.main(args);

		LivePlot.plot.stop();
		
		// set up dialog output box... 
		
		JFrame window = new JFrame();
		window = new ModelOutput();
           
        
      
        window.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
     
		
        window.setTitle("Model Output");
        
         
        window.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        
        // set default lat/lon settings.
                
        ModelOutput._day.setText("  ");
        ModelOutput._sunrise.setText("  ");
        ModelOutput._sunset.setText("  ");
        ModelOutput._solarnoon.setText("  ");
        
        window.resize(280,300);
        
        // center dialog window on the screen:
        
        
    	screenSize.height = screenSize.height/2;
    	screenSize.width = screenSize.width/2;
    	 y = screenSize.height + 350;
      	 x = screenSize.width - 60;
    	window.setLocation(x, y);
        
        
        window.show();  
      
		
		for (dayofyear = 1; dayofyear < maxdays + 1; dayofyear++) {

			// Step 1. Calculate corrections to solar noon value (See Campbell
			// and Norman (1998))

			// calculate LC correction to solar noon (hours)needs
			// longitude correction for location of field site.

			LC = getLC(longitude);

			// gets correction for ET

			ET = getET(dayofyear);

			// Calculate solar noon value:

			solarnoon = 12 - LC - ET;

			// Step 2. Calculate Solar Declination angle

			solarD = solarDeclination(dayofyear);

			// Step 3. Calculate Zenith Angle.

			zangle = Zenith(latitude, solarD, time, solarnoon);

			// Step 4. calcualte length of solar day (including twilight time)
			// formula from Campbell and Norman, 1998 [Eq. 11.6] {1/2 daylight }

			halfdaylength = CalcHalfDayLength(solarD, latitude);

			sunrise = solarnoon - halfdaylength;
			sunset = solarnoon + halfdaylength;


			// Estimating direct and diffuse short wave radiation for each hour:

			for (time = 0; time < 24; time++) {

				
				
				// convert day of year and time to excel format
				// of date string.
				// Uses routine written by
				// Geotechnical Software Services (C) 2004 - see day.java
				//
				// converts numeric date to string date format
				// --> mm/dd/yyy hh:00

				// time loop is in LOCAL STANDARD TIME...

				Day dts = new Day(yearofcalc, dayofyear);
				String dt = dts.toString();
				String date = dt + " " + (int) (time) + ":00";

				// approximatation of Sp
				// tou is atmospheric tramsmission :
				// overcast = 0.4 --> from Liu and Jordan (1960)
				// clear = 0.70 --> as given in Gates (1980)

				tao = 0.70;
				
				// if it is raining then assume it is overcast (cloud cover)

				if (rain[dayofyear] == 1) {
					tao = 0.40;
				}

				// if it has been raining for two days then
				// even darker (denser cloud cover)

				if (rain[dayofyear] == 1 && rain[dayofyear - 1] == 1) {
					tao = 0.30;
				}

				// assign pre-rain days to 80% of tao value ?

				if (rain[dayofyear] == 0 && rain[dayofyear - 1] == 1) {
					tao = 0.60;
				}

				// if airtemperature rise is less than 10 --> lower tao value
				// unless by poles
				if (Math.abs(latitude / Math.PI * 180)<60)
				{
				if (deltaT[dayofyear] <= 10 && deltaT[dayofyear] != 0) 
					{
					tao = tao / (11 - deltaT[dayofyear]);
				}
				}	
				
				airtemp = (maxairtemp[dayofyear] + minairtemp[dayofyear]) / 2;

				
				
				zangle = Zenith(latitude, solarD, time, solarnoon);

				Pa = 101 * Math.exp(-1 * alt / 8200);
				temp = zangle;
				m = Pa / 101.3 / Math.cos(temp);

				// Liu and Jordan (1960) Estimation of diffuse radiation
				// Sd is in Watts m^-2

				// calcuate Sp :

				Sp = Spo * Math.pow(tao, m);

				if (time < sunrise)
					Sp = 0;
				if (time > sunset)
					Sp = 0;
			
				
				
				// Diffuse sky irradiance on horizontal plane (Sd)
				// calc using tao, m , and zangle.
				// /formula given in Campbell and Norman (1998)

				Sd = 0.3 * (1.0 - Math.pow(tao, m)) * Math.cos(zangle);

				if (time < sunrise)
					Sd = 0;
				if (time > sunset)
					Sd = 0;

				Sd = Sd * Spo;

				// Beam irradiance on a horizontal surface

				Sb = Sp * Math.cos(zangle);

				// If the time is after sunset and before sunrise Sb = 0

				if (time < sunrise)
					Sb = 0;
				if (time > sunset)
					Sb = 0;

				// Calcualte total (beam and diffuse) irradiance on a horizontal
				// surface

				St = Sb + Sd;
				
				// check for never daylight northern latitudes... 
				
				if (St<0) {St=0;}
				
//			 check for NaN values, set to zero if NaN :
			
				if (St == Double.NaN){St = 0;}
			
				decday=dayofyear + (time/24);
				if (time == (int) solarnoon) np=1;
				LivePlot.plot.addPoints();
				
				// Calculation of reflected radiation
				
				Sr = (albedo) * St;

				// calucaltion of absorbed radiation (estimated)

				Fp = Math.cos(zangle);

				La = SB(airtemp);

				Rabs = (1 - albedo) * (Fp * Sp + Fd * Sd) + (0.05) * (La);

			
				
				// outputs calculated solar radiation (St) to data file...
				// along with delta T and tao -- used for debugging purposes
				// only..
				// need to delete and fix data file...
				
				ModelOutput._day.setText(dayofyear+"");
		        ModelOutput._sunrise.setText(pl2.format(sunrise)+"");
		        ModelOutput._sunset.setText(pl2.format (sunset)+"");
		        ModelOutput._solarnoon.setText(pl2.format(solarnoon)+"");
		        ModelOutput._daylength.setText(pl2.format(halfdaylength*2)+"");
		        
				
				pf.println(date + "," + pl2.format (St) + "," + pl2.format (deltaT[dayofyear]) + ","
						+ tao);

			}

		}

		
		// close output file.
		
		pf.close();
		
		
		LivePlot.plot.stop();
		
		// final dialog box -- finished and where data was saved.
		
		JOptionPane.showMessageDialog(null, 
    			"Model has completed.\nPlease see "+ outputfile +" for model output."
    			,"Modeling Complete", JOptionPane.INFORMATION_MESSAGE);
		
		// exit 
		
		System.exit(0);
		
	}

	/**
	 * Routine : getET calculates the ET (equation of time) correction typically
	 * a 15-20 minute correction depending on calendar day
	 * 
	 * inputs:
	 * 
	 * @param dayofyear2 --
	 *            day of year
	 * 
	 * @return calculated ET value
	 * 
	 * 
	 */
	private static double getET(int dayofyear2) {
		// TODO Auto-generated method stub

		double ETcalc, temp1;

		ETcalc = (279.575 + 0.9856 * dayofyear2) * Math.PI / 180;

		temp1 = -104.7 * Math.sin(ETcalc) + 596.2 * Math.sin(ETcalc * 2) + 4.3
				* Math.sin(3 * ETcalc) + -12.7 * Math.sin(4 * ETcalc) + -429.3
				* Math.cos(ETcalc) + -2.0 * Math.cos(2 * ETcalc) + 19.3
				* Math.cos(3 * ETcalc);

		ETcalc = temp1 / 3600;

		return ETcalc;

	}

	/**
	 * Routine : getLC calculates the longitudal correction
	 * 
	 * inputs:
	 * 
	 * @param double
	 *            longitude -- longitude of fieldsite negative value -- West of
	 *            meridian positive value -- East of meridian
	 * 
	 * @return calculated ET value
	 * 
	 * 
	 */
	private static double getLC(double long2) {

		// assumes longitude is in decimal format...
		// translates to 4 minutes for each degree

		return long2 / 360 * 24;
	}

	/**
	 * Routine : CalcHalfDayLength
	 * 
	 * 
	 * Calculation of 1/2 solar day length: Needs:
	 * 
	 * @param solarD2 --
	 *            Solar Decliantion
	 * @param latitude2 --
	 *            Latitude of site (field)
	 * 
	 * @return 1/2 day length
	 */

	private static double CalcHalfDayLength(double solarD2, double latitude2) {

		// Formula calculates 1/2 day length :

		// temp3 -- temporary calculation variable.

		double temp3;

		temp3 = Math.cos(90 * Math.PI / 180) - Math.sin(latitude2)
				* Math.sin(solarD2);

		temp3 = temp3 / (Math.cos(solarD2) * Math.cos(latitude2));

		temp3 = (Math.acos(temp3) * 180 / Math.PI) / 15;

		return temp3;
	}

	/**
	 * Reads CSV weather file. 
	 * Format is :
	 * day of year, min temp, max temp, precip amount
	 * eg.
	 * ...
	 * 12,-1.02,5.23,0.01
	 * 13,0.56,9.11,0.00
	 * 14,1.1,7.5,0.00
	 * ...
	 * 
	 * 
	 * @throws IOException
	 * @throws NumberFormatException
	 * 
	 */
	private static void ReadWeatherFile() throws NumberFormatException,
			IOException {
		// Step 1.
		// read in weather file.. max min air temp and rain information...
		// convert rain[day of year] = 1 if rain =0 if no rain.
		// maxairtemp[dayofyear] = max air temperature
		// minairtemp [day of year] = min temeprature

		// calucaltion of delat air T for an analog for clear sky ? need
		// reference

		Component c = null;
		JFileChooser chooser = new JFileChooser();
		chooser.setDialogTitle("Select Daily Weather File");
		result = chooser.showOpenDialog(c);

		if (result == JFileChooser.CANCEL_OPTION)
			System.exit(0);

		File file = chooser.getSelectedFile();

		// selected file == file

		StringBuffer sb = new StringBuffer();
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(file));
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		String s;
		int lpcnt = 0;

		while ((s = in.readLine()) != null) {
			// s is a line of text from the weather file.
			// change the string to lowercase
			int count = 0;
			s = s.toLowerCase();

			int initc = 0;

			lpcnt++;

			StringTokenizer st = new StringTokenizer(s, ",");

			// parse the CSV to individual values in data[]

			while (st.hasMoreElements()) {
				count++;
				data[count] = (Double.parseDouble(st.nextToken()));

			}

			day = (int) data[1];

			if (data[4] >1) {
				rain[day] = 1;
				// System.out.println("RAIN - " + data[1]);
			} else {
				rain[day] = 0;
			}
			minairtemp[day] = (int) data[2];
			maxairtemp[day] = (int) data[3];
			deltaT[day] = Math.abs(maxairtemp[day] - minairtemp[day]);

			// System.out.println(lpcnt + " - ==>" + rain[day] + " - Delta T: "
			// + deltaT[day]);

		}
		System.out.println("Completed weather read of data...");
	}

	/**
	 * Calcualion of Solar Declination Angle -- Needs:
	 * 
	 * @param dayofyear
	 *            (int)
	 * 
	 * @return Solardeclination angle
	 * 
	 */
	private static double solarDeclination(int dayofyear1) {
		// Calculate solar declination angle...
		// formula from Campbell and Norman, 1998 [Eq. 11.2]
		// corrected for day of year (Jan. 1 = 1, etc.)

		double temp2;

		temp2 = (278.97 + 0.9856 * dayofyear1 + 1.9165 * Math
				.sin((356.6 + 0.9856 * dayofyear1) * Math.PI / 180));

		temp2 = Math.sin(temp2 * Math.PI / 180);

		temp2 = Math.asin(0.39785 * temp2);

		return temp2;
	}

	/**
	 * Stefan-Boltzman law // returns black body radiation in units of Watts/m2
	 * emitted from // body.
	 * 
	 * @param airtemp
	 *            (or temperature of body)
	 * @return Emitted radiation (W/m2)
	 */
	private static double SB(double airtemp) {
		// Stefan-Boltzman law
		// returns black body radiation in units of Watts/m2 emitted from
		// body.

		double t;

		t = 5.67E-08 * Math.pow((airtemp + 273.16), 4);

		return t;

	}

	/**
	 * Calculates sun Zenith angle: 
	 * 
	 * Needs :
	 * @param latitude (lat)
	 * @param solarD (sD)
	 * @param time (te)
	 * @param solarnoon (sn)
	 * 
	 * @return Zenith angle at time te
	 * 
	 */
	private static double Zenith(double lat, double sD, double te, double sn) {
		// TODO Auto-generated method stub
		// zenith angle apporxiamtation...

		double temp, zang;

		temp = Math.sin(lat) * Math.sin(sD) + Math.cos(lat) * Math.cos(sD)
				* Math.cos(15 * (te - sn) * Math.PI / 180);
		zang = Math.acos(temp);

		// System.out.println("AzAngle :"+zangle*180/Math.PI);

		return zang;

	}

}
