(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24716,        552]
NotebookOptionsPosition[     24143,        530]
NotebookOutlinePosition[     24529,        546]
CellTagsIndexPosition[     24486,        543]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Gamma]", "[", 
   RowBox[{
   "\[Omega]_", ",", " ", "\[Mu]_", ",", " ", "\[Epsilon]_", ",", 
    "\[Sigma]_"}], "]"}], " ", ":=", " ", 
  SqrtBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "\[Mu]", 
    RowBox[{"(", 
     RowBox[{"\[Sigma]", "+", 
      RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "\[Epsilon]"}]}], " ", 
     ")"}]}]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Eta]", "[", 
   RowBox[{"\[Omega]_", ",", "\[Mu]_", ",", " ", "\[Gamma]_"}], "]"}], " ", ":=",
   " ", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "\[Mu]"}], 
   "\[Gamma]"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalGamma]", "[", 
   RowBox[{"\[Eta]1_", ",", " ", "\[Eta]2_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"\[Eta]2", "-", "\[Eta]1"}], 
   RowBox[{"\[Eta]2", "+", "\[Eta]1"}]]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T", "[", 
   RowBox[{"\[Eta]1_", ",", " ", "\[Eta]2_"}], "]"}], ":=", 
  FractionBox[
   RowBox[{"2", "\[Eta]2"}], 
   RowBox[{"\[Eta]2", "+", "\[Eta]1"}]]}]}], "Input",
 CellChangeTimes->{{3.4510691504223886`*^9, 3.4510693625103884`*^9}, {
   3.4510757140039997`*^9, 3.451075799225*^9}, {3.451076215726*^9, 
   3.451076218972*^9}, {3.451081543811*^9, 3.451081544191*^9}, {
   3.451081692385*^9, 3.4510816981429996`*^9}, {3.451406487515625*^9, 
   3.45140648765625*^9}, {3.451406660390625*^9, 3.451406667671875*^9}, 
   3.451406745140625*^9, 3.451406922125*^9, 3.451407450703125*^9, 
   3.451407793015625*^9, {3.451408020421875*^9, 3.45140802103125*^9}, {
   3.451410348484375*^9, 3.451410362171875*^9}, 3.451410970734375*^9, 
   3.45141109365625*^9, {3.451411273625*^9, 3.451411273796875*^9}, {
   3.451411430125*^9, 3.451411430671875*^9}, {3.45141182978125*^9, 
   3.45141183034375*^9}, {3.4514120014375*^9, 3.451412002328125*^9}, 
   3.451413528890625*^9, 3.451414039359375*^9, 3.45141478275*^9, 
   3.45141703303125*^9, 3.451417312796875*^9, {3.4849315997832484`*^9, 
   3.4849317336582484`*^9}, {3.4849317727519984`*^9, 3.4849317887207484`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Epsilon]1", "=", "1.0"}], ";", " ", 
  RowBox[{"\[Mu]1", "=", "1"}], ";", 
  RowBox[{"\[Sigma]1", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Mu]2", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Omega]", " ", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Emi", "=", "1"}], ";"}]}], "Input",
 CellChangeTimes->{{3.4849319402676234`*^9, 3.4849320004394984`*^9}, {
  3.4849324165332484`*^9, 3.4849324260019984`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Epos", "[", 
   RowBox[{
   "Em_", ",", "\[Gamma]_", ",", "\[Omega]_", ",", "z_", ",", " ", "t_"}], 
   "]"}], ":=", 
  RowBox[{"Re", "[", 
   RowBox[{"Em", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[Gamma]"}], " ", "z"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}]]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eneg", "[", 
   RowBox[{
   "Em_", ",", "\[Gamma]_", ",", "\[Omega]_", ",", "z_", ",", " ", "t_"}], 
   "]"}], ":=", 
  RowBox[{"Re", "[", 
   RowBox[{"Em", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[Gamma]", " ", "z"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "\[Omega]", " ", "t"}]]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.4849323165644984`*^9, 3.4849323624238734`*^9}, {
  3.4849325194707484`*^9, 3.4849325687051234`*^9}, {3.4849332986269984`*^9, 
  3.4849333142363734`*^9}, {3.4849334183301234`*^9, 3.4849334253457484`*^9}, {
  3.4849334903144984`*^9, 3.4849335012676234`*^9}, {3.4849358559863734`*^9, 
  3.4849358571113734`*^9}, {3.4849359115801234`*^9, 3.4849359176582484`*^9}, {
  3.4849359588926234`*^9, 3.4849359647988734`*^9}, {3.4849363039707484`*^9, 
  3.4849363146894984`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Ei", "[", 
    RowBox[{"z_", ",", " ", "t_"}], "]"}], ":=", " ", 
   RowBox[{"Epos", "[", 
    RowBox[{"Emi", ",", " ", 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{
      "\[Omega]", ",", " ", "\[Mu]1", ",", " ", "\[Epsilon]1", ",", 
       "\[Sigma]1"}], "]"}], ",", "\[Omega]", ",", "z", ",", "t"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Er", "[", 
    RowBox[{"\[Epsilon]2_", ",", "\[Sigma]2_", ",", "z_", ",", " ", "t_"}], 
    "]"}], ":=", " ", 
   RowBox[{"Eneg", "[", 
    RowBox[{
     RowBox[{"Emi", "\[Times]", 
      RowBox[{"\[CapitalGamma]", "[", 
       RowBox[{
        RowBox[{"\[Eta]", "[", 
         RowBox[{"\[Omega]", ",", "\[Epsilon]1", ",", 
          RowBox[{"\[Gamma]", "[", 
           RowBox[{
           "\[Omega]", ",", " ", "\[Mu]1", ",", " ", "\[Epsilon]1", ",", 
            "\[Sigma]1"}], "]"}]}], "]"}], ",", 
        RowBox[{"\[Eta]", "[", 
         RowBox[{"\[Omega]", ",", "\[Epsilon]2", ",", 
          RowBox[{"\[Gamma]", "[", 
           RowBox[{
           "\[Omega]", ",", " ", "\[Mu]2", ",", " ", "\[Epsilon]2", ",", 
            "\[Sigma]2"}], "]"}]}], "]"}]}], "]"}]}], ",", " ", 
     RowBox[{"\[Gamma]", "[", 
      RowBox[{
      "\[Omega]", ",", " ", "\[Mu]1", ",", " ", "\[Epsilon]1", ",", 
       "\[Sigma]1"}], "]"}], ",", "\[Omega]", ",", "z", ",", "t"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Et", "[", 
   RowBox[{"\[Epsilon]2_", ",", "\[Sigma]2_", ",", "z_", ",", " ", "t_"}], 
   "]"}], ":=", " ", 
  RowBox[{"Epos", "[", 
   RowBox[{
    RowBox[{"Emi", "\[Times]", 
     RowBox[{"T", "[", 
      RowBox[{
       RowBox[{"\[Eta]", "[", 
        RowBox[{"\[Omega]", ",", "\[Epsilon]1", ",", 
         RowBox[{"\[Gamma]", "[", 
          RowBox[{
          "\[Omega]", ",", " ", "\[Mu]1", ",", " ", "\[Epsilon]1", ",", 
           "\[Sigma]1"}], "]"}]}], "]"}], ",", 
       RowBox[{"\[Eta]", "[", 
        RowBox[{"\[Omega]", ",", "\[Epsilon]2", ",", 
         RowBox[{"\[Gamma]", "[", 
          RowBox[{
          "\[Omega]", ",", " ", "\[Mu]2", ",", " ", "\[Epsilon]2", ",", 
           "\[Sigma]2"}], "]"}]}], "]"}]}], "]"}]}], ",", " ", 
    RowBox[{"\[Gamma]", "[", 
     RowBox[{
     "\[Omega]", ",", " ", "\[Mu]2", ",", " ", "\[Epsilon]2", ",", 
      "\[Sigma]2"}], "]"}], ",", "\[Omega]", ",", "z", ",", "t"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.451075818*^9, 3.451075963948*^9}, {3.45107623931*^9, 
   3.451076243811*^9}, {3.451079652148*^9, 3.451079684907*^9}, {
   3.451079805321*^9, 3.4510798348529997`*^9}, {3.451079950954*^9, 
   3.4510799638380003`*^9}, {3.451081437326*^9, 3.451081485626*^9}, {
   3.4510815646070004`*^9, 3.451081586368*^9}, {3.451410276046875*^9, 
   3.4514103164375*^9}, 3.45141061553125*^9, {3.451411945015625*^9, 
   3.451411950234375*^9}, {3.4849317559394984`*^9, 3.4849317672519984`*^9}, {
   3.4849318048457484`*^9, 3.4849318102051234`*^9}, 3.4849318762519984`*^9, {
   3.4849320447207484`*^9, 3.4849320479238734`*^9}, {3.4849324098613734`*^9, 
   3.4849325055644984`*^9}, {3.4849325727988734`*^9, 
   3.4849325731738734`*^9}, {3.4849326035801234`*^9, 
   3.4849328294394984`*^9}, {3.4849328627207484`*^9, 
   3.4849328884394984`*^9}, {3.4849338983144984`*^9, 
   3.4849339022363734`*^9}, {3.4849361399707484`*^9, 3.4849361733926234`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"E1", "[", 
    RowBox[{"\[Epsilon]2_", ",", "\[Sigma]2_", ",", "z_", ",", " ", "t_"}], 
    "]"}], ":=", 
   RowBox[{
    RowBox[{"Ei", "[", 
     RowBox[{"t", ",", " ", "z"}], "]"}], "+", " ", 
    RowBox[{"Er", "[", 
     RowBox[{"\[Epsilon]2", ",", "\[Sigma]2", ",", "z", ",", " ", "t"}], 
     "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4510762475880003`*^9, 3.451076364592*^9}, {
   3.451076413517*^9, 3.451076418332*^9}, {3.451081498757*^9, 
   3.4510815165880003`*^9}, {3.4510816103719997`*^9, 3.45108164629*^9}, 
   3.451410690703125*^9, {3.45141209075*^9, 3.4514121118125*^9}, {
   3.4849329142988734`*^9, 3.4849329254238734`*^9}, {3.4849361451582484`*^9, 
   3.4849361473301234`*^9}, {3.4849361845801234`*^9, 3.4849361864863734`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"siz", "=", "350"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Animate", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Grid", "[", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Plot", "[", " ", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Ei", "[", 
               RowBox[{"z", ",", " ", "t"}], "]"}], ",", 
              RowBox[{"Er", "[", 
               RowBox[{
               "\[Epsilon]2", ",", "\[Sigma]2", ",", "z", ",", " ", "t"}], 
               "]"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"z", ",", " ", 
              RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", " ", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "10"}], ",", " ", 
                 RowBox[{"-", "0.01"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Dashed", ",", " ", "Thick"}], "}"}]}], ",", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \
\(i\)]\),\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(r\)]\)\>\"", ",", 
                 "\"\<\>\""}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"z", ",", "\"\<\>\""}], "}"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
            RowBox[{"Frame", "\[Rule]", "True"}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "siz"}]}], "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Plot", "[", " ", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Et", "[", 
              RowBox[{
              "\[Epsilon]2", ",", "\[Sigma]2", ",", "z", ",", " ", "t"}], 
              "]"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"z", ",", " ", "0", ",", "10"}], "}"}], ",", " ", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", " ", "10"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Dashed", ",", " ", "Thick"}], "}"}]}], ",", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(t\)]\)\>\"", 
                 ",", "\"\<\>\""}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"z", ",", "\"\<\>\""}], "}"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
            RowBox[{"Frame", "\[Rule]", "True"}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "siz"}]}], "\[IndentingNewLine]", 
           "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Plot", "[", " ", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"E1", "[", 
              RowBox[{
              "\[Epsilon]2", ",", "\[Sigma]2", ",", "z", ",", " ", "t"}], 
              "]"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"z", ",", " ", 
              RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", " ", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "10"}], ",", " ", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", " ", "Thick"}], "}"}]}], ",", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "\"\<\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \
\(i\)]\)+\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(r\)]\)\>\"", ",", 
                 "\"\<\>\""}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"z", ",", "\"\<\>\""}], "}"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
            RowBox[{"Frame", "\[Rule]", "True"}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "siz"}]}], "\[IndentingNewLine]", 
           "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{"Plot", "[", " ", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Abs", "[", 
              RowBox[{"E1", "[", 
               RowBox[{
               "\[Epsilon]2", ",", "\[Sigma]2", ",", "z", ",", " ", "t"}], 
               "]"}], "]"}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{"z", ",", " ", 
              RowBox[{"-", "10"}], ",", "0"}], "}"}], ",", " ", 
            RowBox[{"PlotRange", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "10"}], ",", " ", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Red", ",", " ", "Thick"}], "}"}]}], ",", 
            RowBox[{"FrameLabel", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "\"\<|\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(i\)]\)+\!\(\
\*SubscriptBox[\(\[ScriptCapitalE]\), \(r\)]\)|\>\"", ",", "\"\<\>\""}], 
                "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{"z", ",", "\"\<\>\""}], "}"}]}], "}"}]}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", "Large", "]"}]}], ",", 
            RowBox[{"Frame", "\[Rule]", "True"}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "siz"}]}], "]"}]}], "}"}]}], 
       "}"}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", " ", 
     RowBox[{"{", 
      RowBox[{"t", ",", " ", "0", ",", " ", "100"}], "}"}], ",", 
     RowBox[{"AnimationRate", "\[Rule]", "5"}]}], "\[IndentingNewLine]", 
    "]"}], ",", "\[IndentingNewLine]", " ", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]2", ",", " ", "1", ",", " ", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Sigma]2", ",", " ", "0", ",", " ", "100"}], "}"}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellChangeTimes->{{3.4510816484969997`*^9, 3.451081675625*^9}, {
   3.4510817141029997`*^9, 3.4510817295*^9}, {3.451081810199*^9, 
   3.451081909807*^9}, {3.451081948131*^9, 3.4510819499639997`*^9}, {
   3.451082084575*^9, 3.4510820861879997`*^9}, {3.451084807592*^9, 
   3.451084877227*^9}, {3.451084912369*^9, 3.451084913455*^9}, {
   3.451085048696*^9, 3.451085083233*^9}, {3.451085125762*^9, 
   3.4510852659119997`*^9}, {3.451085351769*^9, 3.45108538951*^9}, {
   3.451089581691*^9, 3.451089678375*^9}, {3.4514042406875*^9, 
   3.4514042571875*^9}, {3.45141105740625*^9, 3.451411083859375*^9}, {
   3.451411169140625*^9, 3.45141117140625*^9}, {3.451411864203125*^9, 
   3.451411907453125*^9}, {3.4514122515*^9, 3.451412253671875*^9}, 
   3.451412286015625*^9, 3.45141234584375*^9, {3.4514127160625*^9, 
   3.451412717296875*^9}, {3.451412827953125*^9, 3.451412963640625*^9}, {
   3.451413108890625*^9, 3.45141312496875*^9}, {3.45141323665625*^9, 
   3.45141325690625*^9}, 3.451413302171875*^9, {3.451413475015625*^9, 
   3.451413479859375*^9}, 3.45141485615625*^9, {3.451417354671875*^9, 
   3.451417355125*^9}, {3.4514173921875*^9, 3.451417392359375*^9}, {
   3.4849330094707484`*^9, 3.4849331426269984`*^9}, {3.4849333563144984`*^9, 
   3.4849333663457484`*^9}, {3.4849334833926234`*^9, 
   3.4849334861269984`*^9}, {3.4849335202676234`*^9, 
   3.4849335382207484`*^9}, {3.4849335805019984`*^9, 
   3.4849335821269984`*^9}, {3.4849337121113734`*^9, 3.4849337267519984`*^9}, 
   3.4849338082676234`*^9, {3.4849339288926234`*^9, 3.4849339369238734`*^9}, {
   3.4849340054863734`*^9, 3.4849340286894984`*^9}, {3.4849341300176234`*^9, 
   3.4849341524082484`*^9}, {3.4849341971269984`*^9, 
   3.4849341980488734`*^9}, {3.4849342516894984`*^9, 
   3.4849344005801234`*^9}, {3.4849344497676234`*^9, 
   3.4849344532363734`*^9}, {3.4849345051582484`*^9, 
   3.4849345308457484`*^9}, {3.4849346256582484`*^9, 
   3.4849346290176234`*^9}, {3.4849346877051234`*^9, 
   3.4849346895801234`*^9}, {3.4849347708769984`*^9, 3.4849347721269984`*^9}, 
   {3.4849348025488734`*^9, 3.4849348601269984`*^9}, {3.4849350849707484`*^9, 
   3.4849351228613734`*^9}, {3.4849351752363734`*^9, 
   3.4849351836426234`*^9}, {3.4849352321113734`*^9, 
   3.4849352440332484`*^9}, {3.4849352870644984`*^9, 
   3.4849353032519984`*^9}, {3.4849353748613734`*^9, 
   3.4849353822676234`*^9}, {3.4849354153144984`*^9, 
   3.4849354388613734`*^9}, {3.4849355012988734`*^9, 
   3.4849355465644984`*^9}, {3.4849355925801234`*^9, 
   3.4849356025176234`*^9}, {3.4849356339082484`*^9, 3.4849356414707484`*^9}, 
   3.4849357023926234`*^9, {3.4849362817363734`*^9, 3.4849363011738734`*^9}, {
   3.4849363624551234`*^9, 3.4849363625801234`*^9}, {3.4849364675176234`*^9, 
   3.4849364990957484`*^9}, {3.4849365366426234`*^9, 
   3.4849365961113734`*^9}, {3.4849406290801234`*^9, 
   3.4849406294394984`*^9}, {3.484952285384*^9, 3.4849522923719997`*^9}, {
   3.4849523696940002`*^9, 3.484952375711*^9}, {3.4849524075290003`*^9, 
   3.4849524077460003`*^9}, {3.484952443073*^9, 3.4849524472060003`*^9}, 
   3.484952486755*^9, {3.484952534527*^9, 3.484952575682*^9}, {
   3.484952666719*^9, 3.484952709083*^9}, {3.484952808446*^9, 
   3.4849528097860003`*^9}, {3.484952847958*^9, 3.484952875653*^9}, {
   3.484952911526*^9, 3.484952912832*^9}, {3.484953415895*^9, 
   3.484953417439*^9}, 3.484953738939*^9, {3.484953846573*^9, 
   3.484953878434*^9}, {3.484954006071*^9, 3.484954037686*^9}, {
   3.484954133955*^9, 3.48495413816*^9}, {3.48495468024*^9, 
   3.4849547454709997`*^9}, {3.484956386159*^9, 3.484956398124*^9}, {
   3.4960107401172*^9, 3.4960107484902*^9}, {3.4960107816322002`*^9, 
   3.4960108143431997`*^9}, {3.4960109635861998`*^9, 3.4960109848622*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Epsilon]2$$ = 
    10., $CellContext`\[Sigma]2$$ = 100., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Epsilon]2$$], 1, 10}, {
      Hold[$CellContext`\[Sigma]2$$], 0, 100}}, Typeset`size$$ = {
    757., {291., 296.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Epsilon]2$24858$$ = 
    0, $CellContext`\[Sigma]2$24859$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`\[Epsilon]2$$ = 
        1, $CellContext`\[Sigma]2$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`\[Epsilon]2$$, $CellContext`\[Epsilon]2$24858$$, 0], 
        Hold[$CellContext`\[Sigma]2$$, $CellContext`\[Sigma]2$24859$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Animate[
        Grid[{{
           Plot[{
             $CellContext`Ei[$CellContext`z, $CellContext`t], 
             $CellContext`Er[$CellContext`\[Epsilon]2$$, \
$CellContext`\[Sigma]2$$, $CellContext`z, $CellContext`t]}, {$CellContext`z, \
-10, 0}, PlotRange -> {{-10, -0.01}, {-2, 2}}, PlotStyle -> {Dashed, Thick}, 
            FrameLabel -> {{
              "\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \
\(i\)]\),\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(r\)]\)", 
               ""}, {$CellContext`z, ""}}, LabelStyle -> Directive[Large], 
            Frame -> True, ImageSize -> $CellContext`siz], 
           Plot[{
             $CellContext`Et[$CellContext`\[Epsilon]2$$, \
$CellContext`\[Sigma]2$$, $CellContext`z, $CellContext`t]}, {$CellContext`z, 
             0, 10}, PlotRange -> {{0, 10}, {-2, 2}}, 
            PlotStyle -> {Dashed, Thick}, 
            FrameLabel -> {{
              "\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(t\)]\)", 
               ""}, {$CellContext`z, ""}}, LabelStyle -> Directive[Large], 
            Frame -> True, ImageSize -> $CellContext`siz]}, {
           Plot[{
             $CellContext`E1[$CellContext`\[Epsilon]2$$, \
$CellContext`\[Sigma]2$$, $CellContext`z, $CellContext`t]}, {$CellContext`z, \
-10, 0}, PlotRange -> {{-10, 0}, {-2, 2}}, PlotStyle -> {Red, Thick}, 
            FrameLabel -> {{
              "\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \
\(i\)]\)+\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(r\)]\)", 
               ""}, {$CellContext`z, ""}}, LabelStyle -> Directive[Large], 
            Frame -> True, ImageSize -> $CellContext`siz], 
           Plot[{
             Abs[
              $CellContext`E1[$CellContext`\[Epsilon]2$$, $CellContext`\
\[Sigma]2$$, $CellContext`z, $CellContext`t]]}, {$CellContext`z, -10, 0}, 
            PlotRange -> {{-10, 0}, {-2, 2}}, PlotStyle -> {Red, Thick}, 
            FrameLabel -> {{
              "|\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \
\(i\)]\)+\!\(\*SubscriptBox[\(\[ScriptCapitalE]\), \(r\)]\)|", 
               ""}, {$CellContext`z, ""}}, LabelStyle -> Directive[Large], 
            Frame -> True, ImageSize -> $CellContext`siz]}}], {$CellContext`t,
          0, 100}, AnimationRate -> 5], 
      "Specifications" :> {{$CellContext`\[Epsilon]2$$, 1, 
         10}, {$CellContext`\[Sigma]2$$, 0, 100}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{806., {351., 356.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.4960107670182*^9, 3.4960108421582003`*^9}, {
   3.4960109854952*^9, 3.4960109911442003`*^9}, {3.4960113746212*^9, 
   3.4960113820612*^9}, {3.4960114421032*^9, 3.4960114454332*^9}, 
   3.496055028828125*^9, 3.4960555619375*^9, 3.5139882733310003`*^9, 
   3.513988357954*^9, 3.526746243515625*^9, 3.5320428044126315`*^9}]
}, Open  ]]
},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{1230, 887},
WindowMargins->{{Automatic, 81}, {Automatic, 54}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2059, 44, 150, "Input"],
Cell[2607, 66, 511, 12, 92, "Input"],
Cell[3121, 80, 1311, 32, 65, "Input"],
Cell[4435, 114, 3398, 78, 112, "Input"],
Cell[7836, 194, 798, 17, 31, "Input"],
Cell[CellGroupData[{
Cell[8659, 215, 11126, 229, 492, "Input"],
Cell[19788, 446, 4339, 81, 724, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
