(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22116,        494]
NotebookOptionsPosition[     21596,        472]
NotebookOutlinePosition[     21940,        487]
CellTagsIndexPosition[     21897,        484]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"dir", " ", "=", " ", 
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.4497596237832336`*^9, 3.449759643597234*^9}, {
  3.4504369377487764`*^9, 3.4504369412437763`*^9}}],

Cell[BoxData["\<\"C:\\\\Users\\\\Patricio\\\\Data\\\\U.Chile\\\\Cursos\\\\EM_\
Aplicado\\\\2011b\\\\Lecture 16_Ondas\"\>"], "Output",
 CellChangeTimes->{3.4497596450122337`*^9, 3.4497925911219997`*^9, 
  3.44984593856*^9, 3.450135831705*^9, 3.4504353197247763`*^9, 
  3.4504369425297766`*^9, 3.4504616941689997`*^9, 3.450479419547*^9, 
  3.484420696875*^9, 3.4844325901580076`*^9, 3.484479384049568*^9, 
  3.484518366335*^9, 3.4958332822980003`*^9, 3.532038707912325*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"disk", " ", "=", " ", "dir"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", " ", 
   RowBox[{
    RowBox[{"i", "=", "1"}], ",", " ", 
    RowBox[{"i", "\[LessEqual]", "5"}], ",", " ", 
    RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"disk", " ", "=", " ", 
      RowBox[{"ParentDirectory", "[", " ", "disk", "]"}]}], ";"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Get", "[", 
  RowBox[{"disk", "<>", "\"\<\\\\Mathematica\\\\Flecha3d.txt\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.446479814578125*^9, 3.44647982159375*^9}, {
   3.44647998596875*^9, 3.446480102203125*^9}, {3.44978678169*^9, 
   3.449786782882*^9}, {3.4504369119347763`*^9, 3.4504369133577766`*^9}, {
   3.450436950693776*^9, 3.450436950865776*^9}, 3.484420701046875*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Omega]", " ", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", " ", "=", " ", "2"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"u", " ", "=", " ", 
    FractionBox["\[Omega]", "\[Beta]"]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Lambda]", "=", 
   FractionBox[
    RowBox[{"2", " ", "\[Pi]"}], "\[Beta]"]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gf", "=", "0.04"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ex", "[", 
   RowBox[{"Em1_", ",", "t_", ",", " ", "z_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Em1", " ", 
   RowBox[{"Cos", "[", " ", 
    RowBox[{
     RowBox[{"\[Omega]", " ", "t"}], " ", "-", " ", 
     RowBox[{"\[Beta]", " ", "z"}]}], "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Ey", "[", 
   RowBox[{"Em2_", ",", "\[Theta]_", ",", "t_", ",", " ", "z_"}], "]"}], " ", 
  ":=", " ", 
  RowBox[{"Em2", " ", 
   RowBox[{"Cos", "[", " ", 
    RowBox[{
     RowBox[{"\[Omega]", " ", "t"}], " ", "-", " ", 
     RowBox[{"\[Beta]", " ", "z"}], " ", "+", " ", "\[Theta]"}], 
    "]"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Etot", "[", 
   RowBox[{"Em1_", ",", "Em2_", ",", "\[Theta]_", ",", "t_", ",", " ", "z_"}],
    "]"}], " ", ":=", 
  RowBox[{"flecha3d", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"z", ",", " ", "0", ",", " ", "0"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"z", ",", " ", 
        RowBox[{"Ex", "[", 
         RowBox[{"Em1", ",", "t", ",", " ", "z"}], "]"}], ",", " ", 
        RowBox[{"Ey", "[", 
         RowBox[{"Em2", ",", "\[Theta]", ",", "t", ",", " ", "z"}], "]"}]}], 
       " ", "}"}]}], "}"}], ",", " ", 
    RowBox[{"grosor", "\[Rule]", "gf"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Etot0", "[", 
   RowBox[{"Em1_", ",", "Em2_", ",", "\[Theta]_", ",", "t_"}], "]"}], " ", ":=",
   " ", 
  RowBox[{"Etot", "[", 
   RowBox[{"Em1", ",", "Em2", ",", "\[Theta]", ",", "t", ",", " ", "0"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Etotu", "[", 
   RowBox[{"Em1_", ",", "Em2_", ",", "\[Theta]_", ",", "t_"}], "]"}], " ", ":=",
   " ", 
  RowBox[{"Etot", "[", 
   RowBox[{"Em1", ",", "Em2", ",", "\[Theta]", ",", "t", ",", " ", 
    RowBox[{"u", " ", "t"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Etotxy", "[", 
    RowBox[{"Em1_", ",", "Em2_", ",", "\[Theta]_", ",", "t_"}], "]"}], " ", ":=", 
   RowBox[{"Arrow", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Ex", "[", 
         RowBox[{"Em1", ",", "t", ",", "0"}], "]"}], ",", " ", 
        RowBox[{"Ey", "[", 
         RowBox[{"Em2", ",", "\[Theta]", ",", "t", ",", "0"}], "]"}]}], " ", 
       "}"}]}], "}"}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"zmax", " ", "=", " ", 
    RowBox[{"2", " ", "\[Lambda]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LGEz", "[", 
   RowBox[{"Em1_", ",", "Em2_", ",", "\[Theta]_", ",", "t_"}], "]"}], " ", ":=",
   " ", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"Ex", "[", 
       RowBox[{"Em1", ",", "t", ",", " ", "z"}], "]"}], ",", 
      RowBox[{"Ey", "[", 
       RowBox[{"Em2", ",", "\[Theta]", ",", "t", ",", " ", "z"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "zmax"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LGE0", "[", 
   RowBox[{"Em1_", ",", "Em2_", ",", "\[Theta]_", ",", "t_"}], "]"}], " ", ":=",
   " ", 
  RowBox[{"ParametricPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Ex", "[", 
       RowBox[{"Em1", ",", "t1", ",", " ", "0"}], "]"}], ",", 
      RowBox[{"Ey", "[", 
       RowBox[{"Em2", ",", "\[Theta]", ",", "t1", ",", " ", "0"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t1", ",", "0", ",", "t"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Dashed", ",", "Thick"}], "}"}]}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LGE02d", "[", 
   RowBox[{"Em1_", ",", "Em2_", ",", "\[Theta]_", ",", "t_"}], "]"}], " ", ":=",
   " ", 
  RowBox[{"ParametricPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Ex", "[", 
       RowBox[{"Em1", ",", "t1", ",", " ", "0"}], "]"}], ",", 
      RowBox[{"Ey", "[", 
       RowBox[{"Em2", ",", "\[Theta]", ",", "t1", ",", " ", "0"}], "]"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t1", ",", "0", ",", "t"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Dashed", ",", "Thick"}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.4474533222671976`*^9, 3.4474534006471977`*^9}, {
   3.447453438350198*^9, 3.447453506776198*^9}, {3.4474536500091977`*^9, 
   3.447453656521198*^9}, {3.449012481675*^9, 3.449012511722*^9}, {
   3.4504622264449997`*^9, 3.45046223808*^9}, {3.450462464573*^9, 
   3.450462481065*^9}, {3.45046255863*^9, 3.4504625930299997`*^9}, {
   3.4504628062320004`*^9, 3.450462856508*^9}, {3.450467151976*^9, 
   3.450467152132*^9}, 3.4504779871470003`*^9, 3.450478131593*^9, {
   3.450479400138*^9, 3.450479412685*^9}, 3.484421289359375*^9, {
   3.48442134096875*^9, 3.484421469515625*^9}, {3.4844326500490074`*^9, 
   3.4844326694350076`*^9}, {3.4844327871450076`*^9, 
   3.4844327925370073`*^9}, {3.4844331552710075`*^9, 
   3.4844331601520076`*^9}, {3.484433299227008*^9, 3.4844333103060074`*^9}, {
   3.484433526352008*^9, 3.4844335537770076`*^9}, {3.4844337923060074`*^9, 
   3.484433800656008*^9}, {3.4844338950910077`*^9, 3.4844338974540076`*^9}, {
   3.4844340915940075`*^9, 3.484434096392008*^9}, {3.4844341305470076`*^9, 
   3.4844341307890077`*^9}, {3.4844348415090075`*^9, 
   3.4844348704540076`*^9}, {3.4844354366340075`*^9, 
   3.4844354951310077`*^9}, {3.4844356097370076`*^9, 
   3.4844356138470078`*^9}, {3.4844357125130076`*^9, 
   3.4844357294590073`*^9}, {3.484435770022008*^9, 3.4844358955020075`*^9}, 
   3.4844372940000076`*^9, {3.4844376317660074`*^9, 3.4844376343620076`*^9}, {
   3.484437919583008*^9, 3.4844379204790077`*^9}, 3.4844380340300074`*^9, {
   3.4844380733280077`*^9, 3.4844381339950075`*^9}, {3.4844382669790077`*^9, 
   3.4844383165630074`*^9}, 3.4844383635090075`*^9, 3.4844396674880075`*^9, {
   3.484439944833008*^9, 3.4844399523010073`*^9}, {3.484439986774008*^9, 
   3.4844400178200073`*^9}, {3.4844401891880074`*^9, 3.484440212208008*^9}, 
   3.484440404272008*^9, 3.484479397185568*^9, {3.484479638770568*^9, 
   3.4844796552935677`*^9}, 3.484479719348568*^9, {3.4844807068455677`*^9, 
   3.484480715296568*^9}, {3.484480751241568*^9, 3.484480767235568*^9}, {
   3.484481432041568*^9, 3.484481462380568*^9}, {3.4844815016725683`*^9, 
   3.484481504636568*^9}, {3.484521099078*^9, 3.4845211256879997`*^9}, {
   3.48452141949*^9, 3.48452142417*^9}, {3.4845220133719997`*^9, 
   3.484522092499*^9}, {3.484522401862*^9, 3.484522404852*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Animate", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"GraphicsRow", "[", "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Show", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Graphics3D", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Etotu", "[", 
                RowBox[{"Em1", ",", "Em2", ",", 
                 RowBox[{"\[Theta]", " ", "\[Degree]"}], ",", "t"}], "]"}], 
               ",", 
               RowBox[{"Etot0", "[", 
                RowBox[{"Em1", ",", "Em2", ",", 
                 RowBox[{"\[Theta]", " ", "\[Degree]"}], ",", "t"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0", ",", "zmax"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"LGEz", "[", 
            RowBox[{"Em1", ",", "Em2", ",", 
             RowBox[{"\[Theta]", " ", "\[Degree]"}], ",", "t"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"LGE0", "[", 
            RowBox[{"Em1", ",", "Em2", ",", 
             RowBox[{"\[Theta]", " ", "\[Degree]"}], ",", "t"}], "]"}]}], 
          "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Show", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"LGE02d", "[", 
            RowBox[{"Em1", ",", "Em2", ",", 
             RowBox[{"\[Theta]", " ", "\[Degree]"}], ",", "t"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", " ", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Thick", ",", 
               RowBox[{"Arrowheads", "[", "Large", "]"}], ",", 
               RowBox[{"Etotxy", "[", 
                RowBox[{"Em1", ",", "Em2", ",", 
                 RowBox[{"\[Theta]", " ", "\[Degree]"}], ",", "t"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"PlotRange", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1"}], ",", "1.1"}], "}"}]}], "}"}]}]}], 
            "]"}]}], "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", 
        "}"}], "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", 
         FractionBox["zmax", "u"]}]}], "}"}], ",", " ", 
      RowBox[{"AnimationRate", "\[Rule]", 
       FractionBox["1", 
        RowBox[{"10", " ", "\[Omega]"}]]}]}], "\[IndentingNewLine]", "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Em1", ",", "1"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Em2", ",", "1"}], "}"}], ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0"}], "}"}], ",", 
      RowBox[{"-", "90"}], ",", "90"}], "}"}]}], "\[IndentingNewLine]", "]"}],
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.4844349018300076`*^9, 3.4844349604570074`*^9}, {
   3.4844351945130076`*^9, 3.4844352250930076`*^9}, {3.484435550668008*^9, 
   3.484435619043008*^9}, {3.484435901680008*^9, 3.4844360686970077`*^9}, {
   3.4844361538900075`*^9, 3.484436223062008*^9}, {3.4844362698480077`*^9, 
   3.484436306305008*^9}, {3.4844364343170075`*^9, 3.4844364825070076`*^9}, {
   3.4844365230580077`*^9, 3.4844365307280073`*^9}, {3.4844366679170074`*^9, 
   3.4844366712550077`*^9}, {3.4844368699990077`*^9, 
   3.4844368939100075`*^9}, {3.4844371195910077`*^9, 3.484437137859008*^9}, 
   3.4844371943370075`*^9, {3.4844372557300076`*^9, 3.4844372561810074`*^9}, {
   3.4844373137850075`*^9, 3.4844373191600075`*^9}, 3.4844373533600073`*^9, {
   3.4844373934310074`*^9, 3.4844373953220077`*^9}, {3.4844375490970078`*^9, 
   3.484437576456008*^9}, {3.4844377729030075`*^9, 3.484437793720008*^9}, {
   3.4844378350390077`*^9, 3.4844378462630076`*^9}, {3.4844378763410077`*^9, 
   3.4844378797120075`*^9}, 3.484437988588008*^9, 3.484438154399008*^9, 
   3.4844388963700075`*^9, {3.4844401336120076`*^9, 3.4844401498570075`*^9}, 
   3.4844402639490075`*^9, {3.4844403160630074`*^9, 3.4844403414360075`*^9}, {
   3.484440491583008*^9, 3.4844405586860075`*^9}, 3.484479438499568*^9, {
   3.484479499769568*^9, 3.484479590392568*^9}, {3.4844803902385683`*^9, 
   3.484480399524568*^9}, 3.484480785737568*^9, 3.4844812357935677`*^9, {
   3.484481278508568*^9, 3.484481283327568*^9}, 3.4844813571395683`*^9, 
   3.4845188628780003`*^9, {3.4845196007799997`*^9, 3.48451960841*^9}, {
   3.484519740781*^9, 3.484519766183*^9}, {3.4845198016280003`*^9, 
   3.4845198090179996`*^9}, {3.484519867877*^9, 3.484519905657*^9}, {
   3.4845200983380003`*^9, 3.4845201339189997`*^9}, {3.484520476601*^9, 
   3.4845204785620003`*^9}, 3.484520806552*^9, {3.484520861278*^9, 
   3.484520928572*^9}, {3.4845209595959997`*^9, 3.484520992755*^9}, {
   3.4845211744700003`*^9, 3.484521205428*^9}, {3.484521810972*^9, 
   3.4845219805559998`*^9}, {3.484522074258*^9, 3.484522076453*^9}, {
   3.484522107691*^9, 3.4845221078199997`*^9}, {3.4845221932980003`*^9, 
   3.484522196111*^9}, {3.484522506792*^9, 3.484522587396*^9}, {
   3.484522658153*^9, 3.484522712505*^9}, 3.484522808427*^9, {
   3.4845229105699997`*^9, 3.48452294546*^9}, {3.484522993399*^9, 
   3.4845230101879997`*^9}, {3.532039955515684*^9, 3.5320399660312853`*^9}, 
   3.5320400316660395`*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`Em1$$ = 1, $CellContext`Em2$$ = 
    1, $CellContext`\[Theta]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`Em1$$], 1}, 0, 1}, {{
       Hold[$CellContext`Em2$$], 1}, 0, 1}, {{
       Hold[$CellContext`\[Theta]$$], 0}, -90, 90}}, Typeset`size$$ = {
    409., {130., 135.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`Em1$15562$$ = 
    0, $CellContext`Em2$15563$$ = 0, $CellContext`\[Theta]$15564$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`Em1$$ = 1, $CellContext`Em2$$ = 
        1, $CellContext`\[Theta]$$ = 0}, "ControllerVariables" :> {
        Hold[$CellContext`Em1$$, $CellContext`Em1$15562$$, 0], 
        Hold[$CellContext`Em2$$, $CellContext`Em2$15563$$, 0], 
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$15564$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Animate[
        GraphicsRow[{
          Show[
           Graphics3D[{
             $CellContext`Etotu[$CellContext`Em1$$, $CellContext`Em2$$, \
$CellContext`\[Theta]$$ Degree, $CellContext`t], 
             $CellContext`Etot0[$CellContext`Em1$$, $CellContext`Em2$$, \
$CellContext`\[Theta]$$ Degree, $CellContext`t]}, 
            PlotRange -> {{0, $CellContext`zmax}, {-1.1, 1.1}, {-1.1, 1.1}}], 
           $CellContext`LGEz[$CellContext`Em1$$, $CellContext`Em2$$, \
$CellContext`\[Theta]$$ Degree, $CellContext`t], 
           $CellContext`LGE0[$CellContext`Em1$$, $CellContext`Em2$$, \
$CellContext`\[Theta]$$ Degree, $CellContext`t], ImageSize -> 500], 
          Show[
           $CellContext`LGE02d[$CellContext`Em1$$, $CellContext`Em2$$, \
$CellContext`\[Theta]$$ Degree, $CellContext`t], 
           Graphics[{Thick, 
             Arrowheads[Large], 
             $CellContext`Etotxy[$CellContext`Em1$$, $CellContext`Em2$$, \
$CellContext`\[Theta]$$ Degree, $CellContext`t]}, 
            PlotRange -> {{-1.1, 1.1}, {-1.1, 1.1}}]]}], {$CellContext`t, 0, 
         2 ($CellContext`zmax/$CellContext`u)}, AnimationRate -> 
        1/(10 $CellContext`\[Omega])], 
      "Specifications" :> {{{$CellContext`Em1$$, 1}, 0, 
         1}, {{$CellContext`Em2$$, 1}, 0, 
         1}, {{$CellContext`\[Theta]$$, 0}, -90, 90}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{458., {203., 208.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.4844362951890078`*^9, 3.4844363079940076`*^9}, 
   3.484436344727008*^9, {3.4844364838390074`*^9, 3.4844365371600075`*^9}, {
   3.4844368718410077`*^9, 3.4844369218830075`*^9}, 3.4844371324810076`*^9, {
   3.484437197180008*^9, 3.4844372618880076`*^9}, {3.484437297517008*^9, 
   3.4844373620180073`*^9}, {3.4844373961060076`*^9, 3.4844373982620077`*^9}, 
   3.4844375191890078`*^9, 3.484437577680008*^9, {3.4844376199870076`*^9, 
   3.4844376664210076`*^9}, {3.4844377879030075`*^9, 3.484437809682008*^9}, {
   3.4844378476780076`*^9, 3.484437909831008*^9}, {3.4844379896440077`*^9, 
   3.4844380463950076`*^9}, {3.4844381379400077`*^9, 
   3.4844381736040077`*^9}, {3.4844388701150074`*^9, 
   3.4844389080480075`*^9}, {3.484439670031008*^9, 3.4844397408820076`*^9}, {
   3.4844401543530073`*^9, 3.4844401587630076`*^9}, 3.4844402150520077`*^9, {
   3.484440254878008*^9, 3.4844402651960077`*^9}, {3.4844403043600073`*^9, 
   3.4844403426640077`*^9}, {3.4844403802500076`*^9, 3.4844404068700075`*^9}, 
   3.4844404778470078`*^9, {3.4844405243140078`*^9, 3.484440631156008*^9}, {
   3.484479412027568*^9, 3.484479468935568*^9}, {3.4844795447795677`*^9, 
   3.484479591431568*^9}, 3.484479621582568*^9, {3.4844808022315683`*^9, 
   3.484480827092568*^9}, {3.484480869362568*^9, 3.4844808980615683`*^9}, {
   3.484481242441568*^9, 3.484481308766568*^9}, 3.484481359164568*^9, 
   3.484481407714568*^9, 3.4844814453305683`*^9, {3.484481489257568*^9, 
   3.484481507446568*^9}, {3.484481539532568*^9, 3.484481549491568*^9}, 
   3.484481638691568*^9, 3.484482188431568*^9, 3.484482268598568*^9, {
   3.484518373573*^9, 3.4845183825699997`*^9}, 3.4845188640950003`*^9, 
   3.484519054099*^9, {3.484519810184*^9, 3.484519816703*^9}, {
   3.48451987277*^9, 3.4845198782279997`*^9}, {3.484520111609*^9, 
   3.484520135704*^9}, 3.484520460922*^9, {3.484520929683*^9, 
   3.484520936712*^9}, {3.484521014271*^9, 3.484521027117*^9}, {
   3.4845211821470003`*^9, 3.484521221252*^9}, 3.484521429863*^9, 
   3.484521503462*^9, {3.4845219239560003`*^9, 3.4845219436099997`*^9}, {
   3.4845221149960003`*^9, 3.48452212008*^9}, {3.4845221972539997`*^9, 
   3.484522200891*^9}, {3.484522419593*^9, 3.484522457208*^9}, {
   3.484522511634*^9, 3.484522517615*^9}, {3.484522561474*^9, 
   3.484522588377*^9}, 3.484522619242*^9, {3.484522713701*^9, 
   3.484522742389*^9}, {3.484522791428*^9, 3.484522832429*^9}, {
   3.484522867991*^9, 3.484522871979*^9}, {3.484522936533*^9, 
   3.484522955823*^9}, {3.484522995535*^9, 3.484523018124*^9}, {
   3.495833288988*^9, 3.495833308326*^9}, 3.495833344333*^9, 
   3.5320387141626825`*^9, 3.532039967559373*^9}]
}, Open  ]]
},
WindowSize->{1051, 588},
WindowMargins->{{39, Automatic}, {Automatic, 9}},
FrontEndVersion->"8.0 for Microsoft Windows (64-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 261, 5, 31, "Input"],
Cell[831, 29, 471, 6, 30, "Output"]
}, Open  ]],
Cell[1317, 38, 867, 19, 112, "Input"],
Cell[2187, 59, 7459, 181, 386, "Input"],
Cell[CellGroupData[{
Cell[9671, 244, 6117, 124, 457, "Input"],
Cell[15791, 370, 5789, 99, 428, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
