/* Queremos que todos los threads se detengan en barrier()
   hasta que todos hayan llegado, momento en el que despiertan. */

super_calculo () {
    thread *me ;
    int my_id ;
    me = thread_current();
    my_id = me->tid ;
    parte_1_del_calculo();
    barrier(my_id);
    parte_2_del_calculo();
}


/* ================================== */


#include <synch.h>
#include <thread.h>

#define NUM_THREADS 25;

/* 
    La matriz de semáforos trabaja como una especie de "tabla 
    de avisos": el semáforo en [i][j] representa el aviso
    del thread i al j de que llegó a la barrera.
*/

struct semaphores[NUM_THREADS][NUM_THREADS];

init_semaphores() {
    int i, j, init_val;

    for (i = 0; i < NUM_THREADS; i++) {
        for (j = 0; j < NUM_THREADS; j++) {
            sem_init(&(semaphores[i][j], 0));
        }
    }
}

void barrier(int thread_id) {
    int i;
    /* Aviso a todos que llegué. */
    for (i = 0; i < NUM_THREADS; i++) {
        sema_up(&(semaphores[thread_id][i]));
    }

    /* Espero los avisos de todos */
    for (i = 0; i < NUM_THREADS; i++) {
        sema_down(&(semaphores[i][thread_id]));
    }
}





