#lang plai
(print-only-errors #t)

;; -> Libreta
(define (create-book) '())

;; Test
(test (create-book) '())

;; string string Libreta -> Libreta
(define (add-person name phone book)
  (cons (cons name phone) book))

;; TEst
(test (add-person "Jose" "1" (create-book)) '(("Jose" . "1")))

;; string Libreta -> bool
(define (in-book? name book)
  (cond
    ((empty? book) #f)
    (else (if (string=? name (car (car book)))
              #t
              (in-book? name (cdr book))))))



;; TEST
(test (in-book? "José" (add-person "José" "1" (create-book))) #t)
(test (in-book? "José" (add-person "Juan" "1" (create-book))) #f)

;; get-phone
;; string libreta -> string | #f 
(define (get-phone name book)
  (cond
    ((empty? book) #f)
    (else (if (string=? name (car (car book)))
              (cdr (car book))
              (get-phone name (cdr book))))))

;; string libreta ((string . string) -> A) -> A
(define (process-book name book f)
  (cond
    ((empty? book) #f)
    (else (if (string=? name (car (car book)))
              (f (car book)) ;; r = (car book) es el registro correcto
              (process-book name (cdr book) f)))))

(define (in-book2? name book)
  (process-book name book (λ (r) #t)))

(test (in-book2? "José" (add-person "José" "1" (create-book))) #t)
(test (in-book2? "José" (add-person "Juan" "1" (create-book))) #f)

(define (get-phone2 name book)
  (process-book name book (λ (r) (cdr r))))

(test (get-phone2 "José" (add-person "José" "1" (create-book))) "1")
(test (get-phone2 "José" (add-person "Juan" "1" (create-book))) #f)

;; test
(test (get-phone "José" (add-person "José" "1" (create-book))) "1")
(test (get-phone "José" (add-person "Juan" "1" (create-book))) #f)

(define-type Libreta
  [LibretaVacia]
  [Registro (name string?) (phone string?) (next Libreta?)])

;; -> Libreta
(define (create-book*)
  (LibretaVacia))

;; string string Libreta -> Libreta
(define (add-person* name phone book)
  (Registro name phone book)) 

(define (in-book?* name book)
  (type-case Libreta book
      [LibretaVacia () #f]
      [Registro (n p next) (if (string=? name n)
                               #t
                               (in-book?* name next))]))

(define (get-phone* name book)
  (type-case Libreta book
      [LibretaVacia () #f]
      [Registro (n phone next) (if (string=? name n)
                               phone
                               (get-phone* name next))]))

(define (process-book* name book f)
  (type-case Libreta book
      [LibretaVacia () #f]
      [Registro (n phone next) (if (string=? name n)
                               (f book)
                               (get-phone* name next))]))

(define (in-book2?* name book)
  (process-book* name book (λ (r) #t)))

(define (get-phone2* name book)
  (process-book* name book (λ (r) (Registro-phone r))))

  


(test (in-book?* "José" (add-person* "José" "1" (create-book*))) #t)
(test (in-book?* "José" (add-person* "Juan" "1" (create-book*))) #f)
(test (get-phone* "José" (add-person* "José" "1" (create-book*))) "1")
(test (get-phone* "José" (add-person* "Juan" "1" (create-book*))) #f)

(test (in-book2?* "José" (add-person* "José" "1" (create-book*))) #t)
(test (in-book2?* "José" (add-person* "Juan" "1" (create-book*))) #f)
(test (get-phone2* "José" (add-person* "José" "1" (create-book*))) "1")
(test (get-phone2* "José" (add-person* "Juan" "1" (create-book*))) #f)



