#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <fstream>
#include <map>
#include <vector>
#include <string>
#include <sstream>
#include "lista.h"
using namespace std;

int main (int argc, char* argv[]) {

	Lista *l = new Lista();
	cout<<"Imprimiendo l (antes de agregar): ";
	l->print();
	
	
	l->agregar(3, 5);
	l->agregar(5, 3);
	l->agregar(17,2);
	l->agregar(17, 7);
	cout<<"Imprimiendo l (despues de agregar): ";
	l->print();
	delete l;

	if(argc!=2){
		cerr<<"erroneo modo de uso."<<endl;
		cerr<<"Uso: p \"archivo de documentos\""<<endl;
		exit(-1);
	}
	
	//nombre del archivo a abrir
	char * archivodocs = argv[1];
	//ifstream que representa al archivo
	ifstream docs ( archivodocs , ifstream::in );
	//si el archivo esta abierto
	if(!docs.good()){
		cerr<<"Archivo no abierto, cerrando programa"<<endl;
		docs.close();
		exit(-1);

	}
	//creando el mapa
	// palabra, par(frectotal, Lista);
	map <string, pair <unsigned int, Lista* > > index_2;

	unsigned int doc_actual=0;

	while(docs.good()){
		string linea;
		getline(docs,linea);
		if(linea.size()==0){
			continue;
		}
		stringstream st(linea);
		map <string, int> mapa_aux;
		while(st.good()){
			string palabra;
			st >> palabra;
			if(palabra.size()==0){
				continue;
			}
			mapa_aux[palabra]++; //mapa_aux tiene todas las palabras del doc
			palabra.clear();
		}
		for(map <string,int>::iterator it=mapa_aux.begin(); it!=mapa_aux.end(); it++){
			string p = it->first;
			int f = it->second;
			//buscar p en index
			map <string, pair <unsigned int, Lista* > >::iterator it_search_2 = index_2.find(p);
			if(it_search_2!= index_2.end()){
                          //está -> actualiz
                          //actualizo la lista
                                  ((it_search_2->second).second)->agregar(doc_actual, f);
                                  //actualizar frec
                                  (it_search_2->second).first+=f;
                        }	
			else{
				//creo
			     	Lista * l = new Lista;
			        l->agregar(doc_actual, f);
			        index_2[p] =   pair <unsigned int, Lista * >(f,l);

			}
		}

		st.clear();
		linea.clear();
		doc_actual++;
	}
	docs.close();

	cout<<"numero de palabras ( index2) "<<index_2.size()<<endl;
	while(true){
		cout<<"Escriba una consulta%> ";
		string consulta;
		getline(cin,consulta);
		if(consulta.compare("-1")==0){
			break;
		}
		if(consulta.size()>0){
			cout<<"Consulta = "<<consulta<<endl;
			stringstream st(consulta);
			vector <string> palabras;
			while(st.good()){
				string pal;
				st>>pal;
				if(pal.size()>0){
					palabras.push_back(pal);
				}
			}
			cout<<"Número de palabras en la consulta = "<<palabras.size()<<endl;

			//contiene la interseccion de documentos
			vector<unsigned int> interseccion;
			//true si la interseccion es vacia
			bool empty = false;

			for(unsigned int i =0; i< palabras.size();i++){

				//contiene los documentos del ultimo termino (empty si el termino no esta)
				vector<unsigned int> actual_docs;
				//guarda un resultado parcial
				vector<unsigned int> aux;

				map <string, pair <unsigned int,Lista* > >::iterator it_search_2 = index_2.find(palabras[i]);
                                if(it_search_2 != index_2.end()){
                                        cout<<"Palabra "<<palabras[i]<<" si está :D"<<endl;
                                        cout<<"Docs = ";
                                        unsigned int number_docs= ((it_search_2->second).second)->num_doc();
                                        for(unsigned int j =0;j<number_docs;j++){
						int test = ((it_search_2->second).second)->get_doc(j);
                                                cout<<test<<" ";
                                                actual_docs.push_back(test);
                                        }
                                        cout<<endl;
                                }
                                else{
                                        cout<<"Palabra "<<palabras[i]<<" no está :("<<endl;
                                }

				

				if(!empty && !actual_docs.empty()){ //si la intersección no es nula y la palabra está
					if(interseccion.empty()){ //si es la primera palabra, la intersección son sus documentos
						aux = actual_docs;
					}
					else{ //si no es la primera palabra, se intersecta con la intersección calculada hasta el momento
						vector<unsigned int>:: iterator i1 = interseccion.begin();
						vector<unsigned int>:: iterator i2 = actual_docs.begin();
						while(i1 < interseccion.end() && i2 < actual_docs.end()){
							if(*i1==*i2){
								aux.push_back(*i1);
								i1++;
								i2++;
							}
							else if(*i1 < *i2){
								i1++;
							}
							else{
								i2++;
							}
						}
					}
				}
				else{ //si la palabra no está, la intersección es nula
					empty = true;
				}
				interseccion = aux; //se reemplaza por la nueva intersección
			}
			vector<unsigned int>:: iterator inter_it;
			cout << "Intersección: ";
			for(inter_it=interseccion.begin() ; inter_it < interseccion.end(); inter_it++ )
				cout << " " << *inter_it;
			cout << endl;
		}
		else{
			continue;
		}

	}

	return 0;
}
