#!/usr/bin/env python
# encoding: utf-8

from mpl_toolkits.axes_grid1 import host_subplot
from scipy import signal

import matplotlib.pyplot as plt
import mpl_toolkits.axisartist as AA
import numpy as np

def gaussian(x,A,x0,sigma):
    sigma = float(sigma)
    return A * np.exp( -0.5*((x-x0)/sigma)**2 )

min_x = -100
max_x =  100
delta =  1

N = (max_x - min_x)/delta
x = np.arange(min_x, max_x, delta)

# La senal son 4 gaussianas + ruido
my_signal = np.zeros(N)
my_signal += gaussian(x,1.0,0.0,10.0)
my_signal += gaussian(x,0.5,50,5.0)
my_signal += gaussian(x,0.8,-40,5.0)
my_signal += gaussian(x,0.4,-70,10.0)

# Agregamos ruido.
my_signal_n = my_signal + np.random.standard_normal(N) * 0.1

# Graficamos las señales
fig = plt.figure()
ax = host_subplot(111, axes_class=AA.Axes)
p1 = ax.plot(x, my_signal)
p2 = ax.plot(x, my_signal_n)
ax.legend([p1,p2], ["Original Signal","Noisy Signal"], fancybox=True, loc=2)
plt.draw()
plt.show()

# PRIMERA FORMA: MULTIPLICACION EN ESPACIO DE FOURIER
# cleaned_signal = IFFT( FFT(my_signal_n) * rectangulo1D )

# Calculamos la FFT de las señales y construimos el rectángulo
FFT_my_signal   = np.fft.fft (my_signal)
FFT_my_signal_n = np.fft.fft (my_signal_n)
D = N/16
rect = (x > -D) * (x < D)

# Graficamos la FFT de la señales y el rectángulo
ax = host_subplot(111, axes_class=AA.Axes)
p1 = ax.plot(x, np.fft.fftshift(FFT_my_signal).real)
p2 = ax.plot(x, np.fft.fftshift(FFT_my_signal_n).real)
p3 = ax.plot(x, rect*10) # multiplicado por 10 sólo para que se vea bien en el gráfico
ax.legend([p1,p2,p3], ["FFT Original Signal","FFT Noisy Signal","Rectangle"], fancybox=True, loc=2)
plt.draw()
plt.show()

# Cortamos las frecuencias altas (multiplicando por rect) y graficamos
FFT_rect = np.fft.fftshift(FFT_my_signal_n)*rect
ax = host_subplot(111, axes_class=AA.Axes)
p1 = ax.plot(x, FFT_rect.real, 'g')
ax.legend([p1], ["FFT Noisy Signal * Rectangle"], fancybox=True, loc=2)
plt.draw()
plt.show()

# IFFT y graficamos
cleaned_signal = np.fft.ifft(np.fft.ifftshift(FFT_rect))
ax = host_subplot(111, axes_class=AA.Axes)
p1 = ax.plot(x, my_signal)
p2 = ax.plot(x, cleaned_signal.real)
ax.legend([p1,p2], ["Original Signal","Cleaned Signal"], fancybox=True, loc=2)
plt.draw()
plt.show()


# SEGUNDA FORMA: CONVOLUCION EN ESPACIO TEMPORAL (O DE COORDENADAS)
# cleaned_signal = Convolve( my_signal_n , filtro_sinc )

#Graficamos el filtro (funcion sinc)
filtro_sinc = np.fft.fftshift(np.fft.ifft (np.fft.ifftshift(rect)))
ax = host_subplot(111, axes_class=AA.Axes)
p1 = ax.plot(x, filtro_sinc.real, 'k')
ax.legend([p1], ["Filtro: sinc(x)"], fancybox=True, loc=2)
plt.draw()
plt.show()

# Hacemos la convolución
cleaned_signal_conv = signal.convolve( my_signal_n , filtro_sinc , mode='same')

# Graficamos todo
ax = host_subplot(111, axes_class=AA.Axes)
p1 = ax.plot(x, my_signal)
p2 = ax.plot(x, cleaned_signal.real)
p3 = ax.plot(x, cleaned_signal_conv.real)
ax.legend([p1,p2,p3], ["Original Signal","C.Signal (FFT)","C.Signal (Conv)"], fancybox=True, loc=2)
plt.draw()
plt.show()
