#!/usr/bin/env python
# encoding: utf-8

from mpl_toolkits.mplot3d import Axes3D
from matplotlib import cm
from matplotlib.ticker import LinearLocator, FormatStrFormatter
import matplotlib.pyplot as plt
import numpy as np

# f(r) = exp(-r) * sin(r/(2 pi))
# f(x,y) = exp(-(x**2+y**2)**0.5) * sin((x**2+y**2)**0.5/(2*pi))

fig = plt.figure()
ax = fig.gca(projection='3d')
X = np.arange(-10, 10, 0.25)
Y = np.arange(-10, 10, 0.25)
X, Y = np.meshgrid(X, Y)
R = np.sqrt(X**2 + Y**2)
Z = np.exp(-R)*np.sin(R/(2*np.pi))
surf = ax.plot_surface(X, Y, Z, rstride=1, cstride=1, cmap=cm.jet,
        linewidth=0, antialiased=False)

fig.colorbar(surf, shrink=0.5, aspect=5)
plt.show()
