#!/usr/bin/env python
# encoding: utf-8

import pyfits

arch_img = pyfits.open('fpC-000756-r1-0205.fit')
header = arch_img[0].header
datos = arch_img[0].data

lenx = len(datos[0])
leny = len(datos)

coord_ra  = []
coord_dec = []
for i in range(leny):
    coord_ra.append([0]*lenx)
    coord_dec.append([0]*lenx)

ref_pix_x   = int(header['CRPIX1'])
ref_pix_y   = int(header['CRPIX2'])
ref_pix_ra  = float(header['CRVAL1'])
ref_pix_dec = float(header['CRVAL2'])

delta_ra_col = float(header['CD1_1'])
delta_ra_row = float(header['CD1_2'])
delta_dec_col = float(header['CD2_1'])
delta_dec_row = float(header['CD2_2'])

coord_ra[ref_pix_y][ref_pix_x] = ref_pix_ra
coord_dec[ref_pix_y][ref_pix_x] = ref_pix_dec

# 0 0 0 0 0 0 
# 0 0 0 x 0 0 >> value x in (ref_pix_x,ref_pix_y)
# 0 0 0 0 0 0 
# 0 0 0 0 0 0

lis_x_1 = range(ref_pix_x+1,lenx)
lis_x_2 = range(0,ref_pix_x)
lis_x_2.reverse()

for x in lis_x_1:
    coord_ra[ref_pix_y][x] = coord_ra[ref_pix_y][x-1] + delta_ra_col
    coord_dec[ref_pix_y][x] = coord_dec[ref_pix_y][x-1] + delta_dec_col

for x in lis_x_2:
    coord_ra[ref_pix_y][x] = coord_ra[ref_pix_y][x+1] - delta_ra_col
    coord_dec[ref_pix_y][x] = coord_dec[ref_pix_y][x+1] - delta_dec_col

lis_y_1 = range(ref_pix_y+1,leny)
lis_y_2 = range(0,ref_pix_y)
lis_y_2.reverse()

for x in range(lenx):
    for y in lis_y_1:
        coord_ra[y][x] = coord_ra[y-1][x] + delta_ra_row
        coord_dec[y][x] = coord_dec[y-1][x] + delta_dec_row
    for y in lis_y_2:
        coord_ra[y][x] = coord_ra[y+1][x] - delta_ra_row
        coord_dec[y][x] = coord_dec[y+1][x] - delta_dec_row

print ">> [0][0]           >> RA / DEC =", (coord_ra[0][0],coord_dec[0][0])
print ">> [0][lenx-1]      >> RA / DEC =", (coord_ra[0][lenx-1],coord_dec[0][lenx-1])
print ">> [leny-1][0]      >> RA / DEC =", (coord_ra[leny-1][0],coord_dec[leny-1][0])
print ">> [leny-1][lenx-1] >> RA / DEC =", (coord_ra[leny-1][lenx-1],coord_dec[leny-1][lenx-1])
