#!/usr/bin/env python
# encoding: utf-8

import pyfits
import math
import pylab

def log10(x):
    return math.log(x)/math.log(10)

# Abrir archivo y obtener matriz de datos
arch_img   = pyfits.open('fpC-005183-u2-0406.fit')
arch_table = pyfits.open('tsField-005183-2-40-0406.fit')

# Obtener algunas variables
kk_ugriz      = arch_table[1].data[0]['kk']
aa_ugriz      = arch_table[1].data[0]['aa']
airmass_ugriz = arch_table[1].data[0]['airmass']

kk_u      = kk_ugriz[0]
aa_u      = aa_ugriz[0]
airmass_u = airmass_ugriz[0]

exptime = float(arch_img[0].header['EXPTIME'])

##############################################################

# Suma de cuentas + circulo

data = arch_img[0].data
# 1 Calculo el máximo valor de un pixel
maximos = []
for lis in data:
    maximos.append(max(lis))
maximo = max(maximos)

# 2 Parámetros para recorrer matriz
lenx = len(data[0])
leny = len(data)
rad  = 5 #min(lenx,leny)/4
centerx = 1269 #lenx/2
centery = 1065 #leny/2
begin = centerx - rad
end   = centerx + rad
ptos  = range(begin,end+1)

# 3 Sumo la cuentas presentes en un circulo, sumando los valores de cada pixel (además dibujo circunferencia)
counts = 0.0
for x in ptos:
    dy = int( (rad**2-(x-centerx)**2)**0.5 )
    y1 = centery + dy # y1 > y2
    y2 = centery - dy
    for y in range(y2,y1+1):
	counts += data[y][x]
    data[y1][x] = maximo
    data[y2][x] = maximo

##############################################################

# Formula magica: f/f0 = counts/exptime * 10 ** ( 0.4*( aa + kk * airmass ) )
FF0 = counts/exptime * 10 ** ( 0.4*(aa_u + kk_u * airmass_u) )
print "F/F0 =",FF0

# Calculo de magnitud
mag = -2.5*log10(FF0)
print "Magnitud =",mag

# Despliego en un gráfico la información
pylab.imshow(data,origin='upper')
titulo = arch_img[0].header['OBJECT']+'\nmagnitud calculada = '+str(mag)
pylab.title(titulo)
pylab.show()
