#!/usr/bin/env python
# encoding: utf-8

import pyfits
import pylab

arch = pyfits.open('m64.fits')

print arch[0].header # Vemos el header !!
data = arch[0].data

maximos = []
for lis in data:
    maximos.append(max(lis))
maximo = max(maximos)

lenx = len(data[0])
leny = len(data)
rad  = min(lenx,leny)/4

centerx = lenx/2
centery = leny/2

begin = centerx - rad
end   = centerx + rad
ptos  = range(begin,end+1)

for x in ptos:
    y1 = int( centery + (rad**2-(x-centerx)**2)**0.5 )
    y2 = int( centery - (rad**2-(x-centerx)**2)**0.5 )
    data[y1][x] = maximo
    data[y2][x] = maximo

pylab.imshow(data,origin='upper')
pylab.show()
