struct paso {
	struct lock el_lock;
	struct condition esta_vacio;
	int n_desde_E, n_desde_O;
}
void entrar_por_O(struct paso *paso) {
	lock_acquire(&(paso->el_lock));
	while(paso->n_desde_E)
		cond_wait(&(paso->esta_vacio), &(paso->the_lock));
	paso->n_desde_O++;
	lock_release(paso->el_lock);
}
void salir_desde_O(struct paso *paso) {
	lock_acquire(&(paso->el_lock));
	if(!(--(paso->n_desde_O)))
		cond_broadcast(&(paso->esta_vacio), &(paso->el_lock));
	}
	lock_release(&(paso->el_lock));
}
/* Las funcionaes para E son simetricas */

/* Se puede producir hambruna si llegan vehiculos continuamente
   desde una direccion, no dejando que ingresen autos desde la otra. */


/* ==================================================== */

/* Esta solución resuelve hambruna, ya que "detecta" que hay autos
   en el lado "contrario" y eventualmente cambia la dirección de
   movimiento. */
#include <synch.h>
#define TURNO_E 1
#define TURNO_O 2

struct paso {
    struct lock el_lock;
    struct condition vacio; /* paso vacio */
    int n_dentro_E, n_dentro_O; /* cuantos autos vienen desde 1 y desde 2 */
    int n_espera_E, n_espera_O; /* esperando en 1 y en 2 */

    int turno;
    int pasaron;
    /* cuantos han pasado en este turno */
};

void entrar_por_O(struct paso *paso) {

    lock_acquire(&(paso->el_lock));

    paso->n_espera_O++;

    /* Si viene alguien desde la otra direccion, no puedo entrar al paso.
       Tampoco puedo entrar si es el turno de entrar de los contrarios, y existen 
       autos queriendo hacerlo. */

    while(paso->n_dentro_E || (paso->turno == TURNO_E && paso->n_espera_E > 0))
        cond_wait(&(paso->esta_vacio));

    paso->n_espera_O--;
    paso->n_dentro_O++;

    /* Una vez que ya entre al paso, no necesariamente sigue siendo el turno de entrar para mi direccion.
       Puede haber entrado alguien mas antes de mi, en mi direccion, y haber dejado turno en TURNO_E.
       Si no chequeara paso->turno == TURNO_O, podría resetear paso->pasaron cuando no debo. */

    if(paso->turno == TURNO_O && ++paso->pasaron >= 5) {
        paso->turno = TURNO_E;
        paso->pasaron = 0;
    }
    lock_release(&(paso->el_lock));
}


void salir_desde_O(struct paso *paso) {
    
    lock_acquire(&(paso->el_lock));

    if(!(--(paso->n_dentro_O))) cond_broadcast(&(paso->esta_vacio), &(paso->el_lock));

    lock_release(&(paso->el_lock));
}

/* De nuevo, las funciones para E son simetricas */
