#include<stdio.h>
#include<stdlib.h>
#include "jsocket6.h"
#include <sys/select.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include<signal.h>

#define BUFF_SIZE 1024
#define MAX_CLIENTS 2

main() {
  int s, cnt, i;
  int fds[MAX_CLIENTS];
  char buffer[BUFF_SIZE];
  pid_t pid;
  fd_set conjunto;

  signal(SIGPIPE, SIG_IGN);

  s = j_socket();

  for (i = 0;i < MAX_CLIENTS;i++)
    fds[i] = -1;

  if (j_bind(s,6666) < 0) {
    fprintf(stderr,"No pudo tomarse el puerto\n");
    exit(1);
  }
  
  for (;;) {
    FD_ZERO(&conjunto);
    FD_SET(s, &conjunto);
    
    for (i = 0;i < MAX_CLIENTS;i++) 
      if (fds[i] != -1 ) 
	FD_SET(fds[i],&conjunto);
    
    
    if (select(getdtablesize(), &conjunto, NULL,NULL,NULL) <= 0) {
      fprintf(stderr,"error en select\n");
      continue;
    }
    
    for (i = 0;i < MAX_CLIENTS;i++) 
      if (fds[i] != -1 && FD_ISSET(fds[i],&conjunto))  
	
	if ((cnt = read(fds[i],buffer,BUFF_SIZE-1) > 0) &&
	    (write(fds[i],buffer,cnt) > 0)) {
	  buffer[cnt]='\0';
	  printf("Leyo desde la red: %s\n",buffer);
	  
	  if (strncmp(buffer,"chao",4) == 0) {
	    close(fds[i]);
	    fds[i] = -1;
	  }
	  
	} else {
	  // cliente murio
	  fds[i] = -1;
	}
    
    
    
    if (FD_ISSET(s,&conjunto)) {
      printf("Llego conexion\n");
      
      for (i = 0;i < MAX_CLIENTS;i++)
	if (fds[i] == -1 ) break;
      
      if (i > MAX_CLIENTS) {
	// esta lleno
	printf("Esta lleno\n");
	close(j_accept(s));
	continue;
      }
      
      fds[i] = j_accept(s);
    }
  }
}
