#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <strings.h> 
#include <string.h>

#include "jsocket6.h"

/* Parche para MacOS: tbarros@niclabs.cl */
#ifndef AI_NUMERICSERV
#define AI_NUMERICSERV 0
#endif

/*
 * Version 2.0: con soporte transparente para IPv6
 *              API full compatible con los viejos jsockets
 *              Autores: Jo Piquer con ayuda de Sebastian Kreft, 2009
 * Version 2.1: Con mejor soporte para equipos no-IPv6
 */

/*
 * Retorna un socket para conexion
 */

/* Podriamos hacer una version que si ponemos ipv6=0 aqui no trata
 * siquiera de usarlo.
 * Por ahora tratamos de inferirlo automaticamente
 */


static int ipv6 = 1;

int j_socket()
{
    int sz = 1;
    int fd = 0; 
    /*
   fd = socket(PF_INET6, SOCK_STREAM, 0);
    if(fd < 0) {
	ipv6 = 0;
    */
	fd = socket(PF_INET, SOCK_STREAM, 0);
	/* } */
    if(fd < 0) { fprintf(stderr, "no pude hacer un socket\n");
		  return -1;
	       }
    setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, &sz, 4);
    return(fd);
}


/*
 * Pone un "nombre" (port) a un socket
 * y lo prepara para recibir conexiones
 * retorna 0 si OK, -1 si no
 */

int j_bind(s, port)
int s;
int port;
{
        struct sockaddr_in portname;

        /* ponemos el nombre 
	bzero(&portname, sizeof portname); 
        portname.sin6_port = htons(port);
        portname.sin6_family = AF_INET6;
        portname.sin6_addr = in6addr_any;
	*/
	bzero(&portname, sizeof portname); 
        portname.sin_port = htons(port);
        portname.sin_family = AF_INET;
	//        portname.sin_addr = inaddr_any;

        /* lo asociamos al socket */
        if( bind(s, (struct sockaddr *) &portname, sizeof portname) != 0)
                return(-1);

        listen(s, 5);
	return(0);
}

/*
 * Acepta una conexion pendiente o se bloquea esperando una
 * retorna un fd si OK, -1 si no
 */
int j_accept(s)
int s;
{
	struct sockaddr_in6 from;
	unsigned int size = sizeof(from);

	return( accept(s, (struct sockaddr *) &from, &size) );
}

/*
 * Se conecta con un port conocido
 * retorna 0 si OK, -1 si no
 */
int j_connect(s, host, port)
int s;
char *host;
int port;
{
        struct addrinfo hints;
	struct addrinfo *addresses, *hp;
	char sport[20];
  	int ret;

        sprintf(sport, "%d", port); 
        /* Traducir nombre a direccion IP */
	memset(&hints, 0, sizeof(struct addrinfo));
	// hints.ai_protocol = PF_INET6; // o vacio?
	hints.ai_protocol = 0;
	hints.ai_family = AF_INET;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_NUMERICSERV; /*  | AI_IDN; */
	//hints.ai_flags = AI_NUMERICSERV  /* Port es numerico */
		      // | AI_ADDRCONFIG   /* retornar IPv6 solo si yo tengo: no funciona bien */
		       //| AI_V4MAPPED|AI_ALL;  /* Retornar todo IPv4 en IPv6 */
                     /*  | AI_IDN;   *//* Aceptar nombres IDN: no estandar aun */

	ret = getaddrinfo(host, sport, &hints, &addresses);

	if( ret != 0 ) /* Mmmh, puede ser que no soporte bien IPv6? */
	  {
	    fprintf(stderr, "Name/port unknown: %s/%s err: %s\n", host, sport, gai_strerror(ret));
	    return(-1);
	  }
	
        /* Trato de conectarme con todas las direcciones IP del servidor */ 
	for(hp=addresses; hp != NULL; hp = hp->ai_next) {
	    if(connect(s, hp->ai_addr, hp->ai_addrlen) == 0) 
                break;
        }                                                 

	freeaddrinfo(addresses);

    	if(hp == NULL)
        /* No logre' conectarme */
            return -1;
	else
	    return 0;
}
