#include<stdio.h>
#include<unistd.h>
#include<pthread.h>
#include<errno.h>
#include<semaphore.h>
#include<time.h>

struct data {
  int (*f)();
  int result;
  sem_t sem;
};
  

call_f(struct data *my_data) {
 
  // pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);
  printf("Empieza funcion\n");

  my_data->result = my_data->f();
  printf("Termina funcion\n");
  
  sem_post(&my_data->sem);
  
}

int call_with_timeout(int (*f)(), int milisec) {
  pthread_t pid;
  struct data my_data;
  struct timespec timeout;

  my_data.f = f;
  
  clock_gettime(CLOCK_REALTIME, &timeout);
  timeout.tv_sec += milisec / 1000;
  timeout.tv_nsec += (milisec % 1000) * 1000000;

  sem_init(&my_data.sem,0,0);
  
  pthread_create(&pid,NULL,(void *)call_f,&my_data);
  
  errno = 0;
  while (sem_timedwait(&my_data.sem,&timeout)) 
    switch errno {
      case ETIMEDOUT:
	printf("TIMEOUT\n");
	pthread_cancel(pid);
	return(-1);
	break;
      case EAGAIN:
	continue;
      default:
	printf("Hubo error\n");
      }

  return(my_data.result);

}

int ls() {
  printf("Invoca ls\n");
  sleep(5);
  return(0);
}
 
main() {
    printf("llamando a ls con timeout (3 veces)\n");
    printf("debiera ser -1, retorna: %d\n", call_with_timeout(ls, 1000));
    printf("debiera ser 0, retorna: %d\n", call_with_timeout(ls, 10000));
    // printf("debiera ser -1, retorna: %d\n", call_with_timeout(ls, 1000));
 
}
